/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.aspect;

import com.netsteadfast.greenstep.aspect.AspectConstants;
import com.netsteadfast.greenstep.aspect.IBaseAspectService;
import com.netsteadfast.greenstep.base.Constants;
import com.netsteadfast.greenstep.base.exception.AuthorityException;
import com.netsteadfast.greenstep.base.exception.ServiceException;
import com.netsteadfast.greenstep.sys.GreenStepHessianUtils;
import com.netsteadfast.greenstep.util.ServiceScriptExpressionUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Order(value=10)
@Aspect
@Component
public class ServiceScriptExpressionProcessAspect
implements IBaseAspectService {
    protected Logger logger = Logger.getLogger(ServiceScriptExpressionProcessAspect.class);

    @Override
    public Object dataAccessObjectProcess(ProceedingJoinPoint pjp) throws AuthorityException, ServiceException, Throwable {
        return pjp.proceed();
    }

    @Override
    public Object baseServiceProcess(ProceedingJoinPoint pjp) throws AuthorityException, ServiceException, Throwable {
        return pjp.proceed();
    }

    @Override
    @Around(value=" execution(* com.netsteadfast.greenstep.base.service.logic.*.*(..) ) || execution(* com.netsteadfast.greenstep.service.logic..*.*(..) ) || execution(* com.netsteadfast.greenstep.bsc.service.logic..*.*(..) ) || execution(* com.netsteadfast.greenstep.qcharts.service.logic..*.*(..) ) ")
    public Object logicServiceProcess(ProceedingJoinPoint pjp) throws AuthorityException, ServiceException, Throwable {
        Annotation[] annotations = pjp.getTarget().getClass().getAnnotations();
        MethodSignature signature = (MethodSignature)pjp.getSignature();
        if (annotations == null || annotations.length < 1) {
            return pjp.proceed();
        }
        String beanId = AspectConstants.getServiceId(annotations);
        if (GreenStepHessianUtils.isEnableCallRemote() && GreenStepHessianUtils.isProxyServiceId(beanId)) {
            return pjp.proceed();
        }
        if (StringUtils.isBlank(beanId)) {
            return pjp.proceed();
        }
        if (!ServiceScriptExpressionUtils.needProcess(beanId, signature.getMethod().getName(), Constants.getSystem())) {
            return pjp.proceed();
        }
        Method method = signature.getMethod();
        ServiceScriptExpressionUtils.processBefore(beanId, signature.getMethod(), Constants.getSystem(), pjp);
        Object obj = pjp.proceed();
        ServiceScriptExpressionUtils.processAfter(beanId, method, Constants.getSystem(), obj, pjp);
        return obj;
    }
}

