/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.aspect;

import com.netsteadfast.greenstep.aspect.AspectConstants;
import com.netsteadfast.greenstep.aspect.IBaseAspectService;
import com.netsteadfast.greenstep.base.Constants;
import com.netsteadfast.greenstep.base.SysMessageUtil;
import com.netsteadfast.greenstep.base.exception.AuthorityException;
import com.netsteadfast.greenstep.base.exception.ServiceException;
import com.netsteadfast.greenstep.base.model.ServiceAuthority;
import com.netsteadfast.greenstep.base.model.ServiceMethodAuthority;
import com.netsteadfast.greenstep.base.model.ServiceMethodType;
import com.netsteadfast.greenstep.sys.SysEventLogSupport;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.subject.Subject;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Order(value=0)
@Aspect
@Component
public class ServiceAuthorityCheckAspect
implements IBaseAspectService {
    protected Logger logger = Logger.getLogger(ServiceAuthorityCheckAspect.class);

    @Override
    public Object dataAccessObjectProcess(ProceedingJoinPoint pjp) throws AuthorityException, ServiceException, Throwable {
        return pjp.proceed();
    }

    @Override
    public Object baseServiceProcess(ProceedingJoinPoint pjp) throws AuthorityException, ServiceException, Throwable {
        return pjp.proceed();
    }

    @Override
    @Around(value=" execution(* com.netsteadfast.greenstep.base.service.logic.*.*(..) ) || execution(* com.netsteadfast.greenstep.service.logic..*.*(..) ) || execution(* com.netsteadfast.greenstep.bsc.service.logic..*.*(..) ) || execution(* com.netsteadfast.greenstep.qcharts.service.logic..*.*(..) ) ")
    public Object logicServiceProcess(ProceedingJoinPoint pjp) throws AuthorityException, ServiceException, Throwable {
        MethodSignature signature = (MethodSignature)pjp.getSignature();
        Annotation[] annotations = pjp.getTarget().getClass().getAnnotations();
        String serviceId = AspectConstants.getServiceId(annotations);
        Subject subject = SecurityUtils.getSubject();
        Method method = signature.getMethod();
        if (subject.hasRole("*") || subject.hasRole("admin")) {
            SysEventLogSupport.log((String)subject.getPrincipal(), Constants.getSystem(), this.getEventId(serviceId, method.getName()), true);
            return pjp.proceed();
        }
        if (StringUtils.isBlank(serviceId)) {
            SysEventLogSupport.log((String)subject.getPrincipal(), Constants.getSystem(), this.getEventId(serviceId, method.getName()), true);
            return pjp.proceed();
        }
        if (!this.isServiceAuthorityCheck(annotations)) {
            SysEventLogSupport.log((String)subject.getPrincipal(), Constants.getSystem(), this.getEventId(serviceId, method.getName()), true);
            return pjp.proceed();
        }
        Annotation[] methodAnnotations = method.getAnnotations();
        if (this.isServiceMethodAuthority(serviceId, methodAnnotations, subject)) {
            SysEventLogSupport.log((String)subject.getPrincipal(), Constants.getSystem(), this.getEventId(serviceId, method.getName()), true);
            return pjp.proceed();
        }
        this.logger.warn("[decline] user[" + subject.getPrincipal() + "] " + pjp.getTarget().getClass().getName() + " - " + signature.getMethod().getName());
        SysEventLogSupport.log((String)subject.getPrincipal(), Constants.getSystem(), this.getEventId(serviceId, method.getName()), false);
        throw new AuthorityException(SysMessageUtil.get("MSG_BSE0001"));
    }

    private boolean isServiceAuthorityCheck(Annotation[] annotations) {
        if (annotations == null || annotations.length < 1) {
            return false;
        }
        boolean check = false;
        Annotation[] annotationArray = annotations;
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation anno = annotationArray[n2];
            if (anno instanceof ServiceAuthority) {
                check = ((ServiceAuthority)anno).check();
            }
            ++n2;
        }
        return check;
    }

    private boolean isServiceMethodAuthority(String serviceId, Annotation[] annotations, Subject subject) {
        if (annotations == null || annotations.length < 1) {
            return true;
        }
        boolean status = false;
        boolean foundServiceMethodAuthority = false;
        Annotation[] annotationArray = annotations;
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation anno = annotationArray[n2];
            if (anno instanceof ServiceMethodAuthority) {
                foundServiceMethodAuthority = true;
                ServiceMethodType[] types = ((ServiceMethodAuthority)anno).type();
                int i = 0;
                while (types != null && !status && i < types.length) {
                    ServiceMethodType type = types[i];
                    String methodPerm = String.valueOf(serviceId) + "#" + type.toString();
                    if (subject.isPermitted(methodPerm)) {
                        status = true;
                    }
                    ++i;
                }
            }
            ++n2;
        }
        if (!foundServiceMethodAuthority) {
            return true;
        }
        return status;
    }

    private String getEventId(String serviceId, String methodName) {
        return String.valueOf(serviceId) + "@" + methodName;
    }
}

