/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.aspect;

import com.caucho.hessian.client.HessianProxyFactory;
import com.netsteadfast.greenstep.aspect.AspectConstants;
import com.netsteadfast.greenstep.aspect.IBaseAspectService;
import com.netsteadfast.greenstep.base.Constants;
import com.netsteadfast.greenstep.base.exception.AuthorityException;
import com.netsteadfast.greenstep.base.exception.ServiceException;
import com.netsteadfast.greenstep.base.model.PageOf;
import com.netsteadfast.greenstep.base.model.QueryResult;
import com.netsteadfast.greenstep.sys.GreenStepHessianProxyFactory;
import com.netsteadfast.greenstep.sys.GreenStepHessianUtils;
import com.netsteadfast.greenstep.util.ApplicationSiteUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.apache.shiro.SecurityUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Order(value=1)
@Aspect
@Component
public class HessianServiceProxyAspect
implements IBaseAspectService {
    protected Logger logger = Logger.getLogger(HessianServiceProxyAspect.class);

    @Override
    @Around(value=" execution(* com.netsteadfast.greenstep.base.service.logic.*.*(..) ) || execution(* com.netsteadfast.greenstep.service.logic..*.*(..) ) || execution(* com.netsteadfast.greenstep.bsc.service.logic..*.*(..) ) || execution(* com.netsteadfast.greenstep.qcharts.service.logic..*.*(..) ) ")
    public Object logicServiceProcess(ProceedingJoinPoint pjp) throws AuthorityException, ServiceException, Throwable {
        if (!GreenStepHessianUtils.isEnableCallRemote()) {
            return pjp.proceed();
        }
        return this.proxyProcess(pjp);
    }

    @Override
    @Around(value=" execution(* com.netsteadfast.greenstep.base.service.*.*(..) ) || execution(* com.netsteadfast.greenstep.service.*.*(..) ) || execution(* com.netsteadfast.greenstep.bsc.service.*.*(..) ) || execution(* com.netsteadfast.greenstep.qcharts.service.*.*(..) ) ")
    public Object baseServiceProcess(ProceedingJoinPoint pjp) throws AuthorityException, ServiceException, Throwable {
        if (!GreenStepHessianUtils.isEnableCallRemote()) {
            return pjp.proceed();
        }
        return this.proxyProcess(pjp);
    }

    @Override
    public Object dataAccessObjectProcess(ProceedingJoinPoint pjp) throws AuthorityException, ServiceException, Throwable {
        return pjp.proceed();
    }

    private void setReCalculateSizePageOfForPageFindGridResult(Object resultObj, Object[] params) {
        if (resultObj == null || !(resultObj instanceof QueryResult)) {
            return;
        }
        if (params == null || params.length < 1) {
            return;
        }
        PageOf pageOf = null;
        int i = 0;
        while (i < params.length && pageOf == null) {
            if (params[i] instanceof PageOf) {
                pageOf = (PageOf)params[i];
            }
            ++i;
        }
        if (pageOf == null) {
            return;
        }
        QueryResult result = (QueryResult)resultObj;
        pageOf.setCountSize(String.valueOf(result.getRowCount()));
        pageOf.toCalculateSize();
    }

    private Object proxyProcess(ProceedingJoinPoint pjp) throws AuthorityException, ServiceException, Throwable {
        String theSystemPath;
        Class<?>[] serviceInterfaces;
        MethodSignature signature = (MethodSignature)pjp.getSignature();
        Annotation[] annotations = pjp.getTarget().getClass().getAnnotations();
        String serviceId = AspectConstants.getServiceId(annotations);
        if (!GreenStepHessianUtils.isProxyServiceId(serviceId)) {
            return pjp.proceed();
        }
        String userId = StringUtils.defaultString((String)SecurityUtils.getSubject().getPrincipal());
        if (GreenStepHessianUtils.getConfigHessianHeaderCheckValueModeEnable()) {
            if (StringUtils.isBlank(userId)) {
                this.logger.warn("no userId");
                return pjp.proceed();
            }
            if (GreenStepHessianUtils.isProxyBlockedAccountId(userId)) {
                this.logger.warn("reject proxy service: " + serviceId + " , blocked userId: " + userId);
                return pjp.proceed();
            }
        }
        String serviceInterfacesName = "";
        Class<?>[] classArray = serviceInterfaces = pjp.getTarget().getClass().getInterfaces();
        int n = serviceInterfaces.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> clazz = classArray[n2];
            if (clazz.getName().indexOf(".service.") > -1) {
                serviceInterfacesName = clazz.getName();
            }
            ++n2;
        }
        if (StringUtils.isBlank(serviceInterfacesName)) {
            this.logger.error("error no service interface: " + serviceId);
            throw new Exception("error no service interface: " + serviceId);
        }
        String url = GreenStepHessianUtils.getServiceUrl(serviceId);
        if (url.indexOf(theSystemPath = String.valueOf(ApplicationSiteUtils.getHost(Constants.getSystem())) + "/" + ApplicationSiteUtils.getContextPath(Constants.getSystem())) > -1) {
            this.logger.error("cannot open same-server. now system contextPath = " + theSystemPath + " , but proxy url = " + url);
            throw new Exception("cannot open same-server. now system contextPath = " + theSystemPath + " , but proxy url = " + url);
        }
        this.logger.info("proxy url = " + url);
        HessianProxyFactory factory = null;
        Object proxyServiceObject = null;
        if (GreenStepHessianUtils.getConfigHessianHeaderCheckValueModeEnable()) {
            factory = new GreenStepHessianProxyFactory();
            ((GreenStepHessianProxyFactory)factory).setHeaderCheckValue(GreenStepHessianUtils.getEncAuthValue(userId));
            proxyServiceObject = ((GreenStepHessianProxyFactory)factory).createForHeaderMode(Class.forName(serviceInterfacesName), url);
        } else {
            factory = new HessianProxyFactory();
            proxyServiceObject = factory.create(Class.forName(serviceInterfacesName), url);
        }
        Method[] proxyObjectMethods = proxyServiceObject.getClass().getMethods();
        Method proxyObjectMethod = null;
        if (proxyObjectMethods == null) {
            this.logger.error("error no find proxy method: " + serviceId);
            throw new Exception("error no find proxy method: " + serviceId);
        }
        Method[] methodArray = proxyObjectMethods;
        int n3 = proxyObjectMethods.length;
        int n4 = 0;
        while (n4 < n3) {
            Method m = methodArray[n4];
            if (m.getName().equals(signature.getMethod().getName()) && Arrays.equals(m.getParameterTypes(), signature.getMethod().getParameterTypes())) {
                proxyObjectMethod = m;
            }
            ++n4;
        }
        if (proxyObjectMethod == null) {
            this.logger.error("error no execute proxy method: " + serviceId);
            throw new Exception("error no execute proxy method: " + serviceId);
        }
        Object resultObj = null;
        try {
            resultObj = proxyObjectMethod.invoke(proxyServiceObject, pjp.getArgs());
            this.setReCalculateSizePageOfForPageFindGridResult(resultObj, pjp.getArgs());
        }
        catch (InvocationTargetException e) {
            if (e.getMessage() != null) {
                throw new ServiceException(e.getMessage().toString());
            }
            if (e.getTargetException().getMessage() != null) {
                throw new ServiceException(e.getTargetException().getMessage().toString());
            }
            throw e;
        }
        catch (Exception e) {
            this.logger.error(e.getMessage().toString());
            throw e;
        }
        this.logger.info("proxy success: " + serviceId + " method: " + proxyObjectMethod.getName());
        return resultObj;
    }
}

