/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.action;

import com.netsteadfast.greenstep.base.action.BaseSupportAction;
import com.netsteadfast.greenstep.base.exception.AuthorityException;
import com.netsteadfast.greenstep.base.exception.ControllerException;
import com.netsteadfast.greenstep.base.exception.ServiceException;
import com.netsteadfast.greenstep.base.model.ControllerAuthority;
import com.netsteadfast.greenstep.util.JFreeChartDataMapperUtils;
import java.awt.Color;
import java.awt.Font;
import java.util.Map;
import org.apache.commons.lang3.math.NumberUtils;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.dial.DialBackground;
import org.jfree.chart.plot.dial.DialCap;
import org.jfree.chart.plot.dial.DialPlot;
import org.jfree.chart.plot.dial.DialPointer;
import org.jfree.chart.plot.dial.DialTextAnnotation;
import org.jfree.chart.plot.dial.DialValueIndicator;
import org.jfree.chart.plot.dial.StandardDialFrame;
import org.jfree.chart.plot.dial.StandardDialRange;
import org.jfree.chart.plot.dial.StandardDialScale;
import org.jfree.data.general.DefaultValueDataset;
import org.jfree.ui.GradientPaintTransformType;
import org.jfree.ui.StandardGradientPaintTransformer;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;

@ControllerAuthority(check=false)
@Controller(value="core.web.controller.CommonMeterChartAction")
@Scope
public class CommonMeterChartAction
extends BaseSupportAction {
    private static final long serialVersionUID = 1058965576843823374L;
    private JFreeChart chart = null;
    private String oid = "";
    private String width = "";
    private String height = "";

    private void createChart() throws Exception {
        Map<String, Object> dataMap = JFreeChartDataMapperUtils.getChartData2Map(this.oid);
        if (dataMap == null) {
            return;
        }
        String title = String.valueOf(dataMap.get("title"));
        float value = NumberUtils.toFloat(String.valueOf(dataMap.get("value")));
        Integer lowerBound = (Integer)dataMap.get("lowerBound");
        Integer upperBound = (Integer)dataMap.get("upperBound");
        this.width = String.valueOf((Integer)dataMap.get("width"));
        this.height = String.valueOf((Integer)dataMap.get("height"));
        this.fillChart(title, value, lowerBound, upperBound);
    }

    @Override
    public String execute() throws Exception {
        String forward = "searchNoData";
        try {
            this.createChart();
            forward = "success";
        }
        catch (AuthorityException | ControllerException | ServiceException e) {
            this.setPageMessage(e.getMessage().toString());
        }
        catch (Exception e) {
            this.exceptionPage(e);
        }
        return forward;
    }

    private void fillChart(String title, float value, int lowerBound, int upperBound) throws Exception {
        DefaultValueDataset dataset = new DefaultValueDataset();
        dataset.setValue(Float.valueOf(value));
        DialPlot plot = new DialPlot();
        plot.setView(0.0, 0.0, 1.0, 1.0);
        plot.setDataset(0, dataset);
        StandardDialFrame frame = new StandardDialFrame();
        plot.setDialFrame(frame);
        DialBackground dialBackground = new DialBackground();
        dialBackground.setGradientPaintTransformer(new StandardGradientPaintTransformer(GradientPaintTransformType.VERTICAL));
        plot.setBackground(dialBackground);
        DialTextAnnotation textAnnotation = new DialTextAnnotation(title);
        textAnnotation.setRadius(0.5555555555555556);
        plot.addLayer(textAnnotation);
        DialValueIndicator valueIndicator = new DialValueIndicator(0);
        plot.addLayer(valueIndicator);
        StandardDialScale scale1 = new StandardDialScale();
        scale1.setLowerBound(lowerBound);
        scale1.setUpperBound(upperBound);
        scale1.setStartAngle(-140.0);
        scale1.setExtent(-260.0);
        scale1.setTickRadius(0.88);
        scale1.setTickLabelOffset(0.15);
        scale1.setTickLabelFont(new Font("", 0, 14));
        plot.addScale(0, scale1);
        StandardDialRange standarddialrange0 = new StandardDialRange(lowerBound, (double)upperBound * 0.6, Color.red);
        standarddialrange0.setInnerRadius(0.52);
        standarddialrange0.setOuterRadius(0.55);
        plot.addLayer(standarddialrange0);
        StandardDialRange standarddialrange1 = new StandardDialRange((double)upperBound * 0.6, (double)upperBound * 0.8, Color.orange);
        standarddialrange1.setInnerRadius(0.52);
        standarddialrange1.setOuterRadius(0.55);
        plot.addLayer(standarddialrange1);
        StandardDialRange standarddialrange2 = new StandardDialRange((double)upperBound * 0.8, upperBound, Color.green);
        standarddialrange2.setInnerRadius(0.52);
        standarddialrange2.setOuterRadius(0.55);
        plot.addLayer(standarddialrange2);
        DialPointer.Pointer pointer = new DialPointer.Pointer(0);
        pointer.setFillPaint(new Color(144, 196, 246));
        plot.addPointer(pointer);
        plot.mapDatasetToScale(0, 0);
        DialCap dialcap = new DialCap();
        dialcap.setRadius(0.0700000000000001);
        plot.setCap(dialcap);
        this.chart = new JFreeChart(plot);
        this.chart.setBackgroundPaint(Color.white);
    }

    public JFreeChart getChart() {
        return this.chart;
    }

    public String getOid() {
        return this.oid;
    }

    public void setOid(String oid) {
        this.oid = oid;
    }

    public String getWidth() {
        return this.width;
    }

    public void setWidth(String width) {
        this.width = width;
    }

    public String getHeight() {
        return this.height;
    }

    public void setHeight(String height) {
        this.height = height;
    }
}

