/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.action;

import com.netsteadfast.greenstep.base.action.BaseSupportAction;
import com.netsteadfast.greenstep.base.exception.AuthorityException;
import com.netsteadfast.greenstep.base.exception.ControllerException;
import com.netsteadfast.greenstep.base.exception.ServiceException;
import com.netsteadfast.greenstep.base.model.ControllerAuthority;
import com.netsteadfast.greenstep.util.JFreeChartDataMapperUtils;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.util.List;
import java.util.Map;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.title.TextTitle;
import org.jfree.data.category.DefaultCategoryDataset;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;

@ControllerAuthority(check=false)
@Controller(value="core.web.controller.CommonBarChartAction")
@Scope
public class CommonBarChartAction
extends BaseSupportAction {
    private static final long serialVersionUID = 6793725011684681103L;
    private JFreeChart chart = null;
    private String oid = "";
    private String width = "";
    private String height = "";

    private void createChart() throws Exception {
        Map<String, Object> dataMap = JFreeChartDataMapperUtils.getChartData2Map(this.oid);
        if (dataMap == null) {
            return;
        }
        List names = (List)dataMap.get("names");
        List values = (List)dataMap.get("values");
        List colors = (List)dataMap.get("colors");
        String horizontal = (String)dataMap.get("horizontal");
        this.width = String.valueOf((Integer)dataMap.get("width"));
        this.height = String.valueOf((Integer)dataMap.get("height"));
        this.fillChart((String)dataMap.get("title"), (String)dataMap.get("categoryLabel"), (String)dataMap.get("valueLabel"), names, values, colors, "Y".equals(horizontal));
    }

    private void fillChart(String title, String categoryLabel, String valueLabel, List<String> names, List<Float> values, List<String> colors, boolean horizontal) throws Exception {
        DefaultCategoryDataset data = new DefaultCategoryDataset();
        int ix = 0;
        while (ix < names.size()) {
            data.addValue(values.get(ix), (Comparable)((Object)""), (Comparable)((Object)names.get(ix)));
            ++ix;
        }
        this.chart = ChartFactory.createBarChart3D(title, categoryLabel, valueLabel, data, horizontal ? PlotOrientation.HORIZONTAL : PlotOrientation.VERTICAL, false, false, false);
        CategoryPlot plot = (CategoryPlot)this.chart.getPlot();
        CategoryAxis categoryAxis = plot.getDomainAxis();
        categoryAxis.setLabelFont(new Font("", 0, 9));
        categoryAxis.setTickLabelFont(new Font("", 0, 9));
        NumberAxis numberAxis = (NumberAxis)plot.getRangeAxis();
        numberAxis.setLabelFont(new Font("", 0, 9));
        this.setPlotColor(plot, names, colors);
        this.chart.setTitle(new TextTitle(title, new Font("", 0, 9)));
    }

    private void setPlotColor(CategoryPlot plot, List<String> names, List<String> colors) throws Exception {
        Paint[] paints = new Paint[colors.size()];
        int ix = 0;
        while (ix < names.size()) {
            paints[ix] = Color.decode(colors.get(ix));
            ++ix;
        }
        CustomRenderer renderer = new CustomRenderer(paints);
        plot.setRenderer(renderer);
    }

    @Override
    public String execute() throws Exception {
        String forward = "searchNoData";
        try {
            this.createChart();
            forward = "success";
        }
        catch (AuthorityException | ControllerException | ServiceException e) {
            this.setPageMessage(e.getMessage().toString());
        }
        catch (Exception e) {
            this.exceptionPage(e);
        }
        return forward;
    }

    public JFreeChart getChart() {
        return this.chart;
    }

    public String getOid() {
        return this.oid;
    }

    public void setOid(String oid) {
        this.oid = oid;
    }

    public String getWidth() {
        return this.width;
    }

    public void setWidth(String width) {
        this.width = width;
    }

    public String getHeight() {
        return this.height;
    }

    public void setHeight(String height) {
        this.height = height;
    }

    class CustomRenderer
    extends BarRenderer {
        private static final long serialVersionUID = -478703865753319803L;
        private Paint[] colors;

        public CustomRenderer(Paint[] colors) {
            this.colors = colors;
        }

        @Override
        public Paint getItemPaint(int row, int column) {
            return this.colors[column % this.colors.length];
        }
    }
}

