/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.app.rest.runtime;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.activiti.app.model.idm.UserRepresentation;
import org.activiti.app.model.runtime.TaskRepresentation;
import org.activiti.app.model.runtime.TaskUpdateRepresentation;
import org.activiti.app.security.SecurityUtils;
import org.activiti.app.service.api.UserCache;
import org.activiti.app.service.exception.NotFoundException;
import org.activiti.app.service.runtime.PermissionService;
import org.activiti.app.service.util.TaskUtil;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.HistoryService;
import org.activiti.engine.IdentityService;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.TaskService;
import org.activiti.engine.history.HistoricIdentityLink;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.identity.User;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskInfo;
import org.activiti.engine.task.TaskQuery;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractTaskResource {
    private static final Logger logger = LoggerFactory.getLogger(AbstractTaskResource.class);
    @Autowired
    protected TaskService taskService;
    @Autowired
    protected HistoryService historyService;
    @Autowired
    protected UserCache userCache;
    @Autowired
    protected PermissionService permissionService;
    @Autowired
    protected RepositoryService repositoryService;
    @Autowired
    protected IdentityService identityService;

    public TaskRepresentation getTask(String taskId, HttpServletResponse response) {
        User currentUser = SecurityUtils.getCurrentUserObject();
        HistoricTaskInstance task = this.permissionService.validateReadPermissionOnTask(currentUser, taskId);
        ProcessDefinition processDefinition = null;
        if (StringUtils.isNotEmpty((CharSequence)task.getProcessDefinitionId())) {
            try {
                processDefinition = this.repositoryService.getProcessDefinition(task.getProcessDefinitionId());
            }
            catch (ActivitiException e) {
                logger.error("Error getting process definition " + task.getProcessDefinitionId(), (Throwable)e);
            }
        }
        TaskRepresentation rep = new TaskRepresentation((TaskInfo)task, processDefinition);
        TaskUtil.fillPermissionInformation((TaskRepresentation)rep, (TaskInfo)task, (User)currentUser, (IdentityService)this.identityService, (HistoryService)this.historyService, (RepositoryService)this.repositoryService);
        this.populateAssignee((TaskInfo)task, rep);
        rep.setInvolvedPeople(this.getInvolvedUsers(taskId));
        return rep;
    }

    protected void populateAssignee(TaskInfo task, TaskRepresentation rep) {
        UserCache.CachedUser cachedUser;
        if (task.getAssignee() != null && (cachedUser = this.userCache.getUser(task.getAssignee())) != null && cachedUser.getUser() != null) {
            rep.setAssignee(new UserRepresentation(cachedUser.getUser()));
        }
    }

    protected List<UserRepresentation> getInvolvedUsers(String taskId) {
        List idLinks = this.historyService.getHistoricIdentityLinksForTask(taskId);
        ArrayList<UserRepresentation> result = new ArrayList<UserRepresentation>(idLinks.size());
        for (HistoricIdentityLink link : idLinks) {
            UserCache.CachedUser cachedUser;
            if (link.getUserId() == null || "assignee".equals(link.getType()) || (cachedUser = this.userCache.getUser(link.getUserId())) == null || cachedUser.getUser() == null) continue;
            result.add(new UserRepresentation(cachedUser.getUser()));
        }
        return result;
    }

    public TaskRepresentation updateTask(String taskId, TaskUpdateRepresentation updated) {
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
        if (task == null) {
            throw new NotFoundException("Task with id: " + taskId + " does not exist");
        }
        this.permissionService.validateReadPermissionOnTask(SecurityUtils.getCurrentUserObject(), task.getId());
        if (updated.isNameSet()) {
            task.setName(updated.getName());
        }
        if (updated.isDescriptionSet()) {
            task.setDescription(updated.getDescription());
        }
        if (updated.isDueDateSet()) {
            task.setDueDate(updated.getDueDate());
        }
        this.taskService.saveTask(task);
        return new TaskRepresentation(task);
    }
}

