/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.app.rest.runtime;

import javax.servlet.http.HttpServletResponse;
import org.activiti.app.model.runtime.ProcessInstanceRepresentation;
import org.activiti.app.security.SecurityUtils;
import org.activiti.app.service.api.UserCache;
import org.activiti.app.service.exception.NotFoundException;
import org.activiti.app.service.runtime.PermissionService;
import org.activiti.app.service.runtime.ProcessInstanceService;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.StartEvent;
import org.activiti.engine.HistoryService;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.identity.User;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.form.api.FormRepositoryService;
import org.activiti.form.api.FormService;
import org.activiti.form.model.CompletedFormDefinition;
import org.activiti.form.model.FormDefinition;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractProcessInstanceResource {
    private static final Logger logger = LoggerFactory.getLogger(AbstractProcessInstanceResource.class);
    @Autowired
    protected RepositoryService repositoryService;
    @Autowired
    protected HistoryService historyService;
    @Autowired
    protected RuntimeService runtimeService;
    @Autowired
    protected FormRepositoryService formRepositoryService;
    @Autowired
    protected FormService formService;
    @Autowired
    protected PermissionService permissionService;
    @Autowired
    protected ProcessInstanceService processInstanceService;
    @Autowired
    protected UserCache userCache;

    public ProcessInstanceRepresentation getProcessInstance(String processInstanceId, HttpServletResponse response) {
        UserCache.CachedUser user;
        HistoricProcessInstance processInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        if (!this.permissionService.hasReadPermissionOnProcessInstance(SecurityUtils.getCurrentUserObject(), processInstance, processInstanceId)) {
            throw new NotFoundException("Process with id: " + processInstanceId + " does not exist or is not available for this user");
        }
        ProcessDefinitionEntity processDefinition = (ProcessDefinitionEntity)this.repositoryService.getProcessDefinition(processInstance.getProcessDefinitionId());
        User userRep = null;
        if (processInstance.getStartUserId() != null && (user = this.userCache.getUser(processInstance.getStartUserId())) != null && user.getUser() != null) {
            userRep = user.getUser();
        }
        ProcessInstanceRepresentation processInstanceResult = new ProcessInstanceRepresentation(processInstance, (ProcessDefinition)processDefinition, processDefinition.isGraphicalNotationDefined(), userRep);
        FormDefinition formDefinition = this.getStartFormDefinition(processInstance.getProcessDefinitionId(), processDefinition, processInstance.getId());
        if (formDefinition != null) {
            processInstanceResult.setStartFormDefined(true);
        }
        return processInstanceResult;
    }

    public FormDefinition getProcessInstanceStartForm(String processInstanceId, HttpServletResponse response) {
        HistoricProcessInstance processInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        if (!this.permissionService.hasReadPermissionOnProcessInstance(SecurityUtils.getCurrentUserObject(), processInstance, processInstanceId)) {
            throw new NotFoundException("Process with id: " + processInstanceId + " does not exist or is not available for this user");
        }
        ProcessDefinitionEntity processDefinition = (ProcessDefinitionEntity)this.repositoryService.getProcessDefinition(processInstance.getProcessDefinitionId());
        return this.getStartFormDefinition(processInstance.getProcessDefinitionId(), processDefinition, processInstance.getId());
    }

    public void deleteProcessInstance(String processInstanceId) {
        User currentUser = SecurityUtils.getCurrentUserObject();
        HistoricProcessInstance processInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).startedBy(String.valueOf(currentUser.getId())).singleResult();
        if (processInstance == null) {
            throw new NotFoundException("Process with id: " + processInstanceId + " does not exist or is not started by this user");
        }
        if (processInstance.getEndTime() != null) {
            if (!this.permissionService.canDeleteProcessInstance(currentUser, processInstance)) {
                throw new NotFoundException("Process with id: " + processInstanceId + " is already completed and can't be deleted");
            }
            this.processInstanceService.deleteProcessInstance(processInstanceId);
        } else {
            this.runtimeService.deleteProcessInstance(processInstanceId, "Cancelled by " + SecurityUtils.getCurrentUserId());
        }
    }

    protected FormDefinition getStartFormDefinition(String processDefinitionId, ProcessDefinitionEntity processDefinition, String processInstanceId) {
        StartEvent startEvent;
        CompletedFormDefinition formDefinition = null;
        BpmnModel bpmnModel = this.repositoryService.getBpmnModel(processDefinitionId);
        Process process = bpmnModel.getProcessById(processDefinition.getKey());
        FlowElement startElement = process.getInitialFlowElement();
        if (startElement instanceof StartEvent && StringUtils.isNotEmpty((CharSequence)(startEvent = (StartEvent)startElement).getFormKey())) {
            formDefinition = this.formService.getCompletedTaskFormDefinitionByKeyAndParentDeploymentId(startEvent.getFormKey(), processDefinition.getDeploymentId(), null, processInstanceId, null, processDefinition.getTenantId());
        }
        return formDefinition;
    }
}

