/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.app.rest.runtime;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.activiti.app.model.common.ResultListDataRepresentation;
import org.activiti.app.model.runtime.ProcessDefinitionRepresentation;
import org.activiti.app.service.runtime.PermissionService;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.StartEvent;
import org.activiti.editor.language.json.converter.util.CollectionUtils;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.repository.Deployment;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.repository.ProcessDefinitionQuery;
import org.activiti.form.api.FormRepositoryService;
import org.activiti.form.model.FormDefinition;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractProcessDefinitionsResource {
    @Autowired
    protected RepositoryService repositoryService;
    @Autowired
    protected FormRepositoryService formRepositoryService;
    @Autowired
    protected PermissionService permissionService;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ResultListDataRepresentation getProcessDefinitions(Boolean latest, String deploymentKey) {
        ProcessDefinitionQuery definitionQuery = this.repositoryService.createProcessDefinitionQuery();
        if (deploymentKey != null) {
            Deployment deployment = (Deployment)this.repositoryService.createDeploymentQuery().deploymentKey(deploymentKey).latest().singleResult();
            if (deployment == null) return new ResultListDataRepresentation(new ArrayList());
            definitionQuery.deploymentId(deployment.getId());
        } else if (latest != null && latest.booleanValue()) {
            definitionQuery.latestVersion();
        }
        List definitions = definitionQuery.list();
        return new ResultListDataRepresentation(this.convertDefinitionList(definitions));
    }

    protected List<ProcessDefinitionRepresentation> convertDefinitionList(List<ProcessDefinition> definitions) {
        HashMap<String, Boolean> startFormMap = new HashMap<String, Boolean>();
        ArrayList<ProcessDefinitionRepresentation> result = new ArrayList<ProcessDefinitionRepresentation>();
        if (CollectionUtils.isNotEmpty(definitions)) {
            for (ProcessDefinition processDefinition : definitions) {
                if (!startFormMap.containsKey(processDefinition.getId())) {
                    BpmnModel bpmnModel = this.repositoryService.getBpmnModel(processDefinition.getId());
                    List startEvents = bpmnModel.getMainProcess().findFlowElementsOfType(StartEvent.class, false);
                    boolean hasStartForm = false;
                    for (StartEvent startEvent : startEvents) {
                        FormDefinition formDefinition;
                        if (!StringUtils.isNotEmpty((CharSequence)startEvent.getFormKey()) || (formDefinition = this.formRepositoryService.getFormDefinitionByKey(startEvent.getFormKey())) == null) continue;
                        hasStartForm = true;
                        break;
                    }
                    startFormMap.put(processDefinition.getId(), hasStartForm);
                }
                ProcessDefinitionRepresentation rep = new ProcessDefinitionRepresentation(processDefinition);
                rep.setHasStartForm(((Boolean)startFormMap.get(processDefinition.getId())).booleanValue());
                result.add(rep);
            }
        }
        return result;
    }
}

