/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.bsc.webservice.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netsteadfast.greenstep.base.AppContext;
import com.netsteadfast.greenstep.base.Constants;
import com.netsteadfast.greenstep.base.SysMessageUtil;
import com.netsteadfast.greenstep.base.exception.ServiceException;
import com.netsteadfast.greenstep.base.model.ChainResultObj;
import com.netsteadfast.greenstep.base.model.DefaultResult;
import com.netsteadfast.greenstep.base.service.logic.BscBaseLogicServiceCommonSupport;
import com.netsteadfast.greenstep.bsc.command.KpiReportBodyCommand;
import com.netsteadfast.greenstep.bsc.model.BscStructTreeObj;
import com.netsteadfast.greenstep.bsc.service.IEmployeeService;
import com.netsteadfast.greenstep.bsc.service.IOrganizationService;
import com.netsteadfast.greenstep.bsc.service.IVisionService;
import com.netsteadfast.greenstep.bsc.util.BscReportSupportUtils;
import com.netsteadfast.greenstep.bsc.util.PerformanceScoreChainUtils;
import com.netsteadfast.greenstep.bsc.vo.BscApiServiceResponse;
import com.netsteadfast.greenstep.bsc.webservice.ApiWebService;
import com.netsteadfast.greenstep.po.hbm.BbMeasureData;
import com.netsteadfast.greenstep.sys.WsAuthenticateUtils;
import com.netsteadfast.greenstep.util.ApplicationSiteUtils;
import com.netsteadfast.greenstep.util.HostUtils;
import com.netsteadfast.greenstep.util.JFreeChartDataMapperUtils;
import com.netsteadfast.greenstep.util.UploadSupportUtils;
import com.netsteadfast.greenstep.vo.DateRangeScoreVO;
import com.netsteadfast.greenstep.vo.EmployeeVO;
import com.netsteadfast.greenstep.vo.KpiVO;
import com.netsteadfast.greenstep.vo.ObjectiveVO;
import com.netsteadfast.greenstep.vo.OrganizationVO;
import com.netsteadfast.greenstep.vo.PerspectiveVO;
import com.netsteadfast.greenstep.vo.VisionVO;
import com.thoughtworks.xstream.XStream;
import java.util.LinkedList;
import javax.annotation.Resource;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.xml.ws.WebServiceContext;
import org.apache.commons.chain.Context;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.subject.Subject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="bsc.webservice.ApiWebService")
@WebService
@SOAPBinding
@Path(value="/")
@Produces(value={"application/json"})
public class ApiWebServiceImpl
implements ApiWebService {
    private static final int MeterChart_width = 320;
    private static final int MeterChart_height = 280;
    private WebServiceContext webServiceContext;

    public WebServiceContext getWebServiceContext() {
        return this.webServiceContext;
    }

    @Autowired
    @Resource(name="webServiceContext")
    public void setWebServiceContext(WebServiceContext webServiceContext) {
        this.webServiceContext = webServiceContext;
    }

    private int getMeterChartLowerBound(float score, float min) {
        if (score < min) {
            return (int)score;
        }
        return (int)min;
    }

    private int getMeterChartUpperBound(float score, float target) {
        if (score > target) {
            return (int)score;
        }
        return (int)target;
    }

    private void processForScorecard(BscApiServiceResponse responseObj, HttpServletRequest request, String visionOid, String startDate, String endDate, String startYearDate, String endYearDate, String frequency, String dataFor, String measureDataOrganizationOid, String measureDataEmployeeOid, String contentFlag) throws ServiceException, Exception {
        Context context = PerformanceScoreChainUtils.getContext(visionOid, startDate, endDate, startYearDate, endYearDate, frequency, dataFor, measureDataOrganizationOid, measureDataEmployeeOid);
        ChainResultObj result = PerformanceScoreChainUtils.getResult(context);
        if (result.getValue() == null || ((BscStructTreeObj)result.getValue()).getVisions() == null || ((BscStructTreeObj)result.getValue()).getVisions().size() == 0) {
            return;
        }
        String meterChartBaseUrl = "";
        String barChartBaseUrl = "";
        String pieChartBaseUrl = "";
        String url = "";
        url = request != null ? ApplicationSiteUtils.getBasePath(Constants.getSystem(), request) : String.valueOf(HostUtils.getHostAddress()) + ":" + HostUtils.getHttpPort() + "/" + ApplicationSiteUtils.getContextPath(Constants.getSystem());
        if (!url.endsWith("/")) {
            url = String.valueOf(url) + "/";
        }
        meterChartBaseUrl = String.valueOf(url) + "bsc.commonMeterChartAction.action";
        barChartBaseUrl = String.valueOf(url) + "bsc.commonBarChartAction.action";
        pieChartBaseUrl = String.valueOf(url) + "bsc.commonPieChartAction.action";
        BscStructTreeObj resultObj = (BscStructTreeObj)result.getValue();
        KpiReportBodyCommand reportBody = new KpiReportBodyCommand();
        reportBody.execute(context);
        Object htmlBody = reportBody.getResult(context);
        if (htmlBody != null && htmlBody instanceof String) {
            String htmlUploadOid = UploadSupportUtils.create(Constants.getSystem(), "tmp", false, String.valueOf(htmlBody).getBytes(), "KPI-HTML-REPORT.html");
            url = String.valueOf(url) + "bsc.printContentAction.action?oid=" + htmlUploadOid;
            responseObj.setHtmlBodyUrl(url);
        }
        VisionVO visionObj = resultObj.getVisions().get(0);
        for (PerspectiveVO perspective : visionObj.getPerspectives()) {
            String perspectiveMeterChartOid = JFreeChartDataMapperUtils.createMeterData(perspective.getName(), perspective.getScore(), this.getMeterChartLowerBound(perspective.getScore(), perspective.getMin()), this.getMeterChartUpperBound(perspective.getScore(), perspective.getTarget()), 320, 280);
            responseObj.getPerspectivesMeterChartUrl().add(String.valueOf(meterChartBaseUrl) + "?oid=" + perspectiveMeterChartOid);
            for (ObjectiveVO objective : perspective.getObjectives()) {
                String objectiveMeterChartOid = JFreeChartDataMapperUtils.createMeterData(objective.getName(), (int)objective.getScore(), this.getMeterChartLowerBound(objective.getScore(), objective.getMin()), this.getMeterChartUpperBound(objective.getScore(), objective.getTarget()), 320, 280);
                responseObj.getObjectivesMeterChartUrl().add(String.valueOf(meterChartBaseUrl) + "?oid=" + objectiveMeterChartOid);
                for (KpiVO kpiVO : objective.getKpis()) {
                    String kpiMeterChartOid = JFreeChartDataMapperUtils.createMeterData(kpiVO.getName(), kpiVO.getScore(), this.getMeterChartLowerBound(kpiVO.getScore(), kpiVO.getMin()), this.getMeterChartUpperBound(kpiVO.getScore(), kpiVO.getTarget()), 320, 280);
                    responseObj.getKpisMeterChartUrl().add(String.valueOf(meterChartBaseUrl) + "?oid=" + kpiMeterChartOid);
                }
            }
        }
        String barUploadOid = "";
        String pieUploadOid = "";
        LinkedList<String> names = new LinkedList<String>();
        LinkedList<Float> values = new LinkedList<Float>();
        LinkedList<String> colors = new LinkedList<String>();
        for (PerspectiveVO perspective : visionObj.getPerspectives()) {
            names.add(String.valueOf(perspective.getName()) + "(" + BscReportSupportUtils.parse2(perspective.getScore()) + ")");
            values.add(Float.valueOf(perspective.getScore()));
            colors.add(perspective.getBgColor());
        }
        barUploadOid = JFreeChartDataMapperUtils.createBarData(visionObj.getTitle(), "Score", "", names, values, colors, 480, 280, false);
        pieUploadOid = JFreeChartDataMapperUtils.createPieData(visionObj.getTitle(), names, values, colors, 480, 280);
        responseObj.setPieChartUrl(String.valueOf(pieChartBaseUrl) + "?oid=" + pieUploadOid);
        responseObj.setBarChartUrl(String.valueOf(barChartBaseUrl) + "?oid=" + barUploadOid);
        PerformanceScoreChainUtils.clearExpressionContentOut(visionObj);
        responseObj.setSuccess("Y");
        if ("Y".equals(contentFlag)) {
            ObjectMapper objectMapper = new ObjectMapper();
            String string = objectMapper.writeValueAsString(visionObj);
            XStream xstream = new XStream();
            xstream.setMode(1001);
            xstream.alias("vision", VisionVO.class);
            xstream.alias("perspective", PerspectiveVO.class);
            xstream.alias("objective", ObjectiveVO.class);
            xstream.alias("kpi", KpiVO.class);
            xstream.alias("measureData", BbMeasureData.class);
            xstream.alias("dateRangeScore", DateRangeScoreVO.class);
            xstream.alias("employee", EmployeeVO.class);
            xstream.alias("organization", OrganizationVO.class);
            String xmlData = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + xstream.toXML(visionObj);
            responseObj.setOutJsonData(string);
            responseObj.setOutXmlData(xmlData);
        }
    }

    @Override
    @WebMethod
    @GET
    @Path(value="/scorecard1/")
    public BscApiServiceResponse getScorecard1(@WebParam(name="visionOid") @QueryParam(value="visionOid") String visionOid, @WebParam(name="startDate") @QueryParam(value="startDate") String startDate, @WebParam(name="endDate") @QueryParam(value="endDate") String endDate, @WebParam(name="startYearDate") @QueryParam(value="startYearDate") String startYearDate, @WebParam(name="endYearDate") @QueryParam(value="endYearDate") String endYearDate, @WebParam(name="frequency") @QueryParam(value="frequency") String frequency, @WebParam(name="dataFor") @QueryParam(value="dataFor") String dataFor, @WebParam(name="measureDataOrganizationOid") @QueryParam(value="measureDataOrganizationOid") String measureDataOrganizationOid, @WebParam(name="measureDataEmployeeOid") @QueryParam(value="measureDataEmployeeOid") String measureDataEmployeeOid, @WebParam(name="contentFlag") @QueryParam(value="contentFlag") String contentFlag) throws Exception {
        BscApiServiceResponse responseObj;
        Subject subject;
        block9: {
            HttpServletRequest request = null;
            if (this.getWebServiceContext() != null && this.getWebServiceContext().getMessageContext() != null) {
                request = (HttpServletRequest)this.getWebServiceContext().getMessageContext().get((Object)"javax.xml.ws.servlet.request");
            }
            subject = null;
            responseObj = new BscApiServiceResponse();
            responseObj.setSuccess("N");
            try {
                try {
                    subject = WsAuthenticateUtils.login();
                    this.processForScorecard(responseObj, request, visionOid, startDate, endDate, startYearDate, endYearDate, frequency, dataFor, measureDataOrganizationOid, measureDataEmployeeOid, contentFlag);
                }
                catch (Exception e) {
                    responseObj.setMessage(e.getMessage());
                    if (!"Y".equals(responseObj.getSuccess())) {
                        responseObj.setMessage(SysMessageUtil.get("MSG_DOS0009"));
                    }
                    WsAuthenticateUtils.logout(subject);
                    break block9;
                }
            }
            catch (Throwable throwable) {
                if (!"Y".equals(responseObj.getSuccess())) {
                    responseObj.setMessage(SysMessageUtil.get("MSG_DOS0009"));
                }
                WsAuthenticateUtils.logout(subject);
                throw throwable;
            }
            if (!"Y".equals(responseObj.getSuccess())) {
                responseObj.setMessage(SysMessageUtil.get("MSG_DOS0009"));
            }
            WsAuthenticateUtils.logout(subject);
        }
        subject = null;
        return responseObj;
    }

    @Override
    @WebMethod
    @GET
    @Path(value="/scorecard2/")
    public BscApiServiceResponse getScorecard2(@WebParam(name="visionId") @QueryParam(value="visionId") String visionId, @WebParam(name="startDate") @QueryParam(value="startDate") String startDate, @WebParam(name="endDate") @QueryParam(value="endDate") String endDate, @WebParam(name="startYearDate") @QueryParam(value="startYearDate") String startYearDate, @WebParam(name="endYearDate") @QueryParam(value="endYearDate") String endYearDate, @WebParam(name="frequency") @QueryParam(value="frequency") String frequency, @WebParam(name="dataFor") @QueryParam(value="dataFor") String dataFor, @WebParam(name="measureDataOrganizationId") @QueryParam(value="measureDataOrganizationId") String measureDataOrganizationId, @WebParam(name="measureDataEmployeeId") @QueryParam(value="measureDataEmployeeId") String measureDataEmployeeId, @WebParam(name="contentFlag") @QueryParam(value="contentFlag") String contentFlag) throws Exception {
        BscApiServiceResponse responseObj;
        Subject subject;
        block12: {
            HttpServletRequest request = null;
            if (this.getWebServiceContext() != null && this.getWebServiceContext().getMessageContext() != null) {
                request = (HttpServletRequest)this.getWebServiceContext().getMessageContext().get((Object)"javax.xml.ws.servlet.request");
            }
            subject = null;
            responseObj = new BscApiServiceResponse();
            responseObj.setSuccess("N");
            try {
                try {
                    subject = WsAuthenticateUtils.login();
                    IVisionService visionService = (IVisionService)AppContext.getBean("bsc.service.VisionService");
                    IEmployeeService employeeService = (IEmployeeService)AppContext.getBean("bsc.service.EmployeeService");
                    IOrganizationService organizationService = (IOrganizationService)AppContext.getBean("bsc.service.OrganizationService");
                    String visionOid = "";
                    String measureDataOrganizationOid = "";
                    String measureDataEmployeeOid = "";
                    DefaultResult<VisionVO> visionResult = visionService.findForSimpleByVisId(visionId);
                    if (visionResult.getValue() == null) {
                        throw new Exception(visionResult.getSystemMessage().getValue());
                    }
                    visionOid = visionResult.getValue().getOid();
                    if (StringUtils.isBlank(measureDataOrganizationId)) {
                        measureDataOrganizationOid = BscBaseLogicServiceCommonSupport.findEmployeeDataByEmpId(employeeService, measureDataOrganizationId).getOid();
                    }
                    if (StringUtils.isBlank(measureDataEmployeeId)) {
                        measureDataEmployeeOid = BscBaseLogicServiceCommonSupport.findOrganizationDataByUK(organizationService, measureDataEmployeeId).getOid();
                    }
                    this.processForScorecard(responseObj, request, visionOid, startDate, endDate, startYearDate, endYearDate, frequency, dataFor, measureDataOrganizationOid, measureDataEmployeeOid, contentFlag);
                }
                catch (Exception e) {
                    responseObj.setMessage(e.getMessage());
                    if (!"Y".equals(responseObj.getSuccess())) {
                        responseObj.setMessage(SysMessageUtil.get("MSG_DOS0009"));
                    }
                    WsAuthenticateUtils.logout(subject);
                    break block12;
                }
            }
            catch (Throwable throwable) {
                if (!"Y".equals(responseObj.getSuccess())) {
                    responseObj.setMessage(SysMessageUtil.get("MSG_DOS0009"));
                }
                WsAuthenticateUtils.logout(subject);
                throw throwable;
            }
            if (!"Y".equals(responseObj.getSuccess())) {
                responseObj.setMessage(SysMessageUtil.get("MSG_DOS0009"));
            }
            WsAuthenticateUtils.logout(subject);
        }
        subject = null;
        return responseObj;
    }
}

