/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.bsc.util;

import com.netsteadfast.greenstep.base.AppContext;
import com.netsteadfast.greenstep.base.SysMessageUtil;
import com.netsteadfast.greenstep.base.exception.ServiceException;
import com.netsteadfast.greenstep.base.model.DefaultResult;
import com.netsteadfast.greenstep.bsc.compoments.BaseWorkspaceCompoment;
import com.netsteadfast.greenstep.bsc.service.IWorkspaceCompomentService;
import com.netsteadfast.greenstep.bsc.service.IWorkspaceConfigService;
import com.netsteadfast.greenstep.bsc.service.IWorkspaceLabelService;
import com.netsteadfast.greenstep.bsc.service.IWorkspaceService;
import com.netsteadfast.greenstep.bsc.service.IWorkspaceTemplateService;
import com.netsteadfast.greenstep.po.hbm.BbWorkspace;
import com.netsteadfast.greenstep.po.hbm.BbWorkspaceCompoment;
import com.netsteadfast.greenstep.po.hbm.BbWorkspaceConfig;
import com.netsteadfast.greenstep.po.hbm.BbWorkspaceLabel;
import com.netsteadfast.greenstep.po.hbm.BbWorkspaceTemplate;
import com.netsteadfast.greenstep.util.TemplateUtils;
import com.netsteadfast.greenstep.vo.WorkspaceCompomentVO;
import com.netsteadfast.greenstep.vo.WorkspaceConfigVO;
import com.netsteadfast.greenstep.vo.WorkspaceLabelVO;
import com.netsteadfast.greenstep.vo.WorkspaceTemplateVO;
import com.netsteadfast.greenstep.vo.WorkspaceVO;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class WorkspaceUtils {
    private static final String RESOURCE_DIR = "META-INF/resource/";
    private static final String TEMPLATE_VARIABLE_NAME = "POSITION_";
    private static IWorkspaceService<WorkspaceVO, BbWorkspace, String> workspaceService = (IWorkspaceService)AppContext.getBean("bsc.service.WorkspaceService");
    private static IWorkspaceTemplateService<WorkspaceTemplateVO, BbWorkspaceTemplate, String> workspaceTemplateService = (IWorkspaceTemplateService)AppContext.getBean("bsc.service.WorkspaceTemplateService");
    private static IWorkspaceCompomentService<WorkspaceCompomentVO, BbWorkspaceCompoment, String> workspaceCompomentService = (IWorkspaceCompomentService)AppContext.getBean("bsc.service.WorkspaceCompomentService");
    private static IWorkspaceConfigService<WorkspaceConfigVO, BbWorkspaceConfig, String> workspaceConfigService = (IWorkspaceConfigService)AppContext.getBean("bsc.service.WorkspaceConfigService");
    private static IWorkspaceLabelService<WorkspaceLabelVO, BbWorkspaceLabel, String> workspaceLabelService = (IWorkspaceLabelService)AppContext.getBean("bsc.service.WorkspaceLabelService");

    public static String getTemplateConfResource(String templateOid) throws ServiceException, Exception {
        if (StringUtils.isBlank(templateOid)) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0001"));
        }
        WorkspaceTemplateVO template = new WorkspaceTemplateVO();
        template.setOid(templateOid);
        DefaultResult<WorkspaceTemplateVO> result = workspaceTemplateService.findObjectByOid(template);
        if (result.getValue() == null) {
            throw new ServiceException(result.getSystemMessage().getValue());
        }
        template = result.getValue();
        String content = TemplateUtils.getResourceSrc(WorkspaceUtils.class.getClassLoader(), RESOURCE_DIR + template.getResourceConf());
        if (StringUtils.isBlank(content)) {
            content = "";
        }
        return content;
    }

    public static String getView(String basePath, String workspaceOid, String visionOid, String year, String uploadOid) throws ServiceException, Exception {
        HashMap<String, Object> templateParameters = new HashMap<String, Object>();
        templateParameters.put("basePath", basePath);
        templateParameters.put("uploadOid", uploadOid);
        templateParameters.put("visionOid", visionOid);
        templateParameters.put("startYear", year);
        templateParameters.put("endYear", year);
        return WorkspaceUtils.getContent(workspaceOid, true, templateParameters);
    }

    public static String getLayoutForView(String workspaceOid) throws ServiceException, Exception {
        return WorkspaceUtils.getContent(workspaceOid, false, null);
    }

    private static String getContent(String workspaceOid, boolean defaultMode, Map<String, Object> templateParameters) throws ServiceException, Exception {
        if (StringUtils.isBlank(workspaceOid)) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0001"));
        }
        WorkspaceVO workspace = new WorkspaceVO();
        workspace.setOid(workspaceOid);
        DefaultResult<WorkspaceVO> result = workspaceService.findObjectByOid(workspace);
        if (result.getValue() == null) {
            throw new ServiceException(result.getSystemMessage().getValue());
        }
        workspace = result.getValue();
        if (defaultMode) {
            templateParameters.put("title", workspace.getName());
        }
        WorkspaceTemplateVO template = new WorkspaceTemplateVO();
        template.setTemplateId(workspace.getTemplateId());
        DefaultResult<WorkspaceTemplateVO> wtResult = workspaceTemplateService.findByUK(template);
        if (wtResult.getValue() == null) {
            throw new ServiceException(wtResult.getSystemMessage().getValue());
        }
        template = wtResult.getValue();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("spaceId", workspace.getSpaceId());
        List<BbWorkspaceConfig> configs = workspaceConfigService.findListByParams(params);
        String content = TemplateUtils.processTemplate("resourceTemplate", WorkspaceUtils.class.getClassLoader(), RESOURCE_DIR + template.getResource(), WorkspaceUtils.fillTemplateParameters(template, configs, defaultMode, templateParameters));
        if (StringUtils.isBlank(content)) {
            content = "";
        }
        return content;
    }

    private static Map<String, Object> fillTemplateParameters(WorkspaceTemplateVO template, List<BbWorkspaceConfig> configs, boolean defaultMode, Map<String, Object> templateParameters) throws ServiceException, Exception {
        HashMap<String, Object> parameter = new HashMap<String, Object>();
        int position = 0;
        while (position < template.getPositionSize()) {
            String content = "";
            int c = 0;
            while (configs != null && c < configs.size()) {
                BbWorkspaceConfig config = configs.get(c);
                if (config.getPosition() == position) {
                    WorkspaceCompomentVO compoment = new WorkspaceCompomentVO();
                    compoment.setCompId(config.getCompId());
                    DefaultResult<WorkspaceCompomentVO> cResult = workspaceCompomentService.findByUK(compoment);
                    if (cResult.getValue() == null) {
                        throw new ServiceException(cResult.getSystemMessage().getValue());
                    }
                    compoment = cResult.getValue();
                    if (defaultMode) {
                        try {
                            WorkspaceUtils.setTitle(config, templateParameters);
                            content = WorkspaceUtils.getCompomentRenderBody(compoment, templateParameters);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    } else {
                        content = WorkspaceUtils.getCompomentImage(compoment);
                    }
                }
                ++c;
            }
            parameter.put(TEMPLATE_VARIABLE_NAME + position, content);
            ++position;
        }
        return parameter;
    }

    private static void setTitle(BbWorkspaceConfig config, Map<String, Object> templateParameters) throws ServiceException, Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("spaceId", config.getSpaceId());
        params.put("position", config.getPosition());
        List labels = workspaceLabelService.findListByParams(params);
        if (labels == null || labels.size() < 1) {
            return;
        }
        for (BbWorkspaceLabel label : labels) {
            templateParameters.put("title", label.getLabel());
        }
    }

    private static String getCompomentRenderBody(WorkspaceCompomentVO compoment, Map<String, Object> templateParameters) throws Exception {
        Class<?> clazz = Class.forName(compoment.getClassName());
        BaseWorkspaceCompoment compomentObj = (BaseWorkspaceCompoment)clazz.newInstance();
        compomentObj.loadFromId(compoment.getCompId());
        compomentObj.getParameters().putAll(templateParameters);
        compomentObj.doRender();
        return StringUtils.defaultString(compomentObj.getBody());
    }

    private static String getCompomentImage(WorkspaceCompomentVO compoment) {
        return "<img src=\"./compoment-images/" + compoment.getImage() + "\" border=\"0\" alt=\"" + compoment.getName() + "\" />";
    }
}

