/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.bsc.util;

import com.netsteadfast.greenstep.base.AppContext;
import com.netsteadfast.greenstep.base.exception.ServiceException;
import com.netsteadfast.greenstep.base.model.DefaultResult;
import com.netsteadfast.greenstep.base.service.logic.BscBaseLogicServiceCommonSupport;
import com.netsteadfast.greenstep.bsc.service.IEmployeeService;
import com.netsteadfast.greenstep.bsc.service.IKpiService;
import com.netsteadfast.greenstep.bsc.service.IMonitorItemScoreService;
import com.netsteadfast.greenstep.bsc.service.IObjectiveService;
import com.netsteadfast.greenstep.bsc.service.IOrganizationService;
import com.netsteadfast.greenstep.bsc.service.IPerspectiveService;
import com.netsteadfast.greenstep.bsc.service.IVisionService;
import com.netsteadfast.greenstep.po.hbm.BbEmployee;
import com.netsteadfast.greenstep.po.hbm.BbKpi;
import com.netsteadfast.greenstep.po.hbm.BbMonitorItemScore;
import com.netsteadfast.greenstep.po.hbm.BbObjective;
import com.netsteadfast.greenstep.po.hbm.BbOrganization;
import com.netsteadfast.greenstep.po.hbm.BbPerspective;
import com.netsteadfast.greenstep.po.hbm.BbVision;
import com.netsteadfast.greenstep.vo.EmployeeVO;
import com.netsteadfast.greenstep.vo.KpiVO;
import com.netsteadfast.greenstep.vo.MonitorItemScoreVO;
import com.netsteadfast.greenstep.vo.ObjectiveVO;
import com.netsteadfast.greenstep.vo.OrganizationVO;
import com.netsteadfast.greenstep.vo.PerspectiveVO;
import com.netsteadfast.greenstep.vo.VisionVO;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.time.DateUtils;

public class HistoryItemScoreReportContentQueryUtils {
    private static IMonitorItemScoreService<MonitorItemScoreVO, BbMonitorItemScore, String> monitorItemScoreService = (IMonitorItemScoreService)AppContext.getBean("bsc.service.MonitorItemScoreService");
    private static IVisionService<VisionVO, BbVision, String> visionService = (IVisionService)AppContext.getBean("bsc.service.VisionService");
    private static IPerspectiveService<PerspectiveVO, BbPerspective, String> perspectiveService = (IPerspectiveService)AppContext.getBean("bsc.service.PerspectiveService");
    private static IObjectiveService<ObjectiveVO, BbObjective, String> objectiveService = (IObjectiveService)AppContext.getBean("bsc.service.ObjectiveService");
    private static IKpiService<KpiVO, BbKpi, String> kpiService = (IKpiService)AppContext.getBean("bsc.service.KpiService");
    private static IOrganizationService<OrganizationVO, BbOrganization, String> organizationService = (IOrganizationService)AppContext.getBean("bsc.service.OrganizationService");
    private static IEmployeeService<EmployeeVO, BbEmployee, String> employeeService = (IEmployeeService)AppContext.getBean("bsc.service.EmployeeService");

    public static List<Map<String, Object>> getVisionLineChartData(String frequency, String dateVal, String orgId, String empId) throws ServiceException, Exception {
        return HistoryItemScoreReportContentQueryUtils.getLineChartData("1", frequency, dateVal, orgId, empId);
    }

    public static List<Map<String, Object>> getPerspectivesLineChartData(String frequency, String dateVal, String orgId, String empId) throws ServiceException, Exception {
        return HistoryItemScoreReportContentQueryUtils.getLineChartData("2", frequency, dateVal, orgId, empId);
    }

    public static List<Map<String, Object>> getObjectiveOfStrategyLineChartData(String frequency, String dateVal, String orgId, String empId) throws ServiceException, Exception {
        return HistoryItemScoreReportContentQueryUtils.getLineChartData("3", frequency, dateVal, orgId, empId);
    }

    public static List<Map<String, Object>> getKpisLineChartData(String frequency, String dateVal, String orgId, String empId) throws ServiceException, Exception {
        return HistoryItemScoreReportContentQueryUtils.getLineChartData("4", frequency, dateVal, orgId, empId);
    }

    public static List<String> getLineChartCategoriesFromData(String dateVal, List<Map<String, Object>> chartDataList) throws Exception {
        if (chartDataList == null || chartDataList.size() < 1 || chartDataList.get(0).get("data") == null) {
            return HistoryItemScoreReportContentQueryUtils.getLineChartCategories(dateVal, 0);
        }
        return HistoryItemScoreReportContentQueryUtils.getLineChartCategories(dateVal, ((List)chartDataList.get(0).get("data")).size());
    }

    public static List<String> getLineChartCategories(String dateVal, int dataSize) throws Exception {
        LinkedList<String> categories = new LinkedList<String>();
        if (dataSize < 0) {
            throw new ServiceException("data-size error!");
        }
        Date endDate = DateUtils.parseDate(dateVal, "yyyyMMdd");
        int dateRange = dataSize - 1;
        if (dateRange < 0) {
            dateRange = 0;
        }
        if (dateRange == 0) {
            categories.add(DateFormatUtils.format(endDate, "yyyy/MM/dd"));
            return categories;
        }
        Date startDate = DateUtils.addDays(endDate, dateRange * -1);
        int i = 0;
        while (i < dataSize) {
            Date currentDate = DateUtils.addDays(startDate, i);
            String currentDateStr = DateFormatUtils.format(currentDate, "yyyy/MM/dd");
            categories.add(currentDateStr);
            ++i;
        }
        return categories;
    }

    public static List<Map<String, Object>> getLineChartData(String itemType, String frequency, String dateVal, String orgId, String empId) throws ServiceException, Exception {
        ArrayList<Map<String, Object>> dataList = new ArrayList<Map<String, Object>>();
        Map<String, List<MonitorItemScoreVO>> itemScoreDataMap = monitorItemScoreService.getHistoryDataList(itemType, frequency, dateVal, orgId, empId);
        if (itemScoreDataMap == null || itemScoreDataMap.size() < 1) {
            return dataList;
        }
        List<VisionVO> basicDataList = HistoryItemScoreReportContentQueryUtils.getBasicDataList();
        for (Map.Entry<String, List<MonitorItemScoreVO>> entry : itemScoreDataMap.entrySet()) {
            String name = "";
            String id = entry.getKey();
            List<MonitorItemScoreVO> scoreList = entry.getValue();
            if (scoreList == null || scoreList.size() < 1) continue;
            if ("1".equals(itemType)) {
                DefaultResult<VisionVO> visionResult = visionService.findForSimpleByVisId(id);
                if (visionResult.getValue() == null) {
                    throw new ServiceException(visionResult.getSystemMessage().getValue());
                }
                VisionVO vision = visionResult.getValue();
                name = HistoryItemScoreReportContentQueryUtils.getItemNameWithVisionGroup("1", vision.getVisId(), vision.getTitle(), basicDataList);
            }
            if ("2".equals(itemType)) {
                PerspectiveVO perspective = new PerspectiveVO();
                perspective.setPerId(id);
                DefaultResult<PerspectiveVO> perspectiveResult = perspectiveService.findByUK(perspective);
                if (perspectiveResult.getValue() == null) {
                    throw new ServiceException(perspectiveResult.getSystemMessage().getValue());
                }
                perspective = perspectiveResult.getValue();
                name = HistoryItemScoreReportContentQueryUtils.getItemNameWithVisionGroup("2", perspective.getPerId(), perspective.getName(), basicDataList);
            }
            if ("3".equals(itemType)) {
                ObjectiveVO objective = new ObjectiveVO();
                objective.setObjId(id);
                DefaultResult<ObjectiveVO> objectiveResult = objectiveService.findByUK(objective);
                if (objectiveResult.getValue() == null) {
                    throw new ServiceException(objectiveResult.getSystemMessage().getValue());
                }
                objective = objectiveResult.getValue();
                name = HistoryItemScoreReportContentQueryUtils.getItemNameWithVisionGroup("3", objective.getObjId(), objective.getName(), basicDataList);
            }
            if ("4".equals(itemType)) {
                KpiVO kpi = new KpiVO();
                kpi.setId(id);
                DefaultResult<KpiVO> kpiResult = kpiService.findByUK(kpi);
                if (kpiResult.getValue() == null) {
                    throw new ServiceException(kpiResult.getSystemMessage().getValue());
                }
                kpi = kpiResult.getValue();
                name = HistoryItemScoreReportContentQueryUtils.getItemNameWithVisionGroup("4", kpi.getId(), kpi.getName(), basicDataList);
            }
            if (StringUtils.isBlank(name)) {
                throw new ServiceException("Name not found!");
            }
            HashMap<String, Object> chartDataMap = new HashMap<String, Object>();
            chartDataMap.put("name", name);
            chartDataMap.put("data", new LinkedList());
            for (MonitorItemScoreVO itemScore : scoreList) {
                ((List)chartDataMap.get("data")).add(Float.valueOf(itemScore.getScore()));
            }
            dataList.add(chartDataMap);
        }
        return dataList;
    }

    public static Map<String, Object> getHartMapChartData(String itemType, String frequency, String dateVal, String orgId, String empId) throws ServiceException, Exception {
        List<Map<String, Object>> chartLineData = HistoryItemScoreReportContentQueryUtils.getLineChartData(itemType, frequency, dateVal, orgId, empId);
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        if (chartLineData == null || chartLineData.size() < 1) {
            return dataMap;
        }
        LinkedList<String> xAxisCategories = new LinkedList<String>();
        LinkedList dataList = new LinkedList();
        int x = 0;
        while (x < chartLineData.size()) {
            String itemName = String.valueOf(chartLineData.get(x).get("name"));
            List itemScoreList = (List)chartLineData.get(x).get("data");
            int n = 0;
            while (n < itemScoreList.size()) {
                LinkedList<Integer> itemHartMapData = new LinkedList<Integer>();
                itemHartMapData.add(x);
                itemHartMapData.add(n);
                itemHartMapData.add((Integer)itemScoreList.get(n));
                dataList.add(itemHartMapData);
                ++n;
            }
            xAxisCategories.add(itemName);
            ++x;
        }
        dataMap.put("xAxisCategories", xAxisCategories);
        dataMap.put("yAxisCategories", HistoryItemScoreReportContentQueryUtils.getLineChartCategoriesFromData(dateVal, chartLineData));
        dataMap.put("seriesData", dataList);
        return dataMap;
    }

    public static List<MonitorItemScoreVO> fill2ValueObjectList(List<BbMonitorItemScore> monitorItemScores) throws ServiceException, Exception {
        ArrayList<MonitorItemScoreVO> results = new ArrayList<MonitorItemScoreVO>();
        if (monitorItemScores == null) {
            return results;
        }
        List<VisionVO> basicDataList = HistoryItemScoreReportContentQueryUtils.getBasicDataList();
        for (BbMonitorItemScore monitorScoreSrc : monitorItemScores) {
            MonitorItemScoreVO monitorScoreDest = new MonitorItemScoreVO();
            monitorItemScoreService.doMapper(monitorScoreSrc, monitorScoreDest, "monitorItemScore.po2vo");
            String id = monitorScoreSrc.getItemId();
            String name = "";
            String itemType = monitorScoreSrc.getItemType();
            if ("1".equals(itemType)) {
                DefaultResult<VisionVO> visionResult = visionService.findForSimpleByVisId(id);
                if (visionResult.getValue() == null) {
                    throw new ServiceException(visionResult.getSystemMessage().getValue());
                }
                VisionVO vision = visionResult.getValue();
                name = HistoryItemScoreReportContentQueryUtils.getItemNameWithVisionGroup("1", vision.getVisId(), vision.getTitle(), basicDataList);
            }
            if ("2".equals(itemType)) {
                PerspectiveVO perspective = new PerspectiveVO();
                perspective.setPerId(id);
                DefaultResult<PerspectiveVO> perspectiveResult = perspectiveService.findByUK(perspective);
                if (perspectiveResult.getValue() == null) {
                    throw new ServiceException(perspectiveResult.getSystemMessage().getValue());
                }
                perspective = perspectiveResult.getValue();
                name = HistoryItemScoreReportContentQueryUtils.getItemNameWithVisionGroup("2", perspective.getPerId(), perspective.getName(), basicDataList);
            }
            if ("3".equals(itemType)) {
                ObjectiveVO objective = new ObjectiveVO();
                objective.setObjId(id);
                DefaultResult<ObjectiveVO> objectiveResult = objectiveService.findByUK(objective);
                if (objectiveResult.getValue() == null) {
                    throw new ServiceException(objectiveResult.getSystemMessage().getValue());
                }
                objective = objectiveResult.getValue();
                name = HistoryItemScoreReportContentQueryUtils.getItemNameWithVisionGroup("3", objective.getObjId(), objective.getName(), basicDataList);
            }
            if ("4".equals(itemType)) {
                KpiVO kpi = new KpiVO();
                kpi.setId(id);
                DefaultResult<KpiVO> kpiResult = kpiService.findByUK(kpi);
                if (kpiResult.getValue() == null) {
                    throw new ServiceException(kpiResult.getSystemMessage().getValue());
                }
                kpi = kpiResult.getValue();
                name = HistoryItemScoreReportContentQueryUtils.getItemNameWithVisionGroup("4", kpi.getId(), kpi.getName(), basicDataList);
            }
            monitorScoreDest.setName(name);
            monitorScoreDest.setOrganizationName(monitorScoreSrc.getOrgId());
            monitorScoreDest.setEmployeeName(monitorScoreSrc.getEmpId());
            if (!"*".equals(monitorScoreSrc.getOrgId())) {
                OrganizationVO organization = BscBaseLogicServiceCommonSupport.findOrganizationDataByUK(organizationService, monitorScoreSrc.getOrgId());
                monitorScoreDest.setOrganizationName(String.valueOf(monitorScoreSrc.getOrgId()) + " - " + organization.getName());
            }
            if (!"*".equals(monitorScoreSrc.getEmpId())) {
                EmployeeVO employee = BscBaseLogicServiceCommonSupport.findEmployeeDataByEmpId(employeeService, monitorScoreSrc.getEmpId());
                monitorScoreDest.setEmployeeName(String.valueOf(monitorScoreSrc.getEmpId()) + " - " + employee.getFullName());
            }
            results.add(monitorScoreDest);
        }
        return results;
    }

    private static String getItemNameWithVisionGroup(String itemType, String id, String name, List<VisionVO> basicDataList) throws Exception {
        if (basicDataList.size() < 2) {
            return name;
        }
        String groupStr = "";
        int v = 0;
        while (v < basicDataList.size() && "".equals(groupStr)) {
            int group = v + 1;
            VisionVO vision = basicDataList.get(v);
            if ("1".equals(itemType) && id.equals(vision.getVisId())) {
                groupStr = String.valueOf(group);
            }
            int p = 0;
            while (p < vision.getPerspectives().size() && "".equals(groupStr)) {
                PerspectiveVO perspective = vision.getPerspectives().get(p);
                if ("2".equals(itemType) && id.equals(perspective.getPerId())) {
                    groupStr = String.valueOf(group);
                }
                int o = 0;
                while (o < perspective.getObjectives().size() && "".equals(groupStr)) {
                    ObjectiveVO objective = perspective.getObjectives().get(o);
                    if ("3".equals(itemType) && id.equals(objective.getObjId())) {
                        groupStr = String.valueOf(group);
                    }
                    int k = 0;
                    while (k < objective.getKpis().size() && "".equals(groupStr)) {
                        KpiVO kpi = objective.getKpis().get(k);
                        if ("4".equals(itemType) && id.equals(kpi.getId())) {
                            groupStr = String.valueOf(group);
                        }
                        ++k;
                    }
                    ++o;
                }
                ++p;
            }
            ++v;
        }
        if ("".equals(groupStr)) {
            return name;
        }
        return String.valueOf(name) + "(" + groupStr + ")";
    }

    private static List<VisionVO> getBasicDataList() throws ServiceException, Exception {
        PerspectiveVO perspective;
        int p;
        VisionVO vision;
        LinkedList<VisionVO> visions = new LinkedList<VisionVO>();
        ArrayList<VisionVO> visionsTempList = new ArrayList<VisionVO>();
        Map<String, String> visionMap = visionService.findForMap(false);
        for (Map.Entry<String, String> visionEntry : visionMap.entrySet()) {
            DefaultResult<VisionVO> visionResult = visionService.findForSimple(visionEntry.getKey());
            if (visionResult.getValue() == null) {
                throw new ServiceException(visionResult.getSystemMessage().getValue());
            }
            vision = (VisionVO)visionResult.getValue();
            visionsTempList.add(vision);
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        for (VisionVO vision2 : visionsTempList) {
            paramMap.clear();
            paramMap.put("visId", vision2.getVisId());
            List perspectivesList = perspectiveService.findListVOByParams(paramMap);
            p = 0;
            while (perspectivesList != null && p < perspectivesList.size()) {
                perspective = (PerspectiveVO)perspectivesList.get(p);
                vision2.getPerspectives().add(perspective);
                paramMap.clear();
                paramMap.put("perId", perspective.getPerId());
                List objectivesList = objectiveService.findListVOByParams(paramMap);
                int o = 0;
                while (objectivesList != null && o < objectivesList.size()) {
                    ObjectiveVO objective = (ObjectiveVO)objectivesList.get(o);
                    perspective.getObjectives().add(objective);
                    paramMap.clear();
                    paramMap.put("objId", objective.getObjId());
                    List kpiList = kpiService.findListVOByParams(paramMap);
                    if (kpiList != null && kpiList.size() > 0) {
                        objective.getKpis().addAll(kpiList);
                    }
                    ++o;
                }
                ++p;
            }
        }
        int v = 0;
        while (v < visionsTempList.size()) {
            boolean isFoundData = true;
            vision = (VisionVO)visionsTempList.get(v);
            p = 0;
            while (p < vision.getPerspectives().size() && isFoundData) {
                perspective = vision.getPerspectives().get(p);
                int o = 0;
                while (o < perspective.getObjectives().size() && isFoundData) {
                    ObjectiveVO objective = perspective.getObjectives().get(o);
                    if (objective.getKpis() == null || objective.getKpis().size() < 1) {
                        isFoundData = false;
                    }
                    ++o;
                }
                ++p;
            }
            if (isFoundData) {
                visions.add(vision);
            }
            ++v;
        }
        return visions;
    }
}

