/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.bsc.util;

import com.netsteadfast.greenstep.base.AppContext;
import com.netsteadfast.greenstep.base.exception.ServiceException;
import com.netsteadfast.greenstep.po.hbm.TbSysCode;
import com.netsteadfast.greenstep.service.ISysCodeService;
import com.netsteadfast.greenstep.vo.SysCodeVO;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class BscReportPropertyUtils {
    private static ISysCodeService<SysCodeVO, TbSysCode, String> sysCodeService;
    private static ThreadLocal<List<TbSysCode>> sysCodeThreadLocal;

    static {
        sysCodeThreadLocal = new ThreadLocal();
        sysCodeService = (ISysCodeService)AppContext.getBean("core.service.SysCodeService");
    }

    public static void clearThreadLocal() {
        sysCodeThreadLocal.remove();
    }

    public static void loadData() throws ServiceException, Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("type", "RPT");
        List sysCodeList = sysCodeService.findListByParams(params);
        sysCodeThreadLocal.set(sysCodeList);
    }

    private static String getParameterValue(String code) {
        List<TbSysCode> sysCodeList = sysCodeThreadLocal.get();
        if (sysCodeList == null) {
            return code;
        }
        String value = "";
        for (TbSysCode sysCode : sysCodeList) {
            if (!sysCode.getCode().equals(code)) continue;
            value = StringUtils.defaultString(sysCode.getParam1());
        }
        if (StringUtils.isBlank(value)) {
            return code;
        }
        return value;
    }

    public static String getBackgroundColor() {
        return BscReportPropertyUtils.getParameterValue("BSC_RPTC001");
    }

    public static String getFontColor() {
        return BscReportPropertyUtils.getParameterValue("BSC_RPTC002");
    }

    public static String getPerspectiveTitle() {
        return BscReportPropertyUtils.getParameterValue("BSC_RPTC003");
    }

    public static String getObjectiveTitle() {
        return BscReportPropertyUtils.getParameterValue("BSC_RPTC004");
    }

    public static String getKpiTitle() {
        return BscReportPropertyUtils.getParameterValue("BSC_RPTC005");
    }

    public static String getPersonalReportClassLevel() {
        return BscReportPropertyUtils.getParameterValue("BSC_RPTC006");
    }

    public static String getScoreLabel() {
        return BscReportPropertyUtils.getParameterValue("BSC_RPTC007");
    }

    public static String getWeightLabel() {
        return BscReportPropertyUtils.getParameterValue("BSC_RPTC008");
    }

    public static String getMaxLabel() {
        return BscReportPropertyUtils.getParameterValue("BSC_RPTC009");
    }

    public static String getTargetLabel() {
        return BscReportPropertyUtils.getParameterValue("BSC_RPTC010");
    }

    public static String getMinLabel() {
        return BscReportPropertyUtils.getParameterValue("BSC_RPTC011");
    }

    public static String getManagementLabel() {
        return BscReportPropertyUtils.getParameterValue("BSC_RPTC012");
    }

    public static String getCalculationLabel() {
        return BscReportPropertyUtils.getParameterValue("BSC_RPTC013");
    }

    public static String getUnitLabel() {
        return BscReportPropertyUtils.getParameterValue("BSC_RPTC014");
    }

    public static String getFormulaLabel() {
        return BscReportPropertyUtils.getParameterValue("BSC_RPTC015");
    }

    public static String getOrganizationLabel() {
        return BscReportPropertyUtils.getParameterValue("BSC_RPTC016");
    }

    public static String getEmployeeLabel() {
        return BscReportPropertyUtils.getParameterValue("BSC_RPTC017");
    }
}

