/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.bsc.util;

import com.netsteadfast.greenstep.base.AppContext;
import com.netsteadfast.greenstep.base.exception.ServiceException;
import com.netsteadfast.greenstep.base.model.DefaultResult;
import com.netsteadfast.greenstep.bsc.model.BscMeasureData;
import com.netsteadfast.greenstep.bsc.service.IFormulaService;
import com.netsteadfast.greenstep.util.ScriptExpressionUtils;
import com.netsteadfast.greenstep.vo.FormulaVO;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class BscFormulaUtils {
    private static final String DEFAULT_RETURN_MODE_VAR = "ans_" + System.currentTimeMillis();
    public static final String TRENDS_CURRENT_PEROID_SCORE_VAR = "cv";
    public static final String TRENDS_PREVIOUS_PEROID_SCORE_VAR = "pv";

    public static FormulaVO getFormulaById(String forId) throws ServiceException, Exception {
        IFormulaService formulaService = (IFormulaService)AppContext.getBean("bsc.service.FormulaService");
        FormulaVO formula = new FormulaVO();
        formula.setForId(forId);
        DefaultResult<FormulaVO> forResult = formulaService.findByUK(formula);
        if (forResult.getValue() == null) {
            throw new ServiceException(forResult.getSystemMessage().getValue());
        }
        formula = forResult.getValue();
        return formula;
    }

    public static Map<String, String> getTrendsFlagMap(boolean select) {
        HashMap<String, String> dataMap = new HashMap<String, String>();
        if (select) {
            dataMap.put("all", " - please select - ");
        }
        dataMap.put("Y", "Y");
        dataMap.put("N", "N");
        return dataMap;
    }

    public static Map<String, Object> getParameter(BscMeasureData data) {
        HashMap<String, Object> parameter = new HashMap<String, Object>();
        if (data.getTarget() != null) {
            parameter.put("target", data.getTarget());
        }
        if (data.getActual() != null) {
            parameter.put("actual", data.getActual());
        }
        if (data.getKpi() != null) {
            parameter.put("kpi", data.getKpi());
        }
        return parameter;
    }

    public static Map<String, Object> parse(String type, String returnMode, String returnVar, String expression, Map<String, Object> parameter) throws Exception {
        HashMap<String, Object> results = new HashMap<String, Object>();
        if ("C".equals(returnMode)) {
            if (StringUtils.isBlank(returnVar)) {
                throw new IllegalArgumentException("returnVar cannot blank!");
            }
            results.put(returnVar, null);
        } else {
            results.put(DEFAULT_RETURN_MODE_VAR, null);
        }
        ScriptExpressionUtils.execute(type, BscFormulaUtils.handlerExpression(type, returnMode, expression), results, parameter);
        return results;
    }

    public static Object parse(FormulaVO formula, BscMeasureData data) throws Exception {
        if (formula == null || StringUtils.isBlank(formula.getType()) || StringUtils.isBlank(formula.getExpression())) {
            throw new IllegalArgumentException("formula data cannot blank!");
        }
        Object resultObj = null;
        Map<String, Object> results = BscFormulaUtils.parse(formula.getType(), formula.getReturnMode(), formula.getReturnVar(), formula.getExpression(), BscFormulaUtils.getParameter(data));
        resultObj = "C".equals(formula.getReturnMode()) ? results.get(formula.getReturnVar()) : results.get(DEFAULT_RETURN_MODE_VAR);
        return resultObj;
    }

    public static Object parseKPIPeroidScoreChangeValue(FormulaVO formula, float currentPeroidScore, float previousPeroidScore) throws Exception {
        if (formula == null || StringUtils.isBlank(formula.getType()) || StringUtils.isBlank(formula.getExpression())) {
            throw new IllegalArgumentException("formula data cannot blank!");
        }
        HashMap<String, Object> parameter = new HashMap<String, Object>();
        parameter.put(TRENDS_CURRENT_PEROID_SCORE_VAR, Float.valueOf(currentPeroidScore));
        parameter.put(TRENDS_PREVIOUS_PEROID_SCORE_VAR, Float.valueOf(previousPeroidScore));
        Object resultObj = null;
        Map<String, Object> results = BscFormulaUtils.parse(formula.getType(), formula.getReturnMode(), formula.getReturnVar(), formula.getExpression(), parameter);
        resultObj = "C".equals(formula.getReturnMode()) ? results.get(formula.getReturnVar()) : results.get(DEFAULT_RETURN_MODE_VAR);
        return resultObj;
    }

    private static String handlerExpression(String type, String returnMode, String expression) throws Exception {
        if (StringUtils.isBlank(expression)) {
            return expression;
        }
        String bscExpression = expression;
        if ("D".equals(returnMode)) {
            if ("BSH".equals(type)) {
                bscExpression = String.valueOf(DEFAULT_RETURN_MODE_VAR) + "=" + bscExpression;
            }
            if ("GROOVY".equals(type)) {
                bscExpression = String.valueOf(DEFAULT_RETURN_MODE_VAR) + "=" + bscExpression;
            }
            if ("PYTHON".equals(type)) {
                bscExpression = String.valueOf(DEFAULT_RETURN_MODE_VAR) + "=" + bscExpression;
            }
            if ("R".equals(type)) {
                bscExpression = String.valueOf(DEFAULT_RETURN_MODE_VAR) + "=" + bscExpression;
            }
        }
        return ScriptExpressionUtils.replaceFormulaExpression(type, bscExpression);
    }
}

