/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.bsc.service.logic.impl;

import com.netsteadfast.greenstep.base.SysMessageUtil;
import com.netsteadfast.greenstep.base.exception.ServiceException;
import com.netsteadfast.greenstep.base.model.DefaultResult;
import com.netsteadfast.greenstep.base.model.ServiceAuthority;
import com.netsteadfast.greenstep.base.model.ServiceMethodAuthority;
import com.netsteadfast.greenstep.base.model.ServiceMethodType;
import com.netsteadfast.greenstep.base.model.SystemMessage;
import com.netsteadfast.greenstep.base.service.logic.BscBaseLogicService;
import com.netsteadfast.greenstep.bsc.service.IPerspectiveService;
import com.netsteadfast.greenstep.bsc.service.ISwotService;
import com.netsteadfast.greenstep.bsc.service.IVisionService;
import com.netsteadfast.greenstep.bsc.service.logic.ISwotLogicService;
import com.netsteadfast.greenstep.po.hbm.BbPerspective;
import com.netsteadfast.greenstep.po.hbm.BbSwot;
import com.netsteadfast.greenstep.po.hbm.BbVision;
import com.netsteadfast.greenstep.vo.OrganizationVO;
import com.netsteadfast.greenstep.vo.PerspectiveVO;
import com.netsteadfast.greenstep.vo.SwotVO;
import com.netsteadfast.greenstep.vo.VisionVO;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@ServiceAuthority(check=true)
@Service(value="bsc.service.logic.SwotLogicService")
@Transactional(propagation=Propagation.REQUIRED, readOnly=true)
public class SwotLogicServiceImpl
extends BscBaseLogicService
implements ISwotLogicService {
    protected Logger logger = Logger.getLogger(SwotLogicServiceImpl.class);
    private static final int MAX_ISSUES_LENGTH = 500;
    private IVisionService<VisionVO, BbVision, String> visionService;
    private ISwotService<SwotVO, BbSwot, String> swotService;
    private IPerspectiveService<PerspectiveVO, BbPerspective, String> perspectiveService;

    public IVisionService<VisionVO, BbVision, String> getVisionService() {
        return this.visionService;
    }

    @Autowired
    @Resource(name="bsc.service.VisionService")
    @Required
    public void setVisionService(IVisionService<VisionVO, BbVision, String> visionService) {
        this.visionService = visionService;
    }

    public ISwotService<SwotVO, BbSwot, String> getSwotService() {
        return this.swotService;
    }

    @Autowired
    @Resource(name="bsc.service.SwotService")
    @Required
    public void setSwotService(ISwotService<SwotVO, BbSwot, String> swotService) {
        this.swotService = swotService;
    }

    public IPerspectiveService<PerspectiveVO, BbPerspective, String> getPerspectiveService() {
        return this.perspectiveService;
    }

    @Autowired
    @Resource(name="bsc.service.PerspectiveService")
    @Required
    public void setPerspectiveService(IPerspectiveService<PerspectiveVO, BbPerspective, String> perspectiveService) {
        this.perspectiveService = perspectiveService;
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.INSERT, ServiceMethodType.UPDATE})
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={RuntimeException.class, IOException.class, Exception.class})
    public DefaultResult<Boolean> create(String visionOid, String organizationOid, List<SwotVO> datas) throws ServiceException, Exception {
        if (super.isBlank(visionOid) || super.isBlank(organizationOid)) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0001"));
        }
        VisionVO vision = new VisionVO();
        vision.setOid(visionOid);
        DefaultResult<VisionVO> vResult = this.visionService.findObjectByOid(vision);
        if (vResult.getValue() == null) {
            throw new ServiceException(vResult.getSystemMessage().getValue());
        }
        vision = vResult.getValue();
        OrganizationVO organization = this.findOrganizationData(organizationOid);
        DefaultResult<Boolean> result = new DefaultResult<Boolean>();
        result.setValue(Boolean.TRUE);
        result.setSystemMessage(new SystemMessage(SysMessageUtil.get("MSG_DOS0003")));
        HashMap<String, Object> params = new HashMap<String, Object>();
        for (SwotVO swot : datas) {
            if (!vision.getVisId().equals(swot.getVisId()) || !organization.getOrgId().equals(swot.getOrgId())) {
                throw new ServiceException(SysMessageUtil.get("MSG_STD0005"));
            }
            this.setStringValueMaxLength(swot, "issues", 500);
            params.clear();
            params.put("perId", swot.getPerId());
            if (this.perspectiveService.countByParams(params) < 1L) {
                throw new ServiceException(SysMessageUtil.get("MSG_STD0005"));
            }
            if (this.swotService.countByUK(swot) > 0) {
                this.updateIssues(swot);
                continue;
            }
            this.swotService.saveObject(swot);
        }
        return result;
    }

    private void updateIssues(SwotVO swot) throws ServiceException, Exception {
        DefaultResult<SwotVO> oldResult = this.swotService.findByUK(swot);
        if (oldResult.getValue() == null) {
            throw new ServiceException(oldResult.getSystemMessage().getValue());
        }
        oldResult.getValue().setIssues(swot.getIssues());
        this.swotService.updateObject(oldResult.getValue());
    }
}

