/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.bsc.service.logic.impl;

import com.netsteadfast.greenstep.base.SysMessageUtil;
import com.netsteadfast.greenstep.base.exception.ServiceException;
import com.netsteadfast.greenstep.base.model.DefaultResult;
import com.netsteadfast.greenstep.base.model.ServiceAuthority;
import com.netsteadfast.greenstep.base.model.ServiceMethodAuthority;
import com.netsteadfast.greenstep.base.model.ServiceMethodType;
import com.netsteadfast.greenstep.base.model.SystemMessage;
import com.netsteadfast.greenstep.base.service.logic.CoreBaseLogicService;
import com.netsteadfast.greenstep.bsc.service.IStrategyMapConnsService;
import com.netsteadfast.greenstep.bsc.service.IStrategyMapNodesService;
import com.netsteadfast.greenstep.bsc.service.IStrategyMapService;
import com.netsteadfast.greenstep.bsc.service.IVisionService;
import com.netsteadfast.greenstep.bsc.service.logic.IStrategyMapLogicService;
import com.netsteadfast.greenstep.po.hbm.BbStrategyMap;
import com.netsteadfast.greenstep.po.hbm.BbStrategyMapConns;
import com.netsteadfast.greenstep.po.hbm.BbStrategyMapNodes;
import com.netsteadfast.greenstep.po.hbm.BbVision;
import com.netsteadfast.greenstep.vo.StrategyMapConnsVO;
import com.netsteadfast.greenstep.vo.StrategyMapNodesVO;
import com.netsteadfast.greenstep.vo.StrategyMapVO;
import com.netsteadfast.greenstep.vo.VisionVO;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@ServiceAuthority(check=true)
@Service(value="bsc.service.logic.StrategyMapLogicService")
@Transactional(propagation=Propagation.REQUIRED, readOnly=true)
public class StrategyMapLogicServiceImpl
extends CoreBaseLogicService
implements IStrategyMapLogicService {
    protected Logger logger = Logger.getLogger(StrategyMapLogicServiceImpl.class);
    private IVisionService<VisionVO, BbVision, String> visionService;
    private IStrategyMapService<StrategyMapVO, BbStrategyMap, String> strategyMapService;
    private IStrategyMapNodesService<StrategyMapNodesVO, BbStrategyMapNodes, String> strategyMapNodesService;
    private IStrategyMapConnsService<StrategyMapConnsVO, BbStrategyMapConns, String> strategyMapConnsService;

    public IVisionService<VisionVO, BbVision, String> getVisionService() {
        return this.visionService;
    }

    @Autowired
    @Resource(name="bsc.service.VisionService")
    @Required
    public void setVisionService(IVisionService<VisionVO, BbVision, String> visionService) {
        this.visionService = visionService;
    }

    public IStrategyMapService<StrategyMapVO, BbStrategyMap, String> getStrategyMapService() {
        return this.strategyMapService;
    }

    @Autowired
    @Resource(name="bsc.service.StrategyMapService")
    @Required
    public void setStrategyMapService(IStrategyMapService<StrategyMapVO, BbStrategyMap, String> strategyMapService) {
        this.strategyMapService = strategyMapService;
    }

    public IStrategyMapNodesService<StrategyMapNodesVO, BbStrategyMapNodes, String> getStrategyMapNodesService() {
        return this.strategyMapNodesService;
    }

    @Autowired
    @Resource(name="bsc.service.StrategyMapNodesService")
    @Required
    public void setStrategyMapNodesService(IStrategyMapNodesService<StrategyMapNodesVO, BbStrategyMapNodes, String> strategyMapNodesService) {
        this.strategyMapNodesService = strategyMapNodesService;
    }

    public IStrategyMapConnsService<StrategyMapConnsVO, BbStrategyMapConns, String> getStrategyMapConnsService() {
        return this.strategyMapConnsService;
    }

    @Autowired
    @Resource(name="bsc.service.StrategyMapConnsService")
    @Required
    public void setStrategyMapConnsService(IStrategyMapConnsService<StrategyMapConnsVO, BbStrategyMapConns, String> strategyMapConnsService) {
        this.strategyMapConnsService = strategyMapConnsService;
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.INSERT, ServiceMethodType.UPDATE})
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={RuntimeException.class, IOException.class, Exception.class})
    public DefaultResult<Boolean> create(String visionOid, Map<String, Object> jsonData) throws ServiceException, Exception {
        this.delete(visionOid);
        VisionVO vision = new VisionVO();
        vision.setOid(visionOid);
        DefaultResult<VisionVO> vResult = this.visionService.findObjectByOid(vision);
        if (vResult.getValue() == null) {
            throw new ServiceException(vResult.getSystemMessage().getValue());
        }
        vision = vResult.getValue();
        StrategyMapVO strategyMap = new StrategyMapVO();
        strategyMap.setVisId(vision.getVisId());
        DefaultResult<StrategyMapVO> smResult = this.strategyMapService.saveObject(strategyMap);
        if (smResult.getValue() == null) {
            throw new ServiceException(smResult.getSystemMessage().getValue());
        }
        strategyMap = smResult.getValue();
        DefaultResult<Boolean> result = new DefaultResult<Boolean>();
        result.setValue(Boolean.TRUE);
        result.setSystemMessage(new SystemMessage(SysMessageUtil.get("MSG_DOS0003")));
        this.saveNodesAndConnections(strategyMap, jsonData);
        return result;
    }

    private void saveNodesAndConnections(StrategyMapVO strategyMap, Map<String, Object> jsonData) throws ServiceException, Exception {
        Map data;
        List connections = (List)jsonData.get("connections");
        List nodes = (List)jsonData.get("nodes");
        int i = 0;
        while (connections != null && i < connections.size()) {
            data = (Map)connections.get(i);
            String connectionId = (String)data.get("connectionId");
            String sourceId = (String)data.get("sourceId");
            String targetId = (String)data.get("targetId");
            if (!(StringUtils.isBlank(connectionId) || StringUtils.isBlank(sourceId) || StringUtils.isBlank(targetId))) {
                StrategyMapConnsVO mapConns = new StrategyMapConnsVO();
                mapConns.setMasterOid(strategyMap.getOid());
                mapConns.setConnectionId(connectionId);
                mapConns.setSourceId(sourceId);
                mapConns.setTargetId(targetId);
                this.strategyMapConnsService.saveIgnoreUK(mapConns);
            }
            ++i;
        }
        i = 0;
        while (nodes != null && i < nodes.size()) {
            data = (Map)nodes.get(i);
            String id = (String)data.get("id");
            String text = (String)data.get("text");
            String positionX = String.valueOf(data.get("positionX"));
            String positionY = String.valueOf(data.get("positionY"));
            if (!StringUtils.isBlank(id) && !StringUtils.isBlank(text) && NumberUtils.isCreatable(positionX) && NumberUtils.isCreatable(positionY)) {
                StrategyMapNodesVO mapNodes = new StrategyMapNodesVO();
                mapNodes.setMasterOid(strategyMap.getOid());
                mapNodes.setId(id);
                mapNodes.setText(text);
                mapNodes.setPositionX(NumberUtils.toInt(positionX));
                mapNodes.setPositionY(NumberUtils.toInt(positionY));
                this.strategyMapNodesService.saveIgnoreUK(mapNodes);
            }
            ++i;
        }
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.DELETE})
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={RuntimeException.class, IOException.class, Exception.class})
    public DefaultResult<Boolean> delete(String visionOid) throws ServiceException, Exception {
        if (super.isBlank(visionOid) || super.isNoSelectId(visionOid)) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0001"));
        }
        DefaultResult<Boolean> result = new DefaultResult<Boolean>();
        result.setValue(Boolean.TRUE);
        result.setSystemMessage(new SystemMessage(SysMessageUtil.get("MSG_DOS0007")));
        VisionVO vision = new VisionVO();
        vision.setOid(visionOid);
        DefaultResult<VisionVO> vResult = this.visionService.findObjectByOid(vision);
        if (vResult.getValue() == null) {
            return result;
        }
        vision = vResult.getValue();
        StrategyMapVO strategyMap = new StrategyMapVO();
        strategyMap.setVisId(vision.getVisId());
        DefaultResult<StrategyMapVO> smResult = this.strategyMapService.findByUK(strategyMap);
        if (smResult.getValue() == null) {
            return result;
        }
        strategyMap = smResult.getValue();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("masterOid", strategyMap.getOid());
        List nodes = this.strategyMapNodesService.findListByParams(params);
        List conns = this.strategyMapConnsService.findListByParams(params);
        int i = 0;
        while (nodes != null && i < nodes.size()) {
            this.strategyMapNodesService.delete((BbStrategyMapNodes)nodes.get(i));
            ++i;
        }
        i = 0;
        while (conns != null && i < conns.size()) {
            this.strategyMapConnsService.delete((BbStrategyMapConns)conns.get(i));
            ++i;
        }
        return this.strategyMapService.deleteObject(strategyMap);
    }
}

