/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.bsc.service.logic.impl;

import com.netsteadfast.greenstep.base.SysMessageUtil;
import com.netsteadfast.greenstep.base.exception.ServiceException;
import com.netsteadfast.greenstep.base.model.DefaultResult;
import com.netsteadfast.greenstep.base.model.ServiceAuthority;
import com.netsteadfast.greenstep.base.model.ServiceMethodAuthority;
import com.netsteadfast.greenstep.base.model.ServiceMethodType;
import com.netsteadfast.greenstep.base.model.SystemMessage;
import com.netsteadfast.greenstep.base.service.logic.BscBaseLogicService;
import com.netsteadfast.greenstep.bsc.service.IReportRoleViewService;
import com.netsteadfast.greenstep.bsc.service.logic.IReportRoleViewLogicService;
import com.netsteadfast.greenstep.po.hbm.BbEmployee;
import com.netsteadfast.greenstep.po.hbm.BbOrganization;
import com.netsteadfast.greenstep.po.hbm.BbReportRoleView;
import com.netsteadfast.greenstep.po.hbm.TbUserRole;
import com.netsteadfast.greenstep.vo.EmployeeVO;
import com.netsteadfast.greenstep.vo.OrganizationVO;
import com.netsteadfast.greenstep.vo.ReportRoleViewVO;
import com.netsteadfast.greenstep.vo.RoleVO;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@ServiceAuthority(check=true)
@Service(value="bsc.service.logic.ReportRoleViewLogicService")
@Transactional(propagation=Propagation.REQUIRED, readOnly=true)
public class ReportRoleViewLogicServiceImpl
extends BscBaseLogicService
implements IReportRoleViewLogicService {
    protected Logger logger = Logger.getLogger(ReportRoleViewLogicServiceImpl.class);
    private IReportRoleViewService<ReportRoleViewVO, BbReportRoleView, String> reportRoleViewService;

    public IReportRoleViewService<ReportRoleViewVO, BbReportRoleView, String> getReportRoleViewService() {
        return this.reportRoleViewService;
    }

    @Autowired
    @Resource(name="bsc.service.ReportRoleViewService")
    @Required
    public void setReportRoleViewService(IReportRoleViewService<ReportRoleViewVO, BbReportRoleView, String> reportRoleViewService) {
        this.reportRoleViewService = reportRoleViewService;
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.INSERT, ServiceMethodType.UPDATE})
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={RuntimeException.class, IOException.class, Exception.class})
    public DefaultResult<Boolean> create(String roleOid, List<String> emplOids, List<String> orgaOids) throws ServiceException, Exception {
        if (super.isNoSelectId(roleOid)) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0001"));
        }
        RoleVO role = new RoleVO();
        role.setOid(roleOid);
        DefaultResult<RoleVO> rResult = this.getRoleService().findObjectByOid(role);
        if (rResult.getValue() == null) {
            throw new ServiceException(rResult.getSystemMessage().getValue());
        }
        role = rResult.getValue();
        this.deleteByRole(role.getRole());
        int i = 0;
        while (emplOids != null && i < emplOids.size()) {
            EmployeeVO employee = this.findEmployeeData(emplOids.get(i));
            this.createReportRoleView(role.getRole(), "EMP", employee.getAccount());
            ++i;
        }
        i = 0;
        while (orgaOids != null && i < orgaOids.size()) {
            OrganizationVO organization = this.findOrganizationData(orgaOids.get(i));
            this.createReportRoleView(role.getRole(), "ORG", organization.getOrgId());
            ++i;
        }
        DefaultResult<Boolean> result = new DefaultResult<Boolean>();
        result.setValue(Boolean.TRUE);
        result.setSystemMessage(new SystemMessage(SysMessageUtil.get("MSG_DOS0003")));
        return result;
    }

    private void createReportRoleView(String roleId, String type, String idName) throws ServiceException, Exception {
        ReportRoleViewVO reportRoleView = new ReportRoleViewVO();
        reportRoleView.setIdName(idName);
        reportRoleView.setType(type);
        reportRoleView.setRole(roleId);
        this.reportRoleViewService.saveObject(reportRoleView);
    }

    private void deleteByRole(String roleId) throws ServiceException, Exception {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("role", roleId);
        List rRoleViews = this.reportRoleViewService.findListByParams(paramMap);
        int i = 0;
        while (rRoleViews != null && i < rRoleViews.size()) {
            this.reportRoleViewService.delete((BbReportRoleView)rRoleViews.get(i));
            ++i;
        }
    }

    private List<TbUserRole> getUserRoles(String account) throws ServiceException, Exception {
        return this.findUserRoles(account);
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.SELECT})
    public Map<String, String> findForEmployeeMap(boolean pleaseSelect, String accountId) throws ServiceException, Exception {
        if (super.isBlank(accountId)) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0001"));
        }
        LinkedHashMap<String, String> dataMap = new LinkedHashMap<String, String>();
        if (pleaseSelect) {
            dataMap.put("all", " - please select - ");
        }
        List<TbUserRole> roles = this.getUserRoles(accountId);
        int i = 0;
        while (roles != null && i < roles.size()) {
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("role", roles.get(i).getRole());
            paramMap.put("type", "EMP");
            List views = this.reportRoleViewService.findListByParams(paramMap);
            int j = 0;
            while (views != null && j < views.size()) {
                paramMap.clear();
                paramMap.put("account", ((BbReportRoleView)views.get(j)).getIdName());
                List employees = this.getEmployeeService().findListByParams(paramMap);
                int e = 0;
                while (employees != null && e < employees.size()) {
                    BbEmployee employee = (BbEmployee)employees.get(e);
                    if (dataMap.get(employee.getOid()) == null) {
                        dataMap.put(employee.getOid(), employee.getFullName());
                    }
                    ++e;
                }
                ++j;
            }
            ++i;
        }
        return dataMap;
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.SELECT})
    public Map<String, String> findForOrganizationMap(boolean pleaseSelect, String accountId) throws ServiceException, Exception {
        if (super.isBlank(accountId)) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0001"));
        }
        LinkedHashMap<String, String> dataMap = new LinkedHashMap<String, String>();
        if (pleaseSelect) {
            dataMap.put("all", " - please select - ");
        }
        List<BbOrganization> organizations = this.findForOrganization(accountId);
        for (BbOrganization entity : organizations) {
            if (dataMap.get(entity.getOid()) != null) continue;
            dataMap.put(entity.getOid(), entity.getName());
        }
        return dataMap;
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.SELECT})
    public List<BbOrganization> findForOrganization(String accountId) throws ServiceException, Exception {
        if (super.isBlank(accountId)) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0001"));
        }
        ArrayList<BbOrganization> searchList = new ArrayList<BbOrganization>();
        List<TbUserRole> roles = this.getUserRoles(accountId);
        int i = 0;
        while (roles != null && i < roles.size()) {
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("role", roles.get(i).getRole());
            paramMap.put("type", "ORG");
            List views = this.reportRoleViewService.findListByParams(paramMap);
            int j = 0;
            while (views != null && j < views.size()) {
                BbOrganization organization = new BbOrganization();
                organization.setOrgId(((BbReportRoleView)views.get(j)).getIdName());
                organization = this.getOrganizationService().findByEntityUK(organization);
                if (organization != null) {
                    boolean isFound = false;
                    for (BbOrganization entity : searchList) {
                        if (!entity.getOid().equals(organization.getOid())) continue;
                        isFound = true;
                    }
                    if (!isFound) {
                        searchList.add(organization);
                    }
                }
                ++j;
            }
            ++i;
        }
        return searchList;
    }
}

