/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.bsc.service.logic.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netsteadfast.greenstep.base.Constants;
import com.netsteadfast.greenstep.base.SysMessageUtil;
import com.netsteadfast.greenstep.base.exception.ServiceException;
import com.netsteadfast.greenstep.base.model.DefaultResult;
import com.netsteadfast.greenstep.base.model.ServiceAuthority;
import com.netsteadfast.greenstep.base.model.ServiceMethodAuthority;
import com.netsteadfast.greenstep.base.model.ServiceMethodType;
import com.netsteadfast.greenstep.base.model.SystemMessage;
import com.netsteadfast.greenstep.base.service.logic.BscBaseLogicService;
import com.netsteadfast.greenstep.bsc.service.IEmployeeOrgaService;
import com.netsteadfast.greenstep.bsc.service.IKpiOrgaService;
import com.netsteadfast.greenstep.bsc.service.IMeasureDataService;
import com.netsteadfast.greenstep.bsc.service.IMonitorItemScoreService;
import com.netsteadfast.greenstep.bsc.service.IOrganizationParService;
import com.netsteadfast.greenstep.bsc.service.IPdcaMeasureFreqService;
import com.netsteadfast.greenstep.bsc.service.IPdcaOrgaService;
import com.netsteadfast.greenstep.bsc.service.IReportRoleViewService;
import com.netsteadfast.greenstep.bsc.service.ISwotService;
import com.netsteadfast.greenstep.bsc.service.ITsaMeasureFreqService;
import com.netsteadfast.greenstep.bsc.service.logic.IOrganizationLogicService;
import com.netsteadfast.greenstep.po.hbm.BbEmployeeOrga;
import com.netsteadfast.greenstep.po.hbm.BbKpiOrga;
import com.netsteadfast.greenstep.po.hbm.BbMeasureData;
import com.netsteadfast.greenstep.po.hbm.BbMonitorItemScore;
import com.netsteadfast.greenstep.po.hbm.BbOrganizationPar;
import com.netsteadfast.greenstep.po.hbm.BbPdcaMeasureFreq;
import com.netsteadfast.greenstep.po.hbm.BbPdcaOrga;
import com.netsteadfast.greenstep.po.hbm.BbReportRoleView;
import com.netsteadfast.greenstep.po.hbm.BbSwot;
import com.netsteadfast.greenstep.po.hbm.BbTsaMeasureFreq;
import com.netsteadfast.greenstep.util.IconUtils;
import com.netsteadfast.greenstep.util.SimpleUtils;
import com.netsteadfast.greenstep.util.UploadSupportUtils;
import com.netsteadfast.greenstep.vo.EmployeeOrgaVO;
import com.netsteadfast.greenstep.vo.KpiOrgaVO;
import com.netsteadfast.greenstep.vo.MeasureDataVO;
import com.netsteadfast.greenstep.vo.MonitorItemScoreVO;
import com.netsteadfast.greenstep.vo.OrganizationParVO;
import com.netsteadfast.greenstep.vo.OrganizationVO;
import com.netsteadfast.greenstep.vo.PdcaMeasureFreqVO;
import com.netsteadfast.greenstep.vo.PdcaOrgaVO;
import com.netsteadfast.greenstep.vo.ReportRoleViewVO;
import com.netsteadfast.greenstep.vo.SwotVO;
import com.netsteadfast.greenstep.vo.TsaMeasureFreqVO;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@ServiceAuthority(check=true)
@Service(value="bsc.service.logic.OrganizationLogicService")
@Transactional(propagation=Propagation.REQUIRED, readOnly=true)
public class OrganizationLogicServiceImpl
extends BscBaseLogicService
implements IOrganizationLogicService {
    protected Logger logger = Logger.getLogger(OrganizationLogicServiceImpl.class);
    private static final int MAX_DESCRIPTION_LENGTH = 500;
    private static final String TREE_ICON_ID = "STOCK_HOME";
    private IOrganizationParService<OrganizationParVO, BbOrganizationPar, String> organizationParService;
    private IEmployeeOrgaService<EmployeeOrgaVO, BbEmployeeOrga, String> employeeOrgaService;
    private IKpiOrgaService<KpiOrgaVO, BbKpiOrga, String> kpiOrgaService;
    private ISwotService<SwotVO, BbSwot, String> swotService;
    private IReportRoleViewService<ReportRoleViewVO, BbReportRoleView, String> reportRoleViewService;
    private IMeasureDataService<MeasureDataVO, BbMeasureData, String> measureDataService;
    private IPdcaOrgaService<PdcaOrgaVO, BbPdcaOrga, String> pdcaOrgaService;
    private IMonitorItemScoreService<MonitorItemScoreVO, BbMonitorItemScore, String> monitorItemScoreService;
    private IPdcaMeasureFreqService<PdcaMeasureFreqVO, BbPdcaMeasureFreq, String> pdcaMeasureFreqService;
    private ITsaMeasureFreqService<TsaMeasureFreqVO, BbTsaMeasureFreq, String> tsaMeasureFreqService;

    public IOrganizationParService<OrganizationParVO, BbOrganizationPar, String> getOrganizationParService() {
        return this.organizationParService;
    }

    @Autowired
    @Resource(name="bsc.service.OrganizationParService")
    @Required
    public void setOrganizationParService(IOrganizationParService<OrganizationParVO, BbOrganizationPar, String> organizationParService) {
        this.organizationParService = organizationParService;
    }

    public IEmployeeOrgaService<EmployeeOrgaVO, BbEmployeeOrga, String> getEmployeeOrgaService() {
        return this.employeeOrgaService;
    }

    @Autowired
    @Resource(name="bsc.service.EmployeeOrgaService")
    @Required
    public void setEmployeeOrgaService(IEmployeeOrgaService<EmployeeOrgaVO, BbEmployeeOrga, String> employeeOrgaService) {
        this.employeeOrgaService = employeeOrgaService;
    }

    public IKpiOrgaService<KpiOrgaVO, BbKpiOrga, String> getKpiOrgaService() {
        return this.kpiOrgaService;
    }

    @Autowired
    @Resource(name="bsc.service.KpiOrgaService")
    @Required
    public void setKpiOrgaService(IKpiOrgaService<KpiOrgaVO, BbKpiOrga, String> kpiOrgaService) {
        this.kpiOrgaService = kpiOrgaService;
    }

    public ISwotService<SwotVO, BbSwot, String> getSwotService() {
        return this.swotService;
    }

    @Autowired
    @Resource(name="bsc.service.SwotService")
    @Required
    public void setSwotService(ISwotService<SwotVO, BbSwot, String> swotService) {
        this.swotService = swotService;
    }

    public IReportRoleViewService<ReportRoleViewVO, BbReportRoleView, String> getReportRoleViewService() {
        return this.reportRoleViewService;
    }

    @Autowired
    @Resource(name="bsc.service.ReportRoleViewService")
    @Required
    public void setReportRoleViewService(IReportRoleViewService<ReportRoleViewVO, BbReportRoleView, String> reportRoleViewService) {
        this.reportRoleViewService = reportRoleViewService;
    }

    public IMeasureDataService<MeasureDataVO, BbMeasureData, String> getMeasureDataService() {
        return this.measureDataService;
    }

    @Autowired
    @Resource(name="bsc.service.MeasureDataService")
    @Required
    public void setMeasureDataService(IMeasureDataService<MeasureDataVO, BbMeasureData, String> measureDataService) {
        this.measureDataService = measureDataService;
    }

    public IPdcaOrgaService<PdcaOrgaVO, BbPdcaOrga, String> getPdcaOrgaService() {
        return this.pdcaOrgaService;
    }

    @Autowired
    @Resource(name="bsc.service.PdcaOrgaService")
    @Required
    public void setPdcaOrgaService(IPdcaOrgaService<PdcaOrgaVO, BbPdcaOrga, String> pdcaOrgaService) {
        this.pdcaOrgaService = pdcaOrgaService;
    }

    public IMonitorItemScoreService<MonitorItemScoreVO, BbMonitorItemScore, String> getMonitorItemScoreService() {
        return this.monitorItemScoreService;
    }

    @Autowired
    @Resource(name="bsc.service.MonitorItemScoreService")
    @Required
    public void setMonitorItemScoreService(IMonitorItemScoreService<MonitorItemScoreVO, BbMonitorItemScore, String> monitorItemScoreService) {
        this.monitorItemScoreService = monitorItemScoreService;
    }

    public IPdcaMeasureFreqService<PdcaMeasureFreqVO, BbPdcaMeasureFreq, String> getPdcaMeasureFreqService() {
        return this.pdcaMeasureFreqService;
    }

    @Autowired
    @Resource(name="bsc.service.PdcaMeasureFreqService")
    @Required
    public void setPdcaMeasureFreqService(IPdcaMeasureFreqService<PdcaMeasureFreqVO, BbPdcaMeasureFreq, String> pdcaMeasureFreqService) {
        this.pdcaMeasureFreqService = pdcaMeasureFreqService;
    }

    public ITsaMeasureFreqService<TsaMeasureFreqVO, BbTsaMeasureFreq, String> getTsaMeasureFreqService() {
        return this.tsaMeasureFreqService;
    }

    @Autowired
    @Resource(name="bsc.service.TsaMeasureFreqService")
    @Required
    public void setTsaMeasureFreqService(ITsaMeasureFreqService<TsaMeasureFreqVO, BbTsaMeasureFreq, String> tsaMeasureFreqService) {
        this.tsaMeasureFreqService = tsaMeasureFreqService;
    }

    private void handlerLongitudeAndLatitude(OrganizationVO organization) {
        if (!NumberUtils.isCreatable(organization.getLat())) {
            organization.setLat((String)Constants.getSettingsMap().get("googleMap.defaultLat"));
        }
        if (!NumberUtils.isCreatable(organization.getLng())) {
            organization.setLng((String)Constants.getSettingsMap().get("googleMap.defaultLng"));
        }
    }

    private void checkOrganizationIdIsZero(OrganizationVO organization) throws ServiceException, Exception {
        if (super.isBlank(organization.getOrgId()) || "0000000000".equals(organization.getOrgId())) {
            throw new ServiceException("Please change another Id! does not accept id is `" + super.defaultString(organization.getOrgId()) + "`");
        }
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.INSERT})
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={RuntimeException.class, IOException.class, Exception.class})
    public DefaultResult<OrganizationVO> create(OrganizationVO organization) throws ServiceException, Exception {
        if (organization == null) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0001"));
        }
        this.checkOrganizationIdIsZero(organization);
        this.setStringValueMaxLength(organization, "description", 500);
        this.handlerLongitudeAndLatitude(organization);
        this.createParent(organization, "0000000000");
        return this.getOrganizationService().saveObject(organization);
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.UPDATE})
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={RuntimeException.class, IOException.class, Exception.class})
    public DefaultResult<OrganizationVO> update(OrganizationVO organization) throws ServiceException, Exception {
        if (organization == null || super.isBlank(organization.getOid())) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0001"));
        }
        this.checkOrganizationIdIsZero(organization);
        OrganizationVO dbOrganization = this.findOrganizationData(organization.getOid());
        organization.setOrgId(dbOrganization.getOrgId());
        this.setStringValueMaxLength(organization, "description", 500);
        this.handlerLongitudeAndLatitude(organization);
        return this.getOrganizationService().updateObject(organization);
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.DELETE})
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={RuntimeException.class, IOException.class, Exception.class})
    public DefaultResult<Boolean> delete(OrganizationVO organization) throws ServiceException, Exception {
        if (organization == null || super.isBlank(organization.getOid())) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0001"));
        }
        if (this.foundChild(organization = this.findOrganizationData(organization.getOid()))) {
            throw new ServiceException(SysMessageUtil.get("MSG_DOS0010"));
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("orgId", organization.getOrgId());
        if (this.employeeOrgaService.countByParams(params) > 0L) {
            throw new ServiceException(SysMessageUtil.get("MSG_DOS0010"));
        }
        if (this.kpiOrgaService.countByParams(params) > 0L) {
            throw new ServiceException(SysMessageUtil.get("MSG_DOS0010"));
        }
        if (this.pdcaOrgaService.countByParams(params) > 0L) {
            throw new ServiceException(SysMessageUtil.get("MSG_DOS0010"));
        }
        if (this.pdcaMeasureFreqService.countByParams(params) > 0L) {
            throw new ServiceException(SysMessageUtil.get("MSG_DOS0010"));
        }
        if (this.tsaMeasureFreqService.countByParams(params) > 0L) {
            throw new ServiceException(SysMessageUtil.get("MSG_DOS0010"));
        }
        this.deleteParent(organization);
        this.swotService.deleteForOrgId(organization.getOrgId());
        params.clear();
        params.put("idName", organization.getOrgId());
        List reportRoleViews = this.reportRoleViewService.findListByParams(params);
        int i = 0;
        while (reportRoleViews != null && i < reportRoleViews.size()) {
            BbReportRoleView reportRoleView = (BbReportRoleView)reportRoleViews.get(i);
            this.reportRoleViewService.delete(reportRoleView);
            ++i;
        }
        this.measureDataService.deleteForOrgId(organization.getOrgId());
        this.monitorItemScoreService.deleteForOrgId(organization.getOrgId());
        return this.getOrganizationService().deleteObject(organization);
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.SELECT})
    public List<Map<String, Object>> getTreeData(String basePath, boolean checkBox, String appendId) throws ServiceException, Exception {
        LinkedList<Map<String, Object>> items = new LinkedList<Map<String, Object>>();
        List<OrganizationVO> orgList = this.getOrganizationService().findForJoinParent();
        if (orgList == null || orgList.size() < 1) {
            return items;
        }
        for (OrganizationVO org : orgList) {
            if (!super.isBlank(org.getParId()) && !"0000000000".equals(org.getParId())) continue;
            LinkedHashMap<String, String> parentDataMap = new LinkedHashMap<String, String>();
            parentDataMap.put("type", "parent");
            parentDataMap.put("name", String.valueOf(checkBox ? this.getCheckBoxHtmlContent(org, appendId) : "") + IconUtils.getMenuIcon(basePath, TREE_ICON_ID) + StringEscapeUtils.escapeHtml4(org.getName()));
            parentDataMap.put("id", org.getOid());
            parentDataMap.put("orgId", org.getOrgId());
            items.add(parentDataMap);
        }
        int ix = 0;
        while (ix < items.size()) {
            Map parentDataMap = (Map)items.get(ix);
            String orgId = (String)parentDataMap.get("orgId");
            this.getTreeData(basePath, checkBox, appendId, parentDataMap, orgList, orgId);
            ++ix;
        }
        return items;
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.UPDATE})
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={RuntimeException.class, IOException.class, Exception.class})
    public DefaultResult<Boolean> updateParent(OrganizationVO organization, String parentOid) throws ServiceException, Exception {
        if (organization == null || super.isBlank(organization.getOid()) || super.isBlank(parentOid)) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0001"));
        }
        DefaultResult<Boolean> result = new DefaultResult<Boolean>();
        result.setValue(Boolean.FALSE);
        result.setSystemMessage(new SystemMessage(SysMessageUtil.get("MSG_DOS0004")));
        organization = this.findOrganizationData(organization.getOid());
        this.deleteParent(organization);
        if ("root".equals(parentOid) || "r".equals(parentOid)) {
            this.createParent(organization, "0000000000");
        } else {
            OrganizationVO newParOrganization = this.findOrganizationData(parentOid);
            if (this.foundChild(organization.getOrgId(), newParOrganization.getOrgId())) {
                throw new ServiceException(SysMessageUtil.get("MSG_STD0005"));
            }
            this.createParent(organization, newParOrganization.getOrgId());
        }
        result.setValue(Boolean.TRUE);
        result.setSystemMessage(new SystemMessage(SysMessageUtil.get("MSG_DOS0003")));
        return result;
    }

    private void getTreeData(String basePath, boolean checkBox, String appendId, Map<String, Object> putObject, List<OrganizationVO> searchList, String parentOrgId) throws Exception {
        LinkedList<String> childList = new LinkedList<String>();
        this.getChildOrgIdLevelOne(searchList, parentOrgId, childList);
        if (childList.size() < 1) {
            return;
        }
        for (String childOrgId : childList) {
            OrganizationVO organization = this.getOrganizationFromSearchList(searchList, childOrgId, false);
            OrganizationVO childOrganization = this.getOrganizationFromSearchList(searchList, childOrgId, true);
            if (organization == null) continue;
            LinkedHashMap<String, Object> thePutObject = null;
            LinkedList childrenList = (LinkedList)putObject.get("children");
            if (childrenList == null) {
                childrenList = new LinkedList();
            }
            LinkedHashMap<String, String> nodeMap = new LinkedHashMap<String, String>();
            nodeMap.put("id", organization.getOid());
            nodeMap.put("name", String.valueOf(checkBox ? this.getCheckBoxHtmlContent(organization, appendId) : "") + IconUtils.getMenuIcon(basePath, TREE_ICON_ID) + StringEscapeUtils.escapeHtml4(organization.getName()));
            nodeMap.put("orgId", organization.getOrgId());
            childrenList.add(nodeMap);
            putObject.put("children", childrenList);
            if (childOrganization != null) {
                thePutObject = nodeMap;
            } else {
                nodeMap.put("type", "Leaf");
                thePutObject = putObject;
            }
            if (childOrganization == null) continue;
            this.getTreeData(basePath, checkBox, appendId, thePutObject, searchList, childOrgId);
        }
    }

    private List<String> getChildOrgIdLevelOne(List<OrganizationVO> searchList, String parentOrgId, List<String> childList) throws Exception {
        if (childList == null) {
            childList = new LinkedList<String>();
        }
        for (OrganizationVO org : searchList) {
            if (!parentOrgId.equals(org.getParId())) continue;
            childList.add(org.getOrgId());
        }
        return childList;
    }

    private OrganizationVO getOrganizationFromSearchList(List<OrganizationVO> searchList, String orgId, boolean isChild) throws Exception {
        for (OrganizationVO org : searchList) {
            if (!(!isChild ? org.getOrgId().equals(orgId) : org.getParId().equals(orgId))) continue;
            return org;
        }
        return null;
    }

    private void createParent(OrganizationVO organization, String parId) throws ServiceException, Exception {
        if (organization == null || super.isBlank(organization.getOrgId()) || super.isBlank(parId)) {
            return;
        }
        OrganizationParVO par = new OrganizationParVO();
        par.setOrgId(organization.getOrgId());
        par.setParId(parId);
        this.organizationParService.saveObject(par);
    }

    private void deleteParent(OrganizationVO organization) throws ServiceException, Exception {
        if (organization == null || super.isBlank(organization.getOrgId())) {
            return;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("orgId", organization.getOrgId());
        List parList = this.organizationParService.findListByParams(params);
        if (parList == null) {
            return;
        }
        for (BbOrganizationPar par : parList) {
            this.organizationParService.delete(par);
        }
    }

    private boolean foundChild(OrganizationVO organization) throws ServiceException, Exception {
        if (organization == null || super.isBlank(organization.getOrgId())) {
            return false;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("parId", organization.getOrgId());
        return this.organizationParService.countByParams(params) > 0L;
    }

    private boolean foundChild(String parentId, String checkOrgId) throws ServiceException, Exception {
        List<OrganizationVO> treeList = this.getOrganizationService().findForJoinParent();
        if (treeList == null || treeList.size() < 1) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0001"));
        }
        boolean f = false;
        LinkedList<OrganizationVO> childList = new LinkedList<OrganizationVO>();
        this.getChild(parentId, treeList, childList);
        int ix = 0;
        while (childList != null && ix < childList.size()) {
            if (((OrganizationVO)childList.get(ix)).getOrgId().equals(checkOrgId)) {
                f = true;
            }
            ++ix;
        }
        return f;
    }

    private void getChild(String parentId, List<OrganizationVO> tree, List<OrganizationVO> put) throws Exception {
        if (put == null || tree == null) {
            return;
        }
        if (StringUtils.isBlank(parentId) || "0000000000".equals(parentId)) {
            return;
        }
        for (OrganizationVO org : tree) {
            if (!org.getParId().equals(parentId)) continue;
            put.add(org);
            this.getChild(org.getOrgId(), tree, put);
        }
    }

    private String getCheckBoxHtmlContent(OrganizationVO organization, String appendId) throws Exception {
        String content = "";
        if (organization == null || super.isBlank(organization.getOid())) {
            return content;
        }
        String idName = "TREE_CBOX:" + organization.getOid();
        content = String.valueOf(content) + "<input type='checkbox' name='" + idName + "' id='" + idName + "' ";
        if (appendId.indexOf(String.valueOf(organization.getOid()) + ";") > -1) {
            content = String.valueOf(content) + " checked ";
        }
        content = String.valueOf(content) + " onclick='return false;' disabled />";
        return content;
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.SELECT})
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={RuntimeException.class, IOException.class, Exception.class})
    public DefaultResult<String> createOrgChartData(String basePath, OrganizationVO currentOrganization) throws ServiceException, Exception {
        List<Map<String, Object>> treeMap;
        if (currentOrganization != null && !super.isBlank(currentOrganization.getOid())) {
            currentOrganization = this.findOrganizationData(currentOrganization.getOid());
        }
        if ((treeMap = this.getTreeData(basePath, false, "")) == null || treeMap.size() < 1) {
            throw new ServiceException(SysMessageUtil.get("MSG_DOS0009"));
        }
        this.resetTreeMapContentForOrgChartData(treeMap, currentOrganization);
        HashMap<String, Object> rootMap = new HashMap<String, Object>();
        rootMap.put("name", "Organization / Department hierarchy");
        rootMap.put("title", "hierarchy structure");
        rootMap.put("children", treeMap);
        ObjectMapper objectMapper = new ObjectMapper();
        String jsonData = objectMapper.writeValueAsString(rootMap);
        String uploadOid = UploadSupportUtils.create(Constants.getSystem(), "tmp", false, jsonData.getBytes(), String.valueOf(SimpleUtils.getUUIDStr()) + ".json");
        DefaultResult<String> result = new DefaultResult<String>();
        result.setValue(uploadOid);
        result.setSystemMessage(new SystemMessage(SysMessageUtil.get("MSG_DOS0005")));
        return result;
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.SELECT})
    public DefaultResult<Map<String, Object>> getOrgChartData(String basePath, OrganizationVO currentOrganization) throws ServiceException, Exception {
        List<Map<String, Object>> treeMap;
        if (currentOrganization != null && !super.isBlank(currentOrganization.getOid())) {
            currentOrganization = this.findOrganizationData(currentOrganization.getOid());
        }
        if ((treeMap = this.getTreeData(basePath, false, "")) == null || treeMap.size() < 1) {
            throw new ServiceException(SysMessageUtil.get("MSG_DOS0009"));
        }
        this.resetTreeMapContentForOrgChartData(treeMap, currentOrganization);
        HashMap<String, Object> rootMap = new HashMap<String, Object>();
        rootMap.put("name", "Organization / Department hierarchy");
        rootMap.put("title", "hierarchy structure");
        rootMap.put("children", treeMap);
        DefaultResult<Map<String, Object>> result = new DefaultResult<Map<String, Object>>();
        result.setValue(rootMap);
        result.setSystemMessage(new SystemMessage(SysMessageUtil.get("MSG_DOS0005")));
        return result;
    }

    private void resetTreeMapContentForOrgChartData(List<Map<String, Object>> childMapList, OrganizationVO currentOrganization) throws Exception {
        for (Map<String, Object> nodeMap : childMapList) {
            String nodeOrganizationOid = String.valueOf(nodeMap.get("id"));
            nodeMap.remove("type");
            nodeMap.remove("id");
            nodeMap.remove("name");
            nodeMap.remove("orgId");
            OrganizationVO nodeOrganization = this.findOrganizationData(nodeOrganizationOid);
            if (currentOrganization != null && !super.isBlank(currentOrganization.getOid()) && currentOrganization.getOid().equals(nodeOrganizationOid)) {
                nodeMap.put("name", "<font color='#8A0808'>" + nodeOrganization.getOrgId() + "</font>");
                nodeMap.put("title", "<font color='#8A0808'>" + nodeOrganization.getName() + "</font>");
            } else {
                nodeMap.put("name", nodeOrganization.getOrgId());
                nodeMap.put("title", nodeOrganization.getName());
            }
            if (nodeMap.get("children") == null || !(nodeMap.get("children") instanceof List)) continue;
            this.resetTreeMapContentForOrgChartData((List)nodeMap.get("children"), currentOrganization);
        }
    }
}

