/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.bsc.service.logic.impl;

import com.netsteadfast.greenstep.base.SysMessageUtil;
import com.netsteadfast.greenstep.base.exception.ServiceException;
import com.netsteadfast.greenstep.base.model.DefaultResult;
import com.netsteadfast.greenstep.base.model.ServiceAuthority;
import com.netsteadfast.greenstep.base.model.ServiceMethodAuthority;
import com.netsteadfast.greenstep.base.model.ServiceMethodType;
import com.netsteadfast.greenstep.base.service.logic.CoreBaseLogicService;
import com.netsteadfast.greenstep.bsc.model.ItemTargetOrMaximumAndMinimalValue;
import com.netsteadfast.greenstep.bsc.service.IKpiService;
import com.netsteadfast.greenstep.bsc.service.IMonitorItemScoreService;
import com.netsteadfast.greenstep.bsc.service.IObjectiveService;
import com.netsteadfast.greenstep.bsc.service.IPerspectiveService;
import com.netsteadfast.greenstep.bsc.service.logic.IObjectiveLogicService;
import com.netsteadfast.greenstep.po.hbm.BbKpi;
import com.netsteadfast.greenstep.po.hbm.BbMonitorItemScore;
import com.netsteadfast.greenstep.po.hbm.BbObjective;
import com.netsteadfast.greenstep.po.hbm.BbPerspective;
import com.netsteadfast.greenstep.util.SimpleUtils;
import com.netsteadfast.greenstep.vo.KpiVO;
import com.netsteadfast.greenstep.vo.MonitorItemScoreVO;
import com.netsteadfast.greenstep.vo.ObjectiveVO;
import com.netsteadfast.greenstep.vo.PerspectiveVO;
import java.io.IOException;
import java.util.HashMap;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@ServiceAuthority(check=true)
@Service(value="bsc.service.logic.ObjectiveLogicService")
@Transactional(propagation=Propagation.REQUIRED, readOnly=true)
public class ObjectiveLogicServiceImpl
extends CoreBaseLogicService
implements IObjectiveLogicService {
    protected Logger logger = Logger.getLogger(ObjectiveLogicServiceImpl.class);
    private static final int MAX_DESCRIPTION_LENGTH = 500;
    private IPerspectiveService<PerspectiveVO, BbPerspective, String> perspectiveService;
    private IObjectiveService<ObjectiveVO, BbObjective, String> objectiveService;
    private IKpiService<KpiVO, BbKpi, String> kpiService;
    private IMonitorItemScoreService<MonitorItemScoreVO, BbMonitorItemScore, String> monitorItemScoreService;

    public IPerspectiveService<PerspectiveVO, BbPerspective, String> getPerspectiveService() {
        return this.perspectiveService;
    }

    @Autowired
    @Resource(name="bsc.service.PerspectiveService")
    @Required
    public void setPerspectiveService(IPerspectiveService<PerspectiveVO, BbPerspective, String> perspectiveService) {
        this.perspectiveService = perspectiveService;
    }

    public IObjectiveService<ObjectiveVO, BbObjective, String> getObjectiveService() {
        return this.objectiveService;
    }

    @Autowired
    @Resource(name="bsc.service.ObjectiveService")
    @Required
    public void setObjectiveService(IObjectiveService<ObjectiveVO, BbObjective, String> objectiveService) {
        this.objectiveService = objectiveService;
    }

    public IKpiService<KpiVO, BbKpi, String> getKpiService() {
        return this.kpiService;
    }

    @Autowired
    @Resource(name="bsc.service.KpiService")
    @Required
    public void setKpiService(IKpiService<KpiVO, BbKpi, String> kpiService) {
        this.kpiService = kpiService;
    }

    public IMonitorItemScoreService<MonitorItemScoreVO, BbMonitorItemScore, String> getMonitorItemScoreService() {
        return this.monitorItemScoreService;
    }

    @Autowired
    @Resource(name="bsc.service.MonitorItemScoreService")
    @Required
    public void setMonitorItemScoreService(IMonitorItemScoreService<MonitorItemScoreVO, BbMonitorItemScore, String> monitorItemScoreService) {
        this.monitorItemScoreService = monitorItemScoreService;
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.SELECT})
    @Transactional(propagation=Propagation.REQUIRES_NEW, readOnly=true)
    public String findForMaxObjId(String date) throws ServiceException, Exception {
        if (super.isBlank(date) || !NumberUtils.isCreatable(date) || date.length() != 8) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0001"));
        }
        String maxVisionId = this.objectiveService.findForMaxObjId("OBJ" + date);
        if (StringUtils.isBlank(maxVisionId)) {
            return "OBJ" + date + "001";
        }
        int maxSeq = Integer.parseInt(maxVisionId.substring(11, 14)) + 1;
        if (maxSeq > 999) {
            throw new ServiceException(String.valueOf(SysMessageUtil.get("MSG_STD0005")) + " over max seq 999!");
        }
        return "OBJ" + date + StringUtils.leftPad(String.valueOf(maxSeq), 3, "0");
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.INSERT})
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={RuntimeException.class, IOException.class, Exception.class})
    public DefaultResult<ObjectiveVO> create(ObjectiveVO objective, String perspectiveOid) throws ServiceException, Exception {
        if (objective == null || super.isBlank(perspectiveOid)) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0001"));
        }
        PerspectiveVO perspective = new PerspectiveVO();
        perspective.setOid(perspectiveOid);
        DefaultResult<PerspectiveVO> pResult = this.perspectiveService.findObjectByOid(perspective);
        if (pResult.getValue() == null) {
            throw new ServiceException(pResult.getSystemMessage().getValue());
        }
        perspective = pResult.getValue();
        objective.setPerId(perspective.getPerId());
        if (!SimpleUtils.checkBeTrueOf_azAZ09(4, 14, objective.getObjId())) {
            objective.setObjId(this.findForMaxObjId(SimpleUtils.getStrYMD("")));
        }
        this.setStringValueMaxLength(objective, "description", 500);
        objective.setTarget(ItemTargetOrMaximumAndMinimalValue.get(objective.getTarget()));
        objective.setMin(ItemTargetOrMaximumAndMinimalValue.get(objective.getMin()));
        return this.objectiveService.saveObject(objective);
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.UPDATE})
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={RuntimeException.class, IOException.class, Exception.class})
    public DefaultResult<ObjectiveVO> update(ObjectiveVO objective, String perspectiveOid) throws ServiceException, Exception {
        if (objective == null || super.isBlank(objective.getOid()) || super.isBlank(perspectiveOid)) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0001"));
        }
        DefaultResult<ObjectiveVO> oldResult = this.objectiveService.findObjectByOid(objective);
        if (oldResult.getValue() == null) {
            throw new ServiceException(oldResult.getSystemMessage().getValue());
        }
        PerspectiveVO perspective = new PerspectiveVO();
        perspective.setOid(perspectiveOid);
        DefaultResult<PerspectiveVO> pResult = this.perspectiveService.findObjectByOid(perspective);
        if (pResult.getValue() == null) {
            throw new ServiceException(pResult.getSystemMessage().getValue());
        }
        perspective = pResult.getValue();
        objective.setObjId(oldResult.getValue().getObjId());
        objective.setPerId(perspective.getPerId());
        this.setStringValueMaxLength(objective, "description", 500);
        objective.setTarget(ItemTargetOrMaximumAndMinimalValue.get(objective.getTarget()));
        objective.setMin(ItemTargetOrMaximumAndMinimalValue.get(objective.getMin()));
        return this.objectiveService.updateObject(objective);
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.DELETE})
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={RuntimeException.class, IOException.class, Exception.class})
    public DefaultResult<Boolean> delete(ObjectiveVO objective) throws ServiceException, Exception {
        if (objective == null || super.isBlank(objective.getOid())) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0001"));
        }
        DefaultResult<ObjectiveVO> oldResult = this.objectiveService.findObjectByOid(objective);
        if (oldResult.getValue() == null) {
            throw new ServiceException(oldResult.getSystemMessage().getValue());
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("objId", oldResult.getValue().getObjId());
        if (this.kpiService.countByParams(params) > 0L) {
            throw new ServiceException(SysMessageUtil.get("MSG_DOS0010"));
        }
        this.monitorItemScoreService.deleteForTypeClass("3", oldResult.getValue().getObjId());
        return this.objectiveService.deleteObject(objective);
    }
}

