/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.bsc.service.logic.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netsteadfast.greenstep.base.Constants;
import com.netsteadfast.greenstep.base.SysMessageUtil;
import com.netsteadfast.greenstep.base.exception.ServiceException;
import com.netsteadfast.greenstep.base.model.DefaultResult;
import com.netsteadfast.greenstep.base.model.ServiceAuthority;
import com.netsteadfast.greenstep.base.model.ServiceMethodAuthority;
import com.netsteadfast.greenstep.base.model.ServiceMethodType;
import com.netsteadfast.greenstep.base.service.logic.BscBaseLogicService;
import com.netsteadfast.greenstep.bsc.model.ItemTargetOrMaximumAndMinimalValue;
import com.netsteadfast.greenstep.bsc.service.IFormulaService;
import com.netsteadfast.greenstep.bsc.service.IKpiAttacService;
import com.netsteadfast.greenstep.bsc.service.IKpiEmplService;
import com.netsteadfast.greenstep.bsc.service.IKpiOrgaService;
import com.netsteadfast.greenstep.bsc.service.IKpiService;
import com.netsteadfast.greenstep.bsc.service.IMeasureDataService;
import com.netsteadfast.greenstep.bsc.service.IMonitorItemScoreService;
import com.netsteadfast.greenstep.bsc.service.IObjectiveService;
import com.netsteadfast.greenstep.bsc.service.IPdcaKpisService;
import com.netsteadfast.greenstep.bsc.service.logic.IKpiLogicService;
import com.netsteadfast.greenstep.bsc.util.AggregationMethodUtils;
import com.netsteadfast.greenstep.po.hbm.BbFormula;
import com.netsteadfast.greenstep.po.hbm.BbKpi;
import com.netsteadfast.greenstep.po.hbm.BbKpiAttac;
import com.netsteadfast.greenstep.po.hbm.BbKpiEmpl;
import com.netsteadfast.greenstep.po.hbm.BbKpiOrga;
import com.netsteadfast.greenstep.po.hbm.BbMeasureData;
import com.netsteadfast.greenstep.po.hbm.BbMonitorItemScore;
import com.netsteadfast.greenstep.po.hbm.BbObjective;
import com.netsteadfast.greenstep.po.hbm.BbPdcaKpis;
import com.netsteadfast.greenstep.util.UploadSupportUtils;
import com.netsteadfast.greenstep.vo.EmployeeVO;
import com.netsteadfast.greenstep.vo.FormulaVO;
import com.netsteadfast.greenstep.vo.KpiAttacVO;
import com.netsteadfast.greenstep.vo.KpiEmplVO;
import com.netsteadfast.greenstep.vo.KpiOrgaVO;
import com.netsteadfast.greenstep.vo.KpiVO;
import com.netsteadfast.greenstep.vo.MeasureDataVO;
import com.netsteadfast.greenstep.vo.MonitorItemScoreVO;
import com.netsteadfast.greenstep.vo.ObjectiveVO;
import com.netsteadfast.greenstep.vo.OrganizationVO;
import com.netsteadfast.greenstep.vo.PdcaKpisVO;
import com.netsteadfast.greenstep.vo.SysUploadVO;
import com.thoughtworks.xstream.XStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebService;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@ServiceAuthority(check=true)
@Service(value="bsc.service.logic.KpiLogicService")
@WebService
@Path(value="/")
@Produces(value={"application/json"})
@Transactional(propagation=Propagation.REQUIRED, readOnly=true)
public class KpiLogicServiceImpl
extends BscBaseLogicService
implements IKpiLogicService {
    protected Logger logger = Logger.getLogger(KpiLogicServiceImpl.class);
    private static final int MAX_DESCRIPTION_LENGTH = 500;
    private IObjectiveService<ObjectiveVO, BbObjective, String> objectiveService;
    private IKpiService<KpiVO, BbKpi, String> kpiService;
    private IFormulaService<FormulaVO, BbFormula, String> formulaService;
    private IKpiOrgaService<KpiOrgaVO, BbKpiOrga, String> kpiOrgaService;
    private IKpiEmplService<KpiEmplVO, BbKpiEmpl, String> kpiEmplService;
    private IMeasureDataService<MeasureDataVO, BbMeasureData, String> measureDataService;
    private IKpiAttacService<KpiAttacVO, BbKpiAttac, String> kpiAttacService;
    private IPdcaKpisService<PdcaKpisVO, BbPdcaKpis, String> pdcaKpisService;
    private IMonitorItemScoreService<MonitorItemScoreVO, BbMonitorItemScore, String> monitorItemScoreService;

    public IObjectiveService<ObjectiveVO, BbObjective, String> getObjectiveService() {
        return this.objectiveService;
    }

    @Autowired
    @Resource(name="bsc.service.ObjectiveService")
    @Required
    public void setObjectiveService(IObjectiveService<ObjectiveVO, BbObjective, String> objectiveService) {
        this.objectiveService = objectiveService;
    }

    public IKpiService<KpiVO, BbKpi, String> getKpiService() {
        return this.kpiService;
    }

    @Autowired
    @Resource(name="bsc.service.KpiService")
    @Required
    public void setKpiService(IKpiService<KpiVO, BbKpi, String> kpiService) {
        this.kpiService = kpiService;
    }

    public IFormulaService<FormulaVO, BbFormula, String> getFormulaService() {
        return this.formulaService;
    }

    @Autowired
    @Resource(name="bsc.service.FormulaService")
    @Required
    public void setFormulaService(IFormulaService<FormulaVO, BbFormula, String> formulaService) {
        this.formulaService = formulaService;
    }

    public IKpiOrgaService<KpiOrgaVO, BbKpiOrga, String> getKpiOrgaService() {
        return this.kpiOrgaService;
    }

    @Autowired
    @Resource(name="bsc.service.KpiOrgaService")
    @Required
    public void setKpiOrgaService(IKpiOrgaService<KpiOrgaVO, BbKpiOrga, String> kpiOrgaService) {
        this.kpiOrgaService = kpiOrgaService;
    }

    public IKpiEmplService<KpiEmplVO, BbKpiEmpl, String> getKpiEmplService() {
        return this.kpiEmplService;
    }

    @Autowired
    @Resource(name="bsc.service.KpiEmplService")
    @Required
    public void setKpiEmplService(IKpiEmplService<KpiEmplVO, BbKpiEmpl, String> kpiEmplService) {
        this.kpiEmplService = kpiEmplService;
    }

    public IMeasureDataService<MeasureDataVO, BbMeasureData, String> getMeasureDataService() {
        return this.measureDataService;
    }

    @Autowired
    @Resource(name="bsc.service.MeasureDataService")
    @Required
    public void setMeasureDataService(IMeasureDataService<MeasureDataVO, BbMeasureData, String> measureDataService) {
        this.measureDataService = measureDataService;
    }

    public IKpiAttacService<KpiAttacVO, BbKpiAttac, String> getKpiAttacService() {
        return this.kpiAttacService;
    }

    @Autowired
    @Resource(name="bsc.service.KpiAttacService")
    @Required
    public void setKpiAttacService(IKpiAttacService<KpiAttacVO, BbKpiAttac, String> kpiAttacService) {
        this.kpiAttacService = kpiAttacService;
    }

    public IPdcaKpisService<PdcaKpisVO, BbPdcaKpis, String> getPdcaKpisService() {
        return this.pdcaKpisService;
    }

    @Autowired
    @Resource(name="bsc.service.PdcaKpisService")
    @Required
    public void setPdcaKpisService(IPdcaKpisService<PdcaKpisVO, BbPdcaKpis, String> pdcaKpisService) {
        this.pdcaKpisService = pdcaKpisService;
    }

    public IMonitorItemScoreService<MonitorItemScoreVO, BbMonitorItemScore, String> getMonitorItemScoreService() {
        return this.monitorItemScoreService;
    }

    @Autowired
    @Resource(name="bsc.service.MonitorItemScoreService")
    @Required
    public void setMonitorItemScoreService(IMonitorItemScoreService<MonitorItemScoreVO, BbMonitorItemScore, String> monitorItemScoreService) {
        this.monitorItemScoreService = monitorItemScoreService;
    }

    private FormulaVO fetchFormulaByOid(String formulaOid) throws ServiceException, Exception {
        FormulaVO formula = new FormulaVO();
        formula.setOid(formulaOid);
        DefaultResult<FormulaVO> forResult = this.formulaService.findObjectByOid(formula);
        if (forResult.getValue() == null) {
            throw new ServiceException(forResult.getSystemMessage().getValue());
        }
        return forResult.getValue();
    }

    private void handlerDataForCreateOrUpdate(KpiVO kpi, String objectiveOid, String formulaOid, String aggrOid, String trendsFormulaOid) throws ServiceException, Exception {
        ObjectiveVO objective = new ObjectiveVO();
        objective.setOid(objectiveOid);
        DefaultResult<ObjectiveVO> objResult = this.objectiveService.findObjectByOid(objective);
        if (objResult.getValue() == null) {
            throw new ServiceException(objResult.getSystemMessage().getValue());
        }
        objective = objResult.getValue();
        kpi.setObjId(objective.getObjId());
        kpi.setForId(this.fetchFormulaByOid(formulaOid).getForId());
        kpi.setTrendsForId(this.fetchFormulaByOid(trendsFormulaOid).getForId());
        kpi.setCal(AggregationMethodUtils.findSimpleByOid(aggrOid).getAggrId());
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.INSERT})
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={RuntimeException.class, IOException.class, Exception.class})
    public DefaultResult<KpiVO> create(KpiVO kpi, String objectiveOid, String formulaOid, String aggrOid, List<String> organizationOids, List<String> employeeOids, String trendsFormulaOid, List<String> attachment) throws ServiceException, Exception {
        if (kpi == null || super.isNoSelectId(objectiveOid) || super.isNoSelectId(formulaOid) || super.isNoSelectId(aggrOid) || super.isNoSelectId(trendsFormulaOid)) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0001"));
        }
        this.setStringValueMaxLength(kpi, "description", 500);
        this.handlerDataForCreateOrUpdate(kpi, objectiveOid, formulaOid, aggrOid, trendsFormulaOid);
        kpi.setTarget(ItemTargetOrMaximumAndMinimalValue.get(kpi.getTarget()));
        kpi.setMin(ItemTargetOrMaximumAndMinimalValue.get(kpi.getMin()));
        kpi.setMax(ItemTargetOrMaximumAndMinimalValue.get(kpi.getMax()));
        DefaultResult<KpiVO> result = this.kpiService.saveObject(kpi);
        if (result.getValue() == null) {
            throw new ServiceException(result.getSystemMessage().getValue());
        }
        this.createKpiOrganization(result.getValue(), organizationOids);
        this.createKpiEmployee(result.getValue(), employeeOids);
        this.createKpiAttachment(kpi, attachment);
        return result;
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.UPDATE})
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={RuntimeException.class, IOException.class, Exception.class})
    public DefaultResult<KpiVO> update(KpiVO kpi, String objectiveOid, String formulaOid, String aggrOid, List<String> organizationOids, List<String> employeeOids, String trendsFormulaOid, List<String> attachment) throws ServiceException, Exception {
        if (kpi == null || super.isBlank(kpi.getOid()) || super.isNoSelectId(objectiveOid) || super.isNoSelectId(formulaOid) || super.isNoSelectId(aggrOid) || super.isNoSelectId(trendsFormulaOid)) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0001"));
        }
        DefaultResult<KpiVO> oldResult = this.kpiService.findObjectByOid(kpi);
        if (oldResult.getValue() == null) {
            throw new ServiceException(oldResult.getSystemMessage().getValue());
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("kpiId", oldResult.getValue().getId());
        if (this.pdcaKpisService.countByParams(paramMap) > 0L && !"Y".equals(kpi.getActivate())) {
            throw new ServiceException("Cannot disable activate options, because the KPI is used in!");
        }
        this.setStringValueMaxLength(kpi, "description", 500);
        this.handlerDataForCreateOrUpdate(kpi, objectiveOid, formulaOid, aggrOid, trendsFormulaOid);
        kpi.setId(oldResult.getValue().getId());
        kpi.setTarget(ItemTargetOrMaximumAndMinimalValue.get(kpi.getTarget()));
        kpi.setMin(ItemTargetOrMaximumAndMinimalValue.get(kpi.getMin()));
        kpi.setMax(ItemTargetOrMaximumAndMinimalValue.get(kpi.getMax()));
        DefaultResult<KpiVO> result = this.kpiService.updateObject(kpi);
        if (result.getValue() == null) {
            throw new ServiceException(result.getSystemMessage().getValue());
        }
        kpi = result.getValue();
        this.deleteKpiOrganization(kpi);
        this.deleteKpiEmployee(kpi);
        this.deleteKpiAttachment(kpi);
        this.createKpiOrganization(result.getValue(), organizationOids);
        this.createKpiEmployee(result.getValue(), employeeOids);
        this.createKpiAttachment(kpi, attachment);
        return result;
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.DELETE})
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={RuntimeException.class, IOException.class, Exception.class})
    public DefaultResult<Boolean> delete(KpiVO kpi) throws ServiceException, Exception {
        if (kpi == null || super.isBlank(kpi.getOid())) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0001"));
        }
        DefaultResult<KpiVO> oldResult = this.kpiService.findObjectByOid(kpi);
        if (oldResult.getValue() == null) {
            throw new ServiceException(oldResult.getSystemMessage().getValue());
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("kpiId", oldResult.getValue().getId());
        if (this.pdcaKpisService.countByParams(paramMap) > 0L) {
            String msg = "PDCA Project used the KPI, " + SysMessageUtil.get("MSG_DOS0010");
            throw new ServiceException(msg);
        }
        this.deleteKpiOrganization(oldResult.getValue());
        this.deleteKpiEmployee(oldResult.getValue());
        this.deleteKpiAttachment(oldResult.getValue());
        this.measureDataService.deleteForKpiId(oldResult.getValue().getId());
        this.monitorItemScoreService.deleteForTypeClass("4", oldResult.getValue().getId());
        return this.kpiService.deleteObject(kpi);
    }

    private void deleteKpiOrganization(KpiVO kpi) throws ServiceException, Exception {
        if (kpi == null) {
            return;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("kpiId", kpi.getId());
        List searchList = this.kpiOrgaService.findListByParams(params);
        if (searchList == null || searchList.size() < 1) {
            return;
        }
        for (BbKpiOrga kpiOrga : searchList) {
            this.kpiOrgaService.delete(kpiOrga);
        }
    }

    private void deleteKpiEmployee(KpiVO kpi) throws ServiceException, Exception {
        if (kpi == null) {
            return;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("kpiId", kpi.getId());
        List searchList = this.kpiEmplService.findListByParams(params);
        if (searchList == null || searchList.size() < 1) {
            return;
        }
        for (BbKpiEmpl kpiEmpl : searchList) {
            this.kpiEmplService.delete(kpiEmpl);
        }
    }

    private void deleteKpiAttachment(KpiVO kpi) throws ServiceException, Exception {
        if (kpi == null) {
            return;
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("kpiId", kpi.getId());
        List searchList = this.kpiAttacService.findListByParams(paramMap);
        if (searchList == null || searchList.size() < 1) {
            return;
        }
        for (BbKpiAttac attac : searchList) {
            UploadSupportUtils.updateType(attac.getUploadOid(), "tmp");
            this.kpiAttacService.delete(attac);
        }
    }

    private void createKpiOrganization(KpiVO kpi, List<String> organizationOids) throws ServiceException, Exception {
        if (kpi == null || organizationOids == null || organizationOids.size() < 1) {
            return;
        }
        for (String oid : organizationOids) {
            OrganizationVO organization = this.findOrganizationData(oid);
            KpiOrgaVO kpiOrga = new KpiOrgaVO();
            kpiOrga.setKpiId(kpi.getId());
            kpiOrga.setOrgId(organization.getOrgId());
            this.kpiOrgaService.saveObject(kpiOrga);
        }
    }

    private void createKpiEmployee(KpiVO kpi, List<String> employeeOids) throws ServiceException, Exception {
        if (kpi == null || employeeOids == null || employeeOids.size() < 1) {
            return;
        }
        for (String oid : employeeOids) {
            EmployeeVO employee = this.findEmployeeData(oid);
            KpiEmplVO kpiEmpl = new KpiEmplVO();
            kpiEmpl.setKpiId(kpi.getId());
            kpiEmpl.setEmpId(employee.getEmpId());
            this.kpiEmplService.saveObject(kpiEmpl);
        }
    }

    private void createKpiAttachment(KpiVO kpi, List<String> attachment) throws ServiceException, Exception {
        if (kpi == null || attachment == null || attachment.size() < 1) {
            return;
        }
        for (String uploadOid : attachment) {
            SysUploadVO upload = this.findUploadDataForNoByteContent(uploadOid);
            if (!upload.getSystem().equals(Constants.getSystem()) || !upload.getType().equals("tmp")) {
                throw new ServiceException(SysMessageUtil.get("MSG_STD0005"));
            }
            KpiAttacVO attac = new KpiAttacVO();
            attac.setKpiId(kpi.getId());
            attac.setUploadOid(uploadOid);
            attac.setViewMode(UploadSupportUtils.getViewMode(upload.getShowName()));
            DefaultResult<KpiAttacVO> result = this.kpiAttacService.saveObject(attac);
            if (result.getValue() == null) {
                throw new ServiceException(result.getSystemMessage().getValue());
            }
            UploadSupportUtils.updateType(uploadOid, "kpi-doc");
        }
    }

    @Override
    @WebMethod
    @GET
    @Path(value="/kpis/{format}")
    public String findKpis(@WebParam(name="format") @PathParam(value="format") String format) throws ServiceException, Exception {
        List kpis;
        block9: {
            kpis = null;
            try {
                try {
                    kpis = this.kpiService.findListVOByParams(null);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (kpis == null) {
                        kpis = new ArrayList();
                    }
                    break block9;
                }
            }
            catch (Throwable throwable) {
                if (kpis == null) {
                    kpis = new ArrayList();
                }
                throw throwable;
            }
            if (kpis == null) {
                kpis = new ArrayList();
            }
        }
        if ("json".equals(format)) {
            HashMap paramMap = new HashMap();
            paramMap.put("KPIS", kpis);
            ObjectMapper mapper = new ObjectMapper();
            return mapper.writeValueAsString(paramMap);
        }
        XStream xstream = new XStream();
        xstream.setMode(1001);
        xstream.alias("KPIS", List.class);
        xstream.alias("KPI", KpiVO.class);
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n" + xstream.toXML(kpis);
    }
}

