/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.bsc.service.logic.impl;

import com.netsteadfast.greenstep.base.SysMessageUtil;
import com.netsteadfast.greenstep.base.exception.ServiceException;
import com.netsteadfast.greenstep.base.model.DefaultResult;
import com.netsteadfast.greenstep.base.model.ServiceAuthority;
import com.netsteadfast.greenstep.base.model.ServiceMethodAuthority;
import com.netsteadfast.greenstep.base.model.ServiceMethodType;
import com.netsteadfast.greenstep.base.model.SystemMessage;
import com.netsteadfast.greenstep.base.service.logic.BaseLogicService;
import com.netsteadfast.greenstep.bsc.model.BscKpiCode;
import com.netsteadfast.greenstep.bsc.model.BscMeasureDataFrequency;
import com.netsteadfast.greenstep.bsc.service.IAggregationMethodService;
import com.netsteadfast.greenstep.bsc.service.IEmployeeService;
import com.netsteadfast.greenstep.bsc.service.IFormulaService;
import com.netsteadfast.greenstep.bsc.service.IKpiService;
import com.netsteadfast.greenstep.bsc.service.IMeasureDataService;
import com.netsteadfast.greenstep.bsc.service.IObjectiveService;
import com.netsteadfast.greenstep.bsc.service.IOrganizationService;
import com.netsteadfast.greenstep.bsc.service.IPerspectiveService;
import com.netsteadfast.greenstep.bsc.service.IVisionService;
import com.netsteadfast.greenstep.bsc.service.logic.IImportDataLogicService;
import com.netsteadfast.greenstep.bsc.service.logic.IKpiLogicService;
import com.netsteadfast.greenstep.bsc.service.logic.IObjectiveLogicService;
import com.netsteadfast.greenstep.bsc.service.logic.IPerspectiveLogicService;
import com.netsteadfast.greenstep.bsc.service.logic.IVisionLogicService;
import com.netsteadfast.greenstep.bsc.util.AggregationMethodUtils;
import com.netsteadfast.greenstep.bsc.util.BscFormulaUtils;
import com.netsteadfast.greenstep.po.hbm.BbAggregationMethod;
import com.netsteadfast.greenstep.po.hbm.BbEmployee;
import com.netsteadfast.greenstep.po.hbm.BbFormula;
import com.netsteadfast.greenstep.po.hbm.BbKpi;
import com.netsteadfast.greenstep.po.hbm.BbMeasureData;
import com.netsteadfast.greenstep.po.hbm.BbObjective;
import com.netsteadfast.greenstep.po.hbm.BbOrganization;
import com.netsteadfast.greenstep.po.hbm.BbPerspective;
import com.netsteadfast.greenstep.po.hbm.BbVision;
import com.netsteadfast.greenstep.util.SimpleUtils;
import com.netsteadfast.greenstep.util.UploadSupportUtils;
import com.netsteadfast.greenstep.vo.AggregationMethodVO;
import com.netsteadfast.greenstep.vo.EmployeeVO;
import com.netsteadfast.greenstep.vo.FormulaVO;
import com.netsteadfast.greenstep.vo.KpiVO;
import com.netsteadfast.greenstep.vo.MeasureDataVO;
import com.netsteadfast.greenstep.vo.ObjectiveVO;
import com.netsteadfast.greenstep.vo.OrganizationVO;
import com.netsteadfast.greenstep.vo.PerspectiveVO;
import com.netsteadfast.greenstep.vo.VisionVO;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@ServiceAuthority(check=true)
@Service(value="bsc.service.logic.ImportDataLogicService")
@Transactional(propagation=Propagation.REQUIRED, readOnly=true)
public class ImportDataLogicServiceImpl
extends BaseLogicService
implements IImportDataLogicService {
    protected Logger logger = Logger.getLogger(ImportDataLogicServiceImpl.class);
    private IVisionLogicService visionLogicService;
    private IVisionService<VisionVO, BbVision, String> visionService;
    private IPerspectiveLogicService perspectiveLogicService;
    private IPerspectiveService<PerspectiveVO, BbPerspective, String> perspectiveService;
    private IObjectiveLogicService objectiveLogicService;
    private IObjectiveService<ObjectiveVO, BbObjective, String> objectiveService;
    private IKpiLogicService kpiLogicService;
    private IKpiService<KpiVO, BbKpi, String> kpiService;
    private IFormulaService<FormulaVO, BbFormula, String> formulaService;
    private IAggregationMethodService<AggregationMethodVO, BbAggregationMethod, String> aggregationMethodService;
    private IEmployeeService<EmployeeVO, BbEmployee, String> employeeService;
    private IOrganizationService<OrganizationVO, BbOrganization, String> organizationService;
    private IMeasureDataService<MeasureDataVO, BbMeasureData, String> measureDataService;

    public IVisionLogicService getVisionLogicService() {
        return this.visionLogicService;
    }

    @Autowired
    @Resource(name="bsc.service.logic.VisionLogicService")
    @Required
    public void setVisionLogicService(IVisionLogicService visionLogicService) {
        this.visionLogicService = visionLogicService;
    }

    public IVisionService<VisionVO, BbVision, String> getVisionService() {
        return this.visionService;
    }

    @Autowired
    @Resource(name="bsc.service.VisionService")
    @Required
    public void setVisionService(IVisionService<VisionVO, BbVision, String> visionService) {
        this.visionService = visionService;
    }

    public IPerspectiveLogicService getPerspectiveLogicService() {
        return this.perspectiveLogicService;
    }

    @Autowired
    @Resource(name="bsc.service.logic.PerspectiveLogicService")
    @Required
    public void setPerspectiveLogicService(IPerspectiveLogicService perspectiveLogicService) {
        this.perspectiveLogicService = perspectiveLogicService;
    }

    public IPerspectiveService<PerspectiveVO, BbPerspective, String> getPerspectiveService() {
        return this.perspectiveService;
    }

    @Autowired
    @Resource(name="bsc.service.PerspectiveService")
    @Required
    public void setPerspectiveService(IPerspectiveService<PerspectiveVO, BbPerspective, String> perspectiveService) {
        this.perspectiveService = perspectiveService;
    }

    public IObjectiveLogicService getObjectiveLogicService() {
        return this.objectiveLogicService;
    }

    @Autowired
    @Resource(name="bsc.service.logic.ObjectiveLogicService")
    @Required
    public void setObjectiveLogicService(IObjectiveLogicService objectiveLogicService) {
        this.objectiveLogicService = objectiveLogicService;
    }

    public IObjectiveService<ObjectiveVO, BbObjective, String> getObjectiveService() {
        return this.objectiveService;
    }

    @Autowired
    @Resource(name="bsc.service.ObjectiveService")
    @Required
    public void setObjectiveService(IObjectiveService<ObjectiveVO, BbObjective, String> objectiveService) {
        this.objectiveService = objectiveService;
    }

    public IKpiLogicService getKpiLogicService() {
        return this.kpiLogicService;
    }

    @Autowired
    @Resource(name="bsc.service.logic.KpiLogicService")
    @Required
    public void setKpiLogicService(IKpiLogicService kpiLogicService) {
        this.kpiLogicService = kpiLogicService;
    }

    public IKpiService<KpiVO, BbKpi, String> getKpiService() {
        return this.kpiService;
    }

    @Autowired
    @Resource(name="bsc.service.KpiService")
    @Required
    public void setKpiService(IKpiService<KpiVO, BbKpi, String> kpiService) {
        this.kpiService = kpiService;
    }

    public IFormulaService<FormulaVO, BbFormula, String> getFormulaService() {
        return this.formulaService;
    }

    @Autowired
    @Resource(name="bsc.service.FormulaService")
    @Required
    public void setFormulaService(IFormulaService<FormulaVO, BbFormula, String> formulaService) {
        this.formulaService = formulaService;
    }

    public IAggregationMethodService<AggregationMethodVO, BbAggregationMethod, String> getAggregationMethodService() {
        return this.aggregationMethodService;
    }

    @Autowired
    @Resource(name="bsc.service.AggregationMethodService")
    @Required
    public void setAggregationMethodService(IAggregationMethodService<AggregationMethodVO, BbAggregationMethod, String> aggregationMethodService) {
        this.aggregationMethodService = aggregationMethodService;
    }

    public IEmployeeService<EmployeeVO, BbEmployee, String> getEmployeeService() {
        return this.employeeService;
    }

    @Autowired
    @Resource(name="bsc.service.EmployeeService")
    @Required
    public void setEmployeeService(IEmployeeService<EmployeeVO, BbEmployee, String> employeeService) {
        this.employeeService = employeeService;
    }

    public IOrganizationService<OrganizationVO, BbOrganization, String> getOrganizationService() {
        return this.organizationService;
    }

    @Autowired
    @Resource(name="bsc.service.OrganizationService")
    @Required
    public void setOrganizationService(IOrganizationService<OrganizationVO, BbOrganization, String> organizationService) {
        this.organizationService = organizationService;
    }

    public IMeasureDataService<MeasureDataVO, BbMeasureData, String> getMeasureDataService() {
        return this.measureDataService;
    }

    @Autowired
    @Resource(name="bsc.service.MeasureDataService")
    @Required
    public void setMeasureDataService(IMeasureDataService<MeasureDataVO, BbMeasureData, String> measureDataService) {
        this.measureDataService = measureDataService;
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.INSERT, ServiceMethodType.UPDATE})
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={RuntimeException.class, IOException.class, Exception.class})
    public DefaultResult<Boolean> importVisionCsv(String uploadOid) throws ServiceException, Exception {
        List<Map<String, String>> csvResults = UploadSupportUtils.getTransformSegmentData(uploadOid, "TRAN001");
        if (csvResults.size() < 1) {
            throw new ServiceException(SysMessageUtil.get("MSG_DOS0001"));
        }
        boolean success = false;
        DefaultResult<Boolean> result = new DefaultResult<Boolean>();
        StringBuilder msg = new StringBuilder();
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        int i = 0;
        while (i < csvResults.size()) {
            int row = i + 1;
            Map<String, String> data = csvResults.get(i);
            String visId = data.get("VIS_ID");
            String title = data.get("TITLE");
            String content = data.get("CONTENT");
            if (super.isBlank(visId)) {
                msg.append("row: " + row + " id is blank." + "<BR/>");
            } else if (super.isBlank(title)) {
                msg.append("row: " + row + " title is blank." + "<BR/>");
            } else if (super.isBlank(content)) {
                msg.append("row: " + row + " content is blank." + "<BR/>");
            } else {
                VisionVO vision = new VisionVO();
                vision.setVisId(visId);
                vision.setTitle(title);
                vision.setContent(content.getBytes("utf-8"));
                paramMap.put("visId", visId);
                if (this.visionService.countByParams(paramMap) > 0L) {
                    DefaultResult<VisionVO> oldResult = this.visionService.findByUK(vision);
                    vision.setOid(oldResult.getValue().getOid());
                    this.visionLogicService.update(vision);
                } else {
                    this.visionLogicService.create(vision);
                }
                success = true;
            }
            ++i;
        }
        if (msg.length() > 0) {
            result.setSystemMessage(new SystemMessage(msg.toString()));
        } else {
            result.setSystemMessage(new SystemMessage(SysMessageUtil.get("MSG_DOS0003")));
        }
        result.setValue(success);
        return result;
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.INSERT, ServiceMethodType.UPDATE})
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={RuntimeException.class, IOException.class, Exception.class})
    public DefaultResult<Boolean> importPerspectivesCsv(String uploadOid) throws ServiceException, Exception {
        List<Map<String, String>> csvResults = UploadSupportUtils.getTransformSegmentData(uploadOid, "TRAN002");
        if (csvResults.size() < 1) {
            throw new ServiceException(SysMessageUtil.get("MSG_DOS0001"));
        }
        boolean success = false;
        DefaultResult<Boolean> result = new DefaultResult<Boolean>();
        StringBuilder msg = new StringBuilder();
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        int i = 0;
        while (i < csvResults.size()) {
            int row = i + 1;
            Map<String, String> data = csvResults.get(i);
            String perId = data.get("PER_ID");
            String visId = data.get("VIS_ID");
            String name = data.get("NAME");
            String weight = data.get("WEIGHT");
            String target = data.get("TARGET");
            String min = data.get("MIN");
            String description = data.get("DESCRIPTION");
            if (super.isBlank(perId)) {
                msg.append("row: " + row + " perspective-id is blank." + "<BR/>");
            } else if (super.isBlank(visId)) {
                msg.append("row: " + row + " vision-id is blank." + "<BR/>");
            } else if (super.isBlank(name)) {
                msg.append("row: " + row + " name is blank." + "<BR/>");
            } else if (super.isBlank(weight)) {
                msg.append("row: " + row + " weight is blank." + "<BR/>");
            } else if (super.isBlank(target)) {
                msg.append("row: " + row + " target is blank." + "<BR/>");
            } else if (super.isBlank(min)) {
                msg.append("row: " + row + " min is blank." + "<BR/>");
            } else if (!NumberUtils.isCreatable(weight)) {
                msg.append("row: " + row + " weight is not number." + "<BR/>");
            } else if (!NumberUtils.isCreatable(target)) {
                msg.append("row: " + row + " target is not number." + "<BR/>");
            } else if (!NumberUtils.isCreatable(min)) {
                msg.append("row: " + row + " min is not number." + "<BR/>");
            } else {
                paramMap.clear();
                paramMap.put("visId", visId);
                if (this.visionService.countByParams(paramMap) < 1L) {
                    throw new ServiceException("row: " + row + " vision is not found " + visId);
                }
                DefaultResult<VisionVO> visionResult = this.visionService.findForSimpleByVisId(visId);
                if (visionResult.getValue() == null) {
                    throw new ServiceException(visionResult.getSystemMessage().getValue());
                }
                PerspectiveVO perspective = new PerspectiveVO();
                perspective.setPerId(perId);
                perspective.setVisId(visId);
                perspective.setName(name);
                perspective.setWeight(new BigDecimal(weight));
                perspective.setTarget(Float.valueOf(target).floatValue());
                perspective.setMin(Float.valueOf(min).floatValue());
                perspective.setDescription(description);
                paramMap.clear();
                paramMap.put("perId", perId);
                if (this.perspectiveService.countByParams(paramMap) > 0L) {
                    DefaultResult<PerspectiveVO> oldResult = this.perspectiveService.findByUK(perspective);
                    perspective.setOid(oldResult.getValue().getOid());
                    this.perspectiveLogicService.update(perspective, visionResult.getValue().getOid());
                } else {
                    this.perspectiveLogicService.create(perspective, visionResult.getValue().getOid());
                }
                success = true;
            }
            ++i;
        }
        if (msg.length() > 0) {
            result.setSystemMessage(new SystemMessage(msg.toString()));
        } else {
            result.setSystemMessage(new SystemMessage(SysMessageUtil.get("MSG_DOS0003")));
        }
        result.setValue(success);
        return result;
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.INSERT, ServiceMethodType.UPDATE})
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={RuntimeException.class, IOException.class, Exception.class})
    public DefaultResult<Boolean> importObjectivesCsv(String uploadOid) throws ServiceException, Exception {
        List<Map<String, String>> csvResults = UploadSupportUtils.getTransformSegmentData(uploadOid, "TRAN003");
        if (csvResults.size() < 1) {
            throw new ServiceException(SysMessageUtil.get("MSG_DOS0001"));
        }
        boolean success = false;
        DefaultResult<Boolean> result = new DefaultResult<Boolean>();
        StringBuilder msg = new StringBuilder();
        int i = 0;
        while (i < csvResults.size()) {
            int row = i + 1;
            Map<String, String> data = csvResults.get(i);
            String objId = data.get("OBJ_ID");
            String perId = data.get("PER_ID");
            String name = data.get("NAME");
            String weight = data.get("WEIGHT");
            String target = data.get("TARGET");
            String min = data.get("MIN");
            String description = data.get("DESCRIPTION");
            if (super.isBlank(objId)) {
                msg.append("row: " + row + " objective-id is blank." + "<BR/>");
            } else if (super.isBlank(perId)) {
                msg.append("row: " + row + " perspective-id is blank." + "<BR/>");
            } else if (super.isBlank(name)) {
                msg.append("row: " + row + " name is blank." + "<BR/>");
            } else if (super.isBlank(weight)) {
                msg.append("row: " + row + " weight is blank." + "<BR/>");
            } else if (super.isBlank(target)) {
                msg.append("row: " + row + " target is blank." + "<BR/>");
            } else if (super.isBlank(min)) {
                msg.append("row: " + row + " min is blank." + "<BR/>");
            } else if (!NumberUtils.isCreatable(weight)) {
                msg.append("row: " + row + " weight is not number." + "<BR/>");
            } else if (!NumberUtils.isCreatable(target)) {
                msg.append("row: " + row + " target is not number." + "<BR/>");
            } else if (!NumberUtils.isCreatable(min)) {
                msg.append("row: " + row + " min is not number." + "<BR/>");
            } else {
                PerspectiveVO perspective = new PerspectiveVO();
                perspective.setPerId(perId);
                DefaultResult<PerspectiveVO> perResult = this.perspectiveService.findByUK(perspective);
                if (perResult.getValue() == null) {
                    throw new ServiceException("row: " + row + " perspective is not found " + perId);
                }
                perspective = perResult.getValue();
                ObjectiveVO objective = new ObjectiveVO();
                objective.setObjId(objId);
                DefaultResult<ObjectiveVO> oldResult = this.objectiveService.findByUK(objective);
                objective.setObjId(objId);
                objective.setPerId(perId);
                objective.setName(name);
                objective.setWeight(new BigDecimal(weight));
                objective.setTarget(Float.valueOf(target).floatValue());
                objective.setMin(Float.valueOf(min).floatValue());
                objective.setDescription(description);
                if (oldResult.getValue() != null) {
                    objective.setOid(oldResult.getValue().getOid());
                    this.objectiveLogicService.update(objective, perspective.getOid());
                } else {
                    this.objectiveLogicService.create(objective, perspective.getOid());
                }
                success = true;
            }
            ++i;
        }
        if (msg.length() > 0) {
            result.setSystemMessage(new SystemMessage(msg.toString()));
        } else {
            result.setSystemMessage(new SystemMessage(SysMessageUtil.get("MSG_DOS0003")));
        }
        result.setValue(success);
        return result;
    }

    private String checkKPIsDataError(int row, String id, String objId, String name, String weight, String target, String min, String unit, String forId, String management, String compareType, String cal, String dataType, String orgaMeasureSeparate, String userMeasureSeparate, String quasiRange, String description, String max) throws Exception {
        if (super.isBlank(id)) {
            return "row: " + row + " id is blank." + "<BR/>";
        }
        if (super.isBlank(objId)) {
            return "row: " + row + " objective-id is blank." + "<BR/>";
        }
        if (super.isBlank(name)) {
            return "row: " + row + " name is blank." + "<BR/>";
        }
        if (super.isBlank(weight)) {
            return "row: " + row + " weight is blank." + "<BR/>";
        }
        if (super.isBlank(max)) {
            return "row: " + row + " max is blank." + "<BR/>";
        }
        if (super.isBlank(target)) {
            return "row: " + row + " target is blank." + "<BR/>";
        }
        if (super.isBlank(min)) {
            return "row: " + row + " min is blank." + "<BR/>";
        }
        if (super.isBlank(unit)) {
            return "row: " + row + " unit is blank." + "<BR/>";
        }
        if (super.isBlank(forId)) {
            return "row: " + row + " formula-id is blank." + "<BR/>";
        }
        if (super.isBlank(management)) {
            return "row: " + row + " management method is blank." + "<BR/>";
        }
        if (super.isBlank(compareType)) {
            return "row: " + row + " compare type is blank." + "<BR/>";
        }
        if (super.isBlank(cal)) {
            return "row: " + row + " Calculation( aggregation method ) is blank." + "<BR/>";
        }
        if (super.isBlank(dataType)) {
            return "row: " + row + " belong type is blank." + "<BR/>";
        }
        if (super.isBlank(orgaMeasureSeparate)) {
            return "row: " + row + " Organization measure-data separate flag is blank." + "<BR/>";
        }
        if (super.isBlank(userMeasureSeparate)) {
            return "row: " + row + " Personal measure-data separate flag is blank." + "<BR/>";
        }
        if (super.isBlank(quasiRange)) {
            return "row: " + row + " quasi range is blank." + "<BR/>";
        }
        if (!NumberUtils.isCreatable(weight)) {
            return "row: " + row + " weight is not number." + "<BR/>";
        }
        if (!NumberUtils.isCreatable(max)) {
            return "row: " + row + " max is not number." + "<BR/>";
        }
        if (!NumberUtils.isCreatable(target)) {
            return "row: " + row + " target is not number." + "<BR/>";
        }
        if (!NumberUtils.isCreatable(min)) {
            return "row: " + row + " min is not number." + "<BR/>";
        }
        if (!NumberUtils.isCreatable(quasiRange)) {
            return "row: " + row + " quasi range is not number." + "<BR/>";
        }
        if (BscKpiCode.getCompareTypeMap(false).get(compareType) == null) {
            return "row: " + row + " compare type is not accept." + "<BR/>";
        }
        if (BscKpiCode.getDataTypeMap(false).get(dataType) == null) {
            return "row: " + row + " belong type is not accept." + "<BR/>";
        }
        if (BscKpiCode.getManagementMap(false).get(management) == null) {
            return "row: " + row + " management method is not accept." + "<BR/>";
        }
        if (BscKpiCode.getQuasiRangeMap().get(quasiRange) == null) {
            return "row: " + row + " quasi range is not accept." + "<BR/>";
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("aggrId", cal);
        if (this.aggregationMethodService.countByParams(paramMap) < 1L) {
            return "row: " + row + " Calculation( aggregation method ) is not accept." + "<BR/>";
        }
        return "";
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.INSERT, ServiceMethodType.UPDATE})
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={RuntimeException.class, IOException.class, Exception.class})
    public DefaultResult<Boolean> importKPIsCsv(String uploadOid) throws ServiceException, Exception {
        List<Map<String, String>> csvResults = UploadSupportUtils.getTransformSegmentData(uploadOid, "TRAN004");
        if (csvResults.size() < 1) {
            throw new ServiceException(SysMessageUtil.get("MSG_DOS0001"));
        }
        ArrayList<String> organizationOids = new ArrayList<String>();
        ArrayList<String> employeeOids = new ArrayList<String>();
        boolean success = false;
        DefaultResult<Boolean> result = new DefaultResult<Boolean>();
        StringBuilder msg = new StringBuilder();
        ArrayList<String> kpiAttacDocs = new ArrayList<String>();
        int i = 0;
        while (i < csvResults.size()) {
            int row = i + 1;
            Map<String, String> data = csvResults.get(i);
            String id = data.get("ID");
            String objId = data.get("OBJ_ID");
            String name = data.get("NAME");
            String weight = data.get("WEIGHT");
            String target = data.get("TARGET");
            String min = data.get("MIN");
            String unit = data.get("UNIT");
            String forId = data.get("FOR_ID");
            String management = data.get("MANAGEMENT");
            String compareType = data.get("COMPARE_TYPE");
            String cal = data.get("CAL");
            String dataType = data.get("DATA_TYPE");
            String orgaMeasureSeparate = data.get("ORGA_MEASURE_SEPARATE");
            String userMeasureSeparate = data.get("USER_MEASURE_SEPARATE");
            String quasiRange = data.get("QUASI_RANGE");
            String description = data.get("DESCRIPTION");
            String max = data.get("MAX");
            String trendsForId = data.get("TRENDS_FOR_ID");
            String activate = data.get("ACTIVATE");
            String errMsg = this.checkKPIsDataError(row, id, objId, name, weight, target, min, unit, forId, management, compareType, cal, dataType, orgaMeasureSeparate, userMeasureSeparate, quasiRange, description, max);
            if (!"".equals(errMsg)) {
                msg.append(errMsg);
            } else {
                DefaultResult<KpiVO> kResult;
                ObjectiveVO objective = new ObjectiveVO();
                objective.setObjId(objId);
                DefaultResult<ObjectiveVO> objResult = this.objectiveService.findByUK(objective);
                if (objResult.getValue() == null) {
                    throw new ServiceException("row: " + row + " strategy-objectives is not found " + objId);
                }
                objective = objResult.getValue();
                KpiVO kpi = new KpiVO();
                kpi.setId(id);
                kpi.setName(name);
                kpi.setWeight(new BigDecimal(weight));
                kpi.setMax(Float.valueOf(max).floatValue());
                kpi.setTarget(Float.valueOf(target).floatValue());
                kpi.setMin(Float.valueOf(min).floatValue());
                kpi.setCompareType(compareType);
                kpi.setUnit(unit);
                kpi.setManagement(management);
                kpi.setQuasiRange(Integer.parseInt(quasiRange));
                kpi.setDataType(dataType);
                kpi.setDescription(description);
                kpi.setOrgaMeasureSeparate("N");
                kpi.setUserMeasureSeparate("N");
                kpi.setActivate("N");
                if ("Y".equals(orgaMeasureSeparate) || "Y".equals(userMeasureSeparate)) {
                    msg.append("row: " + row + " import mode no support organization/personal measure separate data. please manual settings." + "<BR/>");
                }
                if ("Y".equals(activate)) {
                    kpi.setActivate("Y");
                }
                if ((kResult = this.kpiService.findByUK(kpi)).getValue() != null) {
                    kpi.setOid(kResult.getValue().getOid());
                    this.kpiLogicService.update(kpi, objective.getOid(), BscFormulaUtils.getFormulaById(forId).getOid(), AggregationMethodUtils.findSimpleById(cal).getOid(), organizationOids, employeeOids, BscFormulaUtils.getFormulaById(trendsForId).getOid(), kpiAttacDocs);
                } else {
                    this.kpiLogicService.create(kpi, objective.getOid(), BscFormulaUtils.getFormulaById(forId).getOid(), AggregationMethodUtils.findSimpleById(cal).getOid(), organizationOids, employeeOids, BscFormulaUtils.getFormulaById(trendsForId).getOid(), kpiAttacDocs);
                }
                success = true;
            }
            ++i;
        }
        if (msg.length() > 0) {
            result.setSystemMessage(new SystemMessage(msg.toString()));
        } else {
            result.setSystemMessage(new SystemMessage(SysMessageUtil.get("MSG_DOS0003")));
        }
        result.setValue(success);
        return result;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.INSERT, ServiceMethodType.UPDATE})
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={RuntimeException.class, IOException.class, Exception.class})
    public DefaultResult<Boolean> importMeasureData(String uploadOid) throws ServiceException, Exception {
        csvResults = UploadSupportUtils.getTransformSegmentData(uploadOid, "TRAN005");
        if (csvResults.size() < 1) {
            throw new ServiceException(SysMessageUtil.get("MSG_DOS0001"));
        }
        success = false;
        result = new DefaultResult<Boolean>();
        msg = new StringBuilder();
        paramMap = new HashMap<String, Object>();
        i = 0;
        while (i < csvResults.size()) {
            block9: {
                block21: {
                    block20: {
                        block19: {
                            block18: {
                                block17: {
                                    block16: {
                                        block15: {
                                            block14: {
                                                block13: {
                                                    block12: {
                                                        block11: {
                                                            block10: {
                                                                block8: {
                                                                    row = i + 1;
                                                                    data = csvResults.get(i);
                                                                    kpiId = data.get("KPI_ID");
                                                                    date = data.get("DATE");
                                                                    target = data.get("TARGET");
                                                                    actual = data.get("ACTUAL");
                                                                    frequency = data.get("FREQUENCY");
                                                                    orgId = data.get("ORG_ID");
                                                                    empId = data.get("EMP_ID");
                                                                    if (!super.isBlank(kpiId)) break block8;
                                                                    msg.append("row: " + row + " kpi id is blank." + "<BR/>");
                                                                    break block9;
                                                                }
                                                                if (!super.isBlank(date)) break block10;
                                                                msg.append("row: " + row + " date is blank." + "<BR/>");
                                                                break block9;
                                                            }
                                                            if (!super.isBlank(target)) break block11;
                                                            msg.append("row: " + row + " target is blank." + "<BR/>");
                                                            break block9;
                                                        }
                                                        if (!super.isBlank(actual)) break block12;
                                                        msg.append("row: " + row + " actual is blank." + "<BR/>");
                                                        break block9;
                                                    }
                                                    if (!super.isBlank(frequency)) break block13;
                                                    msg.append("row: " + row + " frequency is blank." + "<BR/>");
                                                    break block9;
                                                }
                                                if (!super.isBlank(orgId)) break block14;
                                                msg.append("row: " + row + " organization-id is blank." + "<BR/>");
                                                break block9;
                                            }
                                            if (!super.isBlank(empId)) break block15;
                                            msg.append("row: " + row + " employee-no is blank." + "<BR/>");
                                            break block9;
                                        }
                                        if (SimpleUtils.isDate(date)) break block16;
                                        msg.append("row: " + row + " is not date " + date + "<BR/>");
                                        break block9;
                                    }
                                    if (NumberUtils.isCreatable(target)) break block17;
                                    msg.append("row: " + row + " target is not number." + "<BR/>");
                                    break block9;
                                }
                                if (NumberUtils.isCreatable(actual)) break block18;
                                msg.append("row: " + row + " actual is not number." + "<BR/>");
                                break block9;
                            }
                            if (BscMeasureDataFrequency.getFrequencyMap(false).get(frequency) != null) break block19;
                            msg.append("row: " + row + " frequency is not found." + "<BR/>");
                            break block9;
                        }
                        paramMap.clear();
                        paramMap.put("id", kpiId);
                        if (this.kpiService.countByParams(paramMap) >= 1L) break block20;
                        msg.append("row: " + row + " KPI is not found " + kpiId + "<BR/>");
                        break block9;
                    }
                    if ("*".equals(orgId)) break block21;
                    paramMap.clear();
                    paramMap.put("orgId", orgId);
                    if (this.organizationService.countByParams(paramMap) >= 1L) break block21;
                    msg.append("row: " + row + " organization-id is not found " + orgId + "<BR/>");
                    break block9;
                }
                if ("*".equals(empId)) ** GOTO lbl-1000
                paramMap.clear();
                paramMap.put("empId", empId);
                if (this.employeeService.countByParams(paramMap) < 1L) {
                    msg.append("row: " + row + " employee-no is not found " + empId + "<BR/>");
                } else lbl-1000:
                // 2 sources

                {
                    measureData = new MeasureDataVO();
                    measureData.setKpiId(kpiId);
                    measureData.setDate(date);
                    measureData.setTarget(Float.valueOf(target).floatValue());
                    measureData.setActual(Float.valueOf(actual).floatValue());
                    measureData.setFrequency(frequency);
                    measureData.setOrgId(orgId);
                    measureData.setEmpId(empId);
                    oldResult = this.measureDataService.findByUK(measureData);
                    if (oldResult.getValue() != null) {
                        measureData.setOid(oldResult.getValue().getOid());
                        this.measureDataService.updateObject(measureData);
                    } else {
                        this.measureDataService.saveObject(measureData);
                    }
                    success = true;
                }
            }
            ++i;
        }
        if (msg.length() > 0) {
            result.setSystemMessage(new SystemMessage(msg.toString()));
        } else {
            result.setSystemMessage(new SystemMessage(SysMessageUtil.get("MSG_DOS0003")));
        }
        result.setValue(success);
        return result;
    }
}

