/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.bsc.service.logic.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netsteadfast.greenstep.base.Constants;
import com.netsteadfast.greenstep.base.SysMessageUtil;
import com.netsteadfast.greenstep.base.exception.ServiceException;
import com.netsteadfast.greenstep.base.model.DefaultResult;
import com.netsteadfast.greenstep.base.model.ServiceAuthority;
import com.netsteadfast.greenstep.base.model.ServiceMethodAuthority;
import com.netsteadfast.greenstep.base.model.ServiceMethodType;
import com.netsteadfast.greenstep.base.model.SystemMessage;
import com.netsteadfast.greenstep.base.service.logic.BscBaseLogicService;
import com.netsteadfast.greenstep.bsc.service.IDegreeFeedbackAssignService;
import com.netsteadfast.greenstep.bsc.service.IEmployeeHierService;
import com.netsteadfast.greenstep.bsc.service.IEmployeeOrgaService;
import com.netsteadfast.greenstep.bsc.service.IKpiEmplService;
import com.netsteadfast.greenstep.bsc.service.IMeasureDataService;
import com.netsteadfast.greenstep.bsc.service.IMonitorItemScoreService;
import com.netsteadfast.greenstep.bsc.service.IPdcaItemOwnerService;
import com.netsteadfast.greenstep.bsc.service.IPdcaMeasureFreqService;
import com.netsteadfast.greenstep.bsc.service.IPdcaOwnerService;
import com.netsteadfast.greenstep.bsc.service.IReportRoleViewService;
import com.netsteadfast.greenstep.bsc.service.ITsaMeasureFreqService;
import com.netsteadfast.greenstep.bsc.service.logic.IEmployeeLogicService;
import com.netsteadfast.greenstep.po.hbm.BbDegreeFeedbackAssign;
import com.netsteadfast.greenstep.po.hbm.BbEmployeeHier;
import com.netsteadfast.greenstep.po.hbm.BbEmployeeOrga;
import com.netsteadfast.greenstep.po.hbm.BbKpiEmpl;
import com.netsteadfast.greenstep.po.hbm.BbMeasureData;
import com.netsteadfast.greenstep.po.hbm.BbMonitorItemScore;
import com.netsteadfast.greenstep.po.hbm.BbPdcaItemOwner;
import com.netsteadfast.greenstep.po.hbm.BbPdcaMeasureFreq;
import com.netsteadfast.greenstep.po.hbm.BbPdcaOwner;
import com.netsteadfast.greenstep.po.hbm.BbReportRoleView;
import com.netsteadfast.greenstep.po.hbm.BbTsaMeasureFreq;
import com.netsteadfast.greenstep.po.hbm.TbSysCalendarNote;
import com.netsteadfast.greenstep.po.hbm.TbSysMsgNotice;
import com.netsteadfast.greenstep.po.hbm.TbUserRole;
import com.netsteadfast.greenstep.service.ISysCalendarNoteService;
import com.netsteadfast.greenstep.service.ISysMsgNoticeService;
import com.netsteadfast.greenstep.service.logic.IRoleLogicService;
import com.netsteadfast.greenstep.util.IconUtils;
import com.netsteadfast.greenstep.util.SimpleUtils;
import com.netsteadfast.greenstep.util.UploadSupportUtils;
import com.netsteadfast.greenstep.vo.AccountVO;
import com.netsteadfast.greenstep.vo.DegreeFeedbackAssignVO;
import com.netsteadfast.greenstep.vo.EmployeeHierVO;
import com.netsteadfast.greenstep.vo.EmployeeOrgaVO;
import com.netsteadfast.greenstep.vo.EmployeeVO;
import com.netsteadfast.greenstep.vo.KpiEmplVO;
import com.netsteadfast.greenstep.vo.MeasureDataVO;
import com.netsteadfast.greenstep.vo.MonitorItemScoreVO;
import com.netsteadfast.greenstep.vo.OrganizationVO;
import com.netsteadfast.greenstep.vo.PdcaItemOwnerVO;
import com.netsteadfast.greenstep.vo.PdcaMeasureFreqVO;
import com.netsteadfast.greenstep.vo.PdcaOwnerVO;
import com.netsteadfast.greenstep.vo.ReportRoleViewVO;
import com.netsteadfast.greenstep.vo.SysCalendarNoteVO;
import com.netsteadfast.greenstep.vo.SysMsgNoticeVO;
import com.netsteadfast.greenstep.vo.TsaMeasureFreqVO;
import com.netsteadfast.greenstep.vo.UserRoleVO;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@ServiceAuthority(check=true)
@Service(value="bsc.service.logic.EmployeeLogicService")
@Transactional(propagation=Propagation.REQUIRED, readOnly=true)
public class EmployeeLogicServiceImpl
extends BscBaseLogicService
implements IEmployeeLogicService {
    protected Logger logger = Logger.getLogger(EmployeeLogicServiceImpl.class);
    private static final String TREE_ICON_ID = "PERSON";
    private IEmployeeOrgaService<EmployeeOrgaVO, BbEmployeeOrga, String> employeeOrgaService;
    private ISysMsgNoticeService<SysMsgNoticeVO, TbSysMsgNotice, String> sysMsgNoticeService;
    private ISysCalendarNoteService<SysCalendarNoteVO, TbSysCalendarNote, String> sysCalendarNoteService;
    private IReportRoleViewService<ReportRoleViewVO, BbReportRoleView, String> reportRoleViewService;
    private IKpiEmplService<KpiEmplVO, BbKpiEmpl, String> kpiEmplService;
    private IDegreeFeedbackAssignService<DegreeFeedbackAssignVO, BbDegreeFeedbackAssign, String> degreeFeedbackAssignService;
    private IMeasureDataService<MeasureDataVO, BbMeasureData, String> measureDataService;
    private IPdcaOwnerService<PdcaOwnerVO, BbPdcaOwner, String> pdcaOwnerService;
    private IPdcaItemOwnerService<PdcaItemOwnerVO, BbPdcaItemOwner, String> pdcaItemOwnerService;
    private IRoleLogicService roleLogicService;
    private IMonitorItemScoreService<MonitorItemScoreVO, BbMonitorItemScore, String> monitorItemScoreService;
    private IEmployeeHierService<EmployeeHierVO, BbEmployeeHier, String> employeeHierService;
    private IPdcaMeasureFreqService<PdcaMeasureFreqVO, BbPdcaMeasureFreq, String> pdcaMeasureFreqService;
    private ITsaMeasureFreqService<TsaMeasureFreqVO, BbTsaMeasureFreq, String> tsaMeasureFreqService;

    public IEmployeeOrgaService<EmployeeOrgaVO, BbEmployeeOrga, String> getEmployeeOrgaService() {
        return this.employeeOrgaService;
    }

    @Autowired
    @Resource(name="bsc.service.EmployeeOrgaService")
    @Required
    public void setEmployeeOrgaService(IEmployeeOrgaService<EmployeeOrgaVO, BbEmployeeOrga, String> employeeOrgaService) {
        this.employeeOrgaService = employeeOrgaService;
    }

    public ISysMsgNoticeService<SysMsgNoticeVO, TbSysMsgNotice, String> getSysMsgNoticeService() {
        return this.sysMsgNoticeService;
    }

    @Autowired
    @Resource(name="core.service.SysMsgNoticeService")
    @Required
    public void setSysMsgNoticeService(ISysMsgNoticeService<SysMsgNoticeVO, TbSysMsgNotice, String> sysMsgNoticeService) {
        this.sysMsgNoticeService = sysMsgNoticeService;
    }

    public ISysCalendarNoteService<SysCalendarNoteVO, TbSysCalendarNote, String> getSysCalendarNoteService() {
        return this.sysCalendarNoteService;
    }

    @Autowired
    @Resource(name="core.service.SysCalendarNoteService")
    @Required
    public void setSysCalendarNoteService(ISysCalendarNoteService<SysCalendarNoteVO, TbSysCalendarNote, String> sysCalendarNoteService) {
        this.sysCalendarNoteService = sysCalendarNoteService;
    }

    public IReportRoleViewService<ReportRoleViewVO, BbReportRoleView, String> getReportRoleViewService() {
        return this.reportRoleViewService;
    }

    @Autowired
    @Resource(name="bsc.service.ReportRoleViewService")
    @Required
    public void setReportRoleViewService(IReportRoleViewService<ReportRoleViewVO, BbReportRoleView, String> reportRoleViewService) {
        this.reportRoleViewService = reportRoleViewService;
    }

    public IKpiEmplService<KpiEmplVO, BbKpiEmpl, String> getKpiEmplService() {
        return this.kpiEmplService;
    }

    @Autowired
    @Resource(name="bsc.service.KpiEmplService")
    @Required
    public void setKpiEmplService(IKpiEmplService<KpiEmplVO, BbKpiEmpl, String> kpiEmplService) {
        this.kpiEmplService = kpiEmplService;
    }

    public IDegreeFeedbackAssignService<DegreeFeedbackAssignVO, BbDegreeFeedbackAssign, String> getDegreeFeedbackAssignService() {
        return this.degreeFeedbackAssignService;
    }

    @Autowired
    @Resource(name="bsc.service.DegreeFeedbackAssignService")
    @Required
    public void setDegreeFeedbackAssignService(IDegreeFeedbackAssignService<DegreeFeedbackAssignVO, BbDegreeFeedbackAssign, String> degreeFeedbackAssignService) {
        this.degreeFeedbackAssignService = degreeFeedbackAssignService;
    }

    public IMeasureDataService<MeasureDataVO, BbMeasureData, String> getMeasureDataService() {
        return this.measureDataService;
    }

    @Autowired
    @Resource(name="bsc.service.MeasureDataService")
    @Required
    public void setMeasureDataService(IMeasureDataService<MeasureDataVO, BbMeasureData, String> measureDataService) {
        this.measureDataService = measureDataService;
    }

    public IPdcaOwnerService<PdcaOwnerVO, BbPdcaOwner, String> getPdcaOwnerService() {
        return this.pdcaOwnerService;
    }

    @Autowired
    @Resource(name="bsc.service.PdcaOwnerService")
    @Required
    public void setPdcaOwnerService(IPdcaOwnerService<PdcaOwnerVO, BbPdcaOwner, String> pdcaOwnerService) {
        this.pdcaOwnerService = pdcaOwnerService;
    }

    public IPdcaItemOwnerService<PdcaItemOwnerVO, BbPdcaItemOwner, String> getPdcaItemOwnerService() {
        return this.pdcaItemOwnerService;
    }

    @Autowired
    @Resource(name="bsc.service.PdcaItemOwnerService")
    @Required
    public void setPdcaItemOwnerService(IPdcaItemOwnerService<PdcaItemOwnerVO, BbPdcaItemOwner, String> pdcaItemOwnerService) {
        this.pdcaItemOwnerService = pdcaItemOwnerService;
    }

    public IRoleLogicService getRoleLogicService() {
        return this.roleLogicService;
    }

    @Autowired
    @Resource(name="core.service.logic.RoleLogicService")
    @Required
    public void setRoleLogicService(IRoleLogicService roleLogicService) {
        this.roleLogicService = roleLogicService;
    }

    public IMonitorItemScoreService<MonitorItemScoreVO, BbMonitorItemScore, String> getMonitorItemScoreService() {
        return this.monitorItemScoreService;
    }

    @Autowired
    @Resource(name="bsc.service.MonitorItemScoreService")
    @Required
    public void setMonitorItemScoreService(IMonitorItemScoreService<MonitorItemScoreVO, BbMonitorItemScore, String> monitorItemScoreService) {
        this.monitorItemScoreService = monitorItemScoreService;
    }

    public IEmployeeHierService<EmployeeHierVO, BbEmployeeHier, String> getEmployeeHierService() {
        return this.employeeHierService;
    }

    @Autowired
    @Resource(name="bsc.service.EmployeeHierService")
    @Required
    public void setEmployeeHierService(IEmployeeHierService<EmployeeHierVO, BbEmployeeHier, String> employeeHierService) {
        this.employeeHierService = employeeHierService;
    }

    public IPdcaMeasureFreqService<PdcaMeasureFreqVO, BbPdcaMeasureFreq, String> getPdcaMeasureFreqService() {
        return this.pdcaMeasureFreqService;
    }

    @Autowired
    @Resource(name="bsc.service.PdcaMeasureFreqService")
    @Required
    public void setPdcaMeasureFreqService(IPdcaMeasureFreqService<PdcaMeasureFreqVO, BbPdcaMeasureFreq, String> pdcaMeasureFreqService) {
        this.pdcaMeasureFreqService = pdcaMeasureFreqService;
    }

    public ITsaMeasureFreqService<TsaMeasureFreqVO, BbTsaMeasureFreq, String> getTsaMeasureFreqService() {
        return this.tsaMeasureFreqService;
    }

    @Autowired
    @Resource(name="bsc.service.TsaMeasureFreqService")
    @Required
    public void setTsaMeasureFreqService(ITsaMeasureFreqService<TsaMeasureFreqVO, BbTsaMeasureFreq, String> tsaMeasureFreqService) {
        this.tsaMeasureFreqService = tsaMeasureFreqService;
    }

    private boolean isAdministrator(String account) {
        return account.equals("admin") || account.equals("system");
    }

    private AccountVO tranAccount(EmployeeVO employee) throws Exception {
        AccountVO account = new AccountVO();
        account.setAccount(employee.getAccount());
        account.setOnJob("Y");
        account.setPassword(this.getAccountService().tranPassword(employee.getPassword()));
        return account;
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.INSERT})
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={RuntimeException.class, IOException.class, Exception.class})
    public DefaultResult<EmployeeVO> create(EmployeeVO employee, List<String> organizationOid) throws ServiceException, Exception {
        if (employee == null || super.isBlank(employee.getEmpId())) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0001"));
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("empId", employee.getEmpId());
        if (this.getEmployeeService().countByParams(params) > 0L) {
            throw new ServiceException("Please change another Id!");
        }
        AccountVO account = this.tranAccount(employee);
        if (this.isAdministrator(account.getAccount())) {
            throw new ServiceException("Please change another Account!");
        }
        DefaultResult<AccountVO> mResult = this.getAccountService().saveObject(account);
        if (mResult.getValue() == null) {
            throw new ServiceException(mResult.getSystemMessage().getValue());
        }
        DefaultResult<EmployeeVO> result = this.getEmployeeService().saveObject(employee);
        employee = result.getValue();
        this.createEmployeeOrganization(employee, organizationOid);
        UserRoleVO userRole = new UserRoleVO();
        userRole.setAccount(employee.getAccount());
        userRole.setRole(this.roleLogicService.getDefaultUserRole());
        userRole.setDescription(String.valueOf(employee.getAccount()) + " `s role!");
        this.getUserRoleService().saveObject(userRole);
        this.createHierarchy(employee, "0000000000");
        return result;
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.UPDATE})
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={RuntimeException.class, IOException.class, Exception.class})
    public DefaultResult<EmployeeVO> update(EmployeeVO employee, List<String> organizationOid) throws ServiceException, Exception {
        if (employee == null || super.isBlank(employee.getOid())) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0001"));
        }
        EmployeeVO dbEmployee = this.findEmployeeData(employee.getOid());
        this.deleteEmployeeOrganization(dbEmployee);
        employee.setAccount(dbEmployee.getAccount());
        employee.setEmpId(dbEmployee.getEmpId());
        DefaultResult<EmployeeVO> result = this.getEmployeeService().updateObject(employee);
        if (result.getValue() == null) {
            throw new ServiceException(result.getSystemMessage().getValue());
        }
        this.createEmployeeOrganization(result.getValue(), organizationOid);
        return result;
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.UPDATE})
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={RuntimeException.class, IOException.class, Exception.class})
    public DefaultResult<AccountVO> updatePassword(EmployeeVO employee, String newPassword) throws ServiceException, Exception {
        if (employee == null || super.isBlank(employee.getOid()) || super.isBlank(employee.getPassword()) || super.isBlank(newPassword)) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0001"));
        }
        EmployeeVO dbEmployee = this.findEmployeeData(employee.getOid());
        AccountVO account = this.findAccountData(dbEmployee.getAccount());
        if (!account.getPassword().equals(this.getAccountService().tranPassword(employee.getPassword()))) {
            throw new ServiceException("The current password(old password) is incorrect!");
        }
        account.setPassword(this.getAccountService().tranPassword(newPassword));
        return this.getAccountService().updateObject(account);
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.DELETE})
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={RuntimeException.class, IOException.class, Exception.class})
    public DefaultResult<Boolean> delete(EmployeeVO employee) throws ServiceException, Exception {
        if (employee == null || super.isBlank(employee.getOid())) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0001"));
        }
        AccountVO account = this.findAccountData((employee = this.findEmployeeData(employee.getOid())).getAccount());
        if (this.isAdministrator(account.getAccount())) {
            throw new ServiceException("Administrator cannot delete!");
        }
        this.checkInformationRelated(account, employee);
        this.deleteEmployeeOrganization(employee);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("account", account.getAccount());
        List userRoles = this.getUserRoleService().findListByParams(params);
        int i = 0;
        while (userRoles != null && i < userRoles.size()) {
            TbUserRole uRole = (TbUserRole)userRoles.get(i);
            this.getUserRoleService().delete(uRole);
            ++i;
        }
        params.clear();
        params.put("idName", account.getAccount());
        List reportRoleViews = this.reportRoleViewService.findListByParams(params);
        int i2 = 0;
        while (reportRoleViews != null && i2 < reportRoleViews.size()) {
            BbReportRoleView reportRoleView = (BbReportRoleView)reportRoleViews.get(i2);
            this.reportRoleViewService.delete(reportRoleView);
            ++i2;
        }
        this.measureDataService.deleteForEmpId(employee.getEmpId());
        this.monitorItemScoreService.deleteForEmpId(employee.getEmpId());
        this.deleteHierarchy(employee);
        this.getAccountService().deleteByPKng(account.getOid());
        return this.getEmployeeService().deleteObject(employee);
    }

    private void checkInformationRelated(AccountVO account, EmployeeVO employee) throws ServiceException, Exception {
        if (account == null || super.isBlank(account.getAccount()) || employee == null || super.isBlank(employee.getEmpId())) {
            return;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("toAccount", account.getAccount());
        if (this.sysMsgNoticeService.countByParams(params) > 0L) {
            throw new ServiceException(SysMessageUtil.get("MSG_DOS0010"));
        }
        params.clear();
        params.put("account", account.getAccount());
        if (this.sysCalendarNoteService.countByParams(params) > 0L) {
            throw new ServiceException(SysMessageUtil.get("MSG_DOS0010"));
        }
        params.clear();
        params.put("empId", employee.getEmpId());
        if (this.kpiEmplService.countByParams(params) > 0L) {
            throw new ServiceException(SysMessageUtil.get("MSG_DOS0010"));
        }
        if (this.pdcaOwnerService.countByParams(params) > 0L) {
            throw new ServiceException(SysMessageUtil.get("MSG_DOS0010"));
        }
        if (this.pdcaItemOwnerService.countByParams(params) > 0L) {
            throw new ServiceException(SysMessageUtil.get("MSG_DOS0010"));
        }
        params.clear();
        params.put("empId", employee.getEmpId());
        if (this.pdcaMeasureFreqService.countByParams(params) > 0L) {
            throw new ServiceException(SysMessageUtil.get("MSG_DOS0010"));
        }
        if (this.tsaMeasureFreqService.countByParams(params) > 0L) {
            throw new ServiceException(SysMessageUtil.get("MSG_DOS0010"));
        }
        params.clear();
        params.put("ownerId", employee.getEmpId());
        if (this.degreeFeedbackAssignService.countByParams(params) > 0L) {
            throw new ServiceException(SysMessageUtil.get("MSG_DOS0010"));
        }
        params.clear();
        params.put("raterId", employee.getEmpId());
        if (this.degreeFeedbackAssignService.countByParams(params) > 0L) {
            throw new ServiceException(SysMessageUtil.get("MSG_DOS0010"));
        }
        if (this.foundChild(employee)) {
            throw new ServiceException(SysMessageUtil.get("MSG_DOS0010"));
        }
    }

    private void createEmployeeOrganization(EmployeeVO employee, List<String> organizationOid) throws ServiceException, Exception {
        if (employee == null || StringUtils.isBlank(employee.getEmpId()) || organizationOid == null || organizationOid.size() < 1) {
            return;
        }
        for (String oid : organizationOid) {
            OrganizationVO organization = this.findOrganizationData(oid);
            EmployeeOrgaVO empOrg = new EmployeeOrgaVO();
            empOrg.setEmpId(employee.getEmpId());
            empOrg.setOrgId(organization.getOrgId());
            this.employeeOrgaService.saveObject(empOrg);
        }
    }

    private void deleteEmployeeOrganization(EmployeeVO employee) throws ServiceException, Exception {
        if (employee == null || StringUtils.isBlank(employee.getEmpId())) {
            return;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("empId", employee.getEmpId());
        List searchList = this.employeeOrgaService.findListByParams(params);
        if (searchList == null || searchList.size() < 1) {
            return;
        }
        for (BbEmployeeOrga empOrg : searchList) {
            this.employeeOrgaService.delete(empOrg);
        }
    }

    private void createHierarchy(EmployeeVO employee, String supOid) throws ServiceException, Exception {
        if (employee == null || super.isBlank(employee.getOid()) || super.isBlank(supOid)) {
            return;
        }
        EmployeeHierVO hier = new EmployeeHierVO();
        hier.setEmpOid(employee.getOid());
        hier.setSupOid(supOid);
        this.employeeHierService.saveObject(hier);
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.SELECT})
    public List<Map<String, Object>> getTreeData(String basePath) throws ServiceException, Exception {
        LinkedList<Map<String, Object>> items = new LinkedList<Map<String, Object>>();
        List<EmployeeVO> empList = this.getEmployeeService().findForJoinHier();
        if (empList == null || empList.size() < 1) {
            return items;
        }
        for (EmployeeVO emp : empList) {
            if (!super.isBlank(emp.getSupOid()) && !"0000000000".equals(emp.getSupOid())) continue;
            LinkedHashMap<String, String> parentDataMap = new LinkedHashMap<String, String>();
            parentDataMap.put("type", "parent");
            parentDataMap.put("id", emp.getOid());
            parentDataMap.put("name", String.valueOf(IconUtils.getMenuIcon(basePath, TREE_ICON_ID)) + StringEscapeUtils.escapeHtml4(this.getTreeShowName(emp)));
            parentDataMap.put("oid", emp.getOid());
            items.add(parentDataMap);
        }
        int ix = 0;
        while (ix < items.size()) {
            Map parentDataMap = (Map)items.get(ix);
            String oid = (String)parentDataMap.get("oid");
            this.getTreeData(basePath, parentDataMap, empList, oid);
            ++ix;
        }
        return items;
    }

    private void getTreeData(String basePath, Map<String, Object> putObject, List<EmployeeVO> searchList, String supOid) throws Exception {
        LinkedList<String> childList = new LinkedList<String>();
        this.getChildEmpLevelOne(searchList, supOid, childList);
        if (childList.size() < 1) {
            return;
        }
        for (String childEmpOid : childList) {
            EmployeeVO emp = this.getEmployeeFromSearchList(searchList, childEmpOid, false);
            EmployeeVO childEmp = this.getEmployeeFromSearchList(searchList, childEmpOid, true);
            if (emp == null) continue;
            LinkedHashMap<String, Object> thePutObject = null;
            LinkedList childrenList = (LinkedList)putObject.get("children");
            if (childrenList == null) {
                childrenList = new LinkedList();
            }
            LinkedHashMap<String, String> nodeMap = new LinkedHashMap<String, String>();
            nodeMap.put("id", emp.getOid());
            nodeMap.put("name", String.valueOf(IconUtils.getMenuIcon(basePath, TREE_ICON_ID)) + StringEscapeUtils.escapeHtml4(this.getTreeShowName(emp)));
            nodeMap.put("oid", emp.getOid());
            childrenList.add(nodeMap);
            putObject.put("children", childrenList);
            if (childEmp != null) {
                thePutObject = nodeMap;
            } else {
                nodeMap.put("type", "Leaf");
                thePutObject = putObject;
            }
            if (childEmp == null) continue;
            this.getTreeData(basePath, thePutObject, searchList, childEmpOid);
        }
    }

    private List<String> getChildEmpLevelOne(List<EmployeeVO> searchList, String supOid, List<String> childList) throws Exception {
        if (childList == null) {
            childList = new LinkedList<String>();
        }
        for (EmployeeVO emp : searchList) {
            if (!supOid.equals(emp.getSupOid())) continue;
            childList.add(emp.getOid());
        }
        return childList;
    }

    private EmployeeVO getEmployeeFromSearchList(List<EmployeeVO> searchList, String empOid, boolean isChild) throws Exception {
        for (EmployeeVO emp : searchList) {
            if (!(!isChild ? emp.getOid().equals(empOid) : emp.getSupOid().equals(empOid))) continue;
            return emp;
        }
        return null;
    }

    private String getTreeShowName(EmployeeVO employee) throws Exception {
        if (!super.isBlank(employee.getJobTitle())) {
            return String.valueOf(employee.getEmpId()) + " - " + StringEscapeUtils.escapeHtml4(employee.getFullName()) + " ( " + employee.getJobTitle().trim() + " )";
        }
        return String.valueOf(employee.getEmpId()) + " - " + StringEscapeUtils.escapeHtml4(employee.getFullName());
    }

    private boolean foundChild(EmployeeVO employee) throws ServiceException, Exception {
        if (employee == null || super.isBlank(employee.getOid())) {
            return false;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("supOid", employee.getOid());
        return this.employeeHierService.countByParams(params) > 0L;
    }

    private boolean foundChild(String supOid, String checkEmpOid) throws ServiceException, Exception {
        List<EmployeeVO> treeList = this.getEmployeeService().findForJoinHier();
        if (treeList == null || treeList.size() < 1) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0001"));
        }
        boolean f = false;
        LinkedList<EmployeeVO> childList = new LinkedList<EmployeeVO>();
        this.getChild(checkEmpOid, treeList, childList);
        int ix = 0;
        while (childList != null && ix < childList.size()) {
            if (((EmployeeVO)childList.get(ix)).getOid().equals(checkEmpOid)) {
                f = true;
            }
            ++ix;
        }
        return f;
    }

    private void getChild(String supOid, List<EmployeeVO> tree, List<EmployeeVO> put) throws Exception {
        if (put == null || tree == null) {
            return;
        }
        if (StringUtils.isBlank(supOid) || "0000000000".equals(supOid)) {
            return;
        }
        for (EmployeeVO emp : tree) {
            if (!emp.getSupOid().equals(supOid)) continue;
            put.add(emp);
            this.getChild(emp.getOid(), tree, put);
        }
    }

    private void deleteHierarchy(EmployeeVO employee) throws ServiceException, Exception {
        if (employee == null || super.isBlank(employee.getOid())) {
            return;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("empOid", employee.getOid());
        List hierList = this.employeeHierService.findListByParams(params);
        if (hierList == null) {
            return;
        }
        for (BbEmployeeHier hier : hierList) {
            this.employeeHierService.delete(hier);
        }
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.UPDATE})
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={RuntimeException.class, IOException.class, Exception.class})
    public DefaultResult<Boolean> updateSupervisor(EmployeeVO employee, String supervisorOid) throws ServiceException, Exception {
        if (employee == null || super.isBlank(employee.getOid()) || super.isBlank(supervisorOid)) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0001"));
        }
        DefaultResult<Boolean> result = new DefaultResult<Boolean>();
        result.setValue(Boolean.FALSE);
        result.setSystemMessage(new SystemMessage(SysMessageUtil.get("MSG_DOS0004")));
        employee = this.findEmployeeData(employee.getOid());
        this.deleteHierarchy(employee);
        if ("root".equals(supervisorOid) || "r".equals(supervisorOid)) {
            this.createHierarchy(employee, "0000000000");
        } else {
            EmployeeVO newHierEmployee = this.findEmployeeData(supervisorOid);
            if (this.foundChild(employee.getOid(), newHierEmployee.getOid())) {
                throw new ServiceException(SysMessageUtil.get("MSG_STD0005"));
            }
            this.createHierarchy(employee, newHierEmployee.getOid());
        }
        result.setValue(Boolean.TRUE);
        result.setSystemMessage(new SystemMessage(SysMessageUtil.get("MSG_DOS0003")));
        return result;
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.INSERT})
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={RuntimeException.class, IOException.class, Exception.class})
    public void initHierarchyForFirst() throws ServiceException, Exception {
        List employeeList = this.getEmployeeService().findListVOByParams(null);
        if (employeeList == null || employeeList.size() < 1) {
            return;
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        for (EmployeeVO employee : employeeList) {
            paramMap.clear();
            paramMap.put("empOid", employee.getOid());
            if (this.employeeHierService.countByParams(paramMap) > 0L) continue;
            this.createHierarchy(employee, "0000000000");
        }
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.SELECT})
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={RuntimeException.class, IOException.class, Exception.class})
    public DefaultResult<String> createOrgChartData(String basePath, EmployeeVO currentEmployee) throws ServiceException, Exception {
        List<Map<String, Object>> treeMap;
        if (currentEmployee != null && !super.isBlank(currentEmployee.getOid())) {
            currentEmployee = this.findEmployeeData(currentEmployee.getOid());
        }
        if ((treeMap = this.getTreeData(basePath)) == null || treeMap.size() < 1) {
            throw new ServiceException(SysMessageUtil.get("MSG_DOS0009"));
        }
        this.resetTreeMapContentForOrgChartData(treeMap, currentEmployee);
        HashMap<String, Object> rootMap = new HashMap<String, Object>();
        rootMap.put("name", "Employee hierarchy");
        rootMap.put("title", "hierarchy structure");
        rootMap.put("children", treeMap);
        ObjectMapper objectMapper = new ObjectMapper();
        String jsonData = objectMapper.writeValueAsString(rootMap);
        String uploadOid = UploadSupportUtils.create(Constants.getSystem(), "tmp", false, jsonData.getBytes(), String.valueOf(SimpleUtils.getUUIDStr()) + ".json");
        DefaultResult<String> result = new DefaultResult<String>();
        result.setValue(uploadOid);
        result.setSystemMessage(new SystemMessage(SysMessageUtil.get("MSG_DOS0005")));
        return result;
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.SELECT})
    public DefaultResult<Map<String, Object>> getOrgChartData(String basePath, EmployeeVO currentEmployee) throws ServiceException, Exception {
        List<Map<String, Object>> treeMap;
        if (currentEmployee != null && !super.isBlank(currentEmployee.getOid())) {
            currentEmployee = this.findEmployeeData(currentEmployee.getOid());
        }
        if ((treeMap = this.getTreeData(basePath)) == null || treeMap.size() < 1) {
            throw new ServiceException(SysMessageUtil.get("MSG_DOS0009"));
        }
        this.resetTreeMapContentForOrgChartData(treeMap, currentEmployee);
        HashMap<String, Object> rootMap = new HashMap<String, Object>();
        rootMap.put("name", "Employee hierarchy");
        rootMap.put("title", "hierarchy structure");
        rootMap.put("children", treeMap);
        DefaultResult<Map<String, Object>> result = new DefaultResult<Map<String, Object>>();
        result.setValue(rootMap);
        result.setSystemMessage(new SystemMessage(SysMessageUtil.get("MSG_DOS0005")));
        return result;
    }

    private void resetTreeMapContentForOrgChartData(List<Map<String, Object>> childMapList, EmployeeVO currentEmployee) throws Exception {
        for (Map<String, Object> nodeMap : childMapList) {
            String nodeEmployeeOid = String.valueOf(nodeMap.get("id"));
            nodeMap.remove("type");
            nodeMap.remove("id");
            nodeMap.remove("name");
            nodeMap.remove("oid");
            EmployeeVO nodeEmployee = this.findEmployeeData(nodeEmployeeOid);
            if (currentEmployee != null && !super.isBlank(currentEmployee.getOid()) && currentEmployee.getOid().equals(nodeEmployeeOid)) {
                nodeMap.put("name", "<font color='#8A0808'>" + nodeEmployee.getEmpId() + " - " + nodeEmployee.getFullName() + "</font>");
                nodeMap.put("title", "<font color='#8A0808'>" + (super.isBlank(nodeEmployee.getJobTitle()) ? "no job description" : nodeEmployee.getJobTitle().trim()) + "</font>");
            } else {
                nodeMap.put("name", String.valueOf(nodeEmployee.getEmpId()) + " - " + nodeEmployee.getFullName());
                nodeMap.put("title", super.isBlank(nodeEmployee.getJobTitle()) ? "no job description" : nodeEmployee.getJobTitle().trim());
            }
            if (nodeMap.get("children") == null || !(nodeMap.get("children") instanceof List)) continue;
            this.resetTreeMapContentForOrgChartData((List)nodeMap.get("children"), currentEmployee);
        }
    }
}

