/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.bsc.service.logic.impl;

import com.netsteadfast.greenstep.base.SysMessageUtil;
import com.netsteadfast.greenstep.base.exception.ServiceException;
import com.netsteadfast.greenstep.base.model.DefaultResult;
import com.netsteadfast.greenstep.base.model.ServiceAuthority;
import com.netsteadfast.greenstep.base.model.ServiceMethodAuthority;
import com.netsteadfast.greenstep.base.model.ServiceMethodType;
import com.netsteadfast.greenstep.base.model.SystemMessage;
import com.netsteadfast.greenstep.base.service.logic.BscBaseBusinessProcessManagementLogicService;
import com.netsteadfast.greenstep.bsc.service.IDegreeFeedbackAssignService;
import com.netsteadfast.greenstep.bsc.service.IDegreeFeedbackItemService;
import com.netsteadfast.greenstep.bsc.service.IDegreeFeedbackLevelService;
import com.netsteadfast.greenstep.bsc.service.IDegreeFeedbackProjectService;
import com.netsteadfast.greenstep.bsc.service.IDegreeFeedbackScoreService;
import com.netsteadfast.greenstep.bsc.service.logic.IDegreeFeedbackLogicService;
import com.netsteadfast.greenstep.po.hbm.BbDegreeFeedbackAssign;
import com.netsteadfast.greenstep.po.hbm.BbDegreeFeedbackItem;
import com.netsteadfast.greenstep.po.hbm.BbDegreeFeedbackLevel;
import com.netsteadfast.greenstep.po.hbm.BbDegreeFeedbackProject;
import com.netsteadfast.greenstep.po.hbm.BbDegreeFeedbackScore;
import com.netsteadfast.greenstep.po.hbm.BbEmployee;
import com.netsteadfast.greenstep.util.BusinessProcessManagementUtils;
import com.netsteadfast.greenstep.vo.BusinessProcessManagementTaskVO;
import com.netsteadfast.greenstep.vo.DegreeFeedbackAssignVO;
import com.netsteadfast.greenstep.vo.DegreeFeedbackItemVO;
import com.netsteadfast.greenstep.vo.DegreeFeedbackLevelVO;
import com.netsteadfast.greenstep.vo.DegreeFeedbackProjectVO;
import com.netsteadfast.greenstep.vo.DegreeFeedbackScoreVO;
import com.netsteadfast.greenstep.vo.EmployeeVO;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@ServiceAuthority(check=true)
@Service(value="bsc.service.logic.DegreeFeedbackLogicService")
@Transactional(propagation=Propagation.REQUIRED, readOnly=true)
public class DegreeFeedbackLogicServiceImpl
extends BscBaseBusinessProcessManagementLogicService
implements IDegreeFeedbackLogicService {
    protected Logger logger = Logger.getLogger(DegreeFeedbackLogicServiceImpl.class);
    private static final int MAX_DESCRIPTION_OR_MEMO_LENGTH = 500;
    private static final int MAX_REASON_LENGTH = 50;
    private IDegreeFeedbackProjectService<DegreeFeedbackProjectVO, BbDegreeFeedbackProject, String> degreeFeedbackProjectService;
    private IDegreeFeedbackItemService<DegreeFeedbackItemVO, BbDegreeFeedbackItem, String> degreeFeedbackItemService;
    private IDegreeFeedbackLevelService<DegreeFeedbackLevelVO, BbDegreeFeedbackLevel, String> degreeFeedbackLevelService;
    private IDegreeFeedbackAssignService<DegreeFeedbackAssignVO, BbDegreeFeedbackAssign, String> degreeFeedbackAssignService;
    private IDegreeFeedbackScoreService<DegreeFeedbackScoreVO, BbDegreeFeedbackScore, String> degreeFeedbackScoreService;

    @Override
    public String getBusinessProcessManagementResourceId() {
        return "DFProjectPublishProcess";
    }

    public IDegreeFeedbackProjectService<DegreeFeedbackProjectVO, BbDegreeFeedbackProject, String> getDegreeFeedbackProjectService() {
        return this.degreeFeedbackProjectService;
    }

    @Autowired
    @Resource(name="bsc.service.DegreeFeedbackProjectService")
    @Required
    public void setDegreeFeedbackProjectService(IDegreeFeedbackProjectService<DegreeFeedbackProjectVO, BbDegreeFeedbackProject, String> degreeFeedbackProjectService) {
        this.degreeFeedbackProjectService = degreeFeedbackProjectService;
    }

    public IDegreeFeedbackItemService<DegreeFeedbackItemVO, BbDegreeFeedbackItem, String> getDegreeFeedbackItemService() {
        return this.degreeFeedbackItemService;
    }

    @Autowired
    @Resource(name="bsc.service.DegreeFeedbackItemService")
    @Required
    public void setDegreeFeedbackItemService(IDegreeFeedbackItemService<DegreeFeedbackItemVO, BbDegreeFeedbackItem, String> degreeFeedbackItemService) {
        this.degreeFeedbackItemService = degreeFeedbackItemService;
    }

    public IDegreeFeedbackLevelService<DegreeFeedbackLevelVO, BbDegreeFeedbackLevel, String> getDegreeFeedbackLevelService() {
        return this.degreeFeedbackLevelService;
    }

    @Autowired
    @Resource(name="bsc.service.DegreeFeedbackLevelService")
    @Required
    public void setDegreeFeedbackLevelService(IDegreeFeedbackLevelService<DegreeFeedbackLevelVO, BbDegreeFeedbackLevel, String> degreeFeedbackLevelService) {
        this.degreeFeedbackLevelService = degreeFeedbackLevelService;
    }

    public IDegreeFeedbackAssignService<DegreeFeedbackAssignVO, BbDegreeFeedbackAssign, String> getDegreeFeedbackAssignService() {
        return this.degreeFeedbackAssignService;
    }

    @Autowired
    @Resource(name="bsc.service.DegreeFeedbackAssignService")
    @Required
    public void setDegreeFeedbackAssignService(IDegreeFeedbackAssignService<DegreeFeedbackAssignVO, BbDegreeFeedbackAssign, String> degreeFeedbackAssignService) {
        this.degreeFeedbackAssignService = degreeFeedbackAssignService;
    }

    public IDegreeFeedbackScoreService<DegreeFeedbackScoreVO, BbDegreeFeedbackScore, String> getDegreeFeedbackScoreService() {
        return this.degreeFeedbackScoreService;
    }

    @Autowired
    @Resource(name="bsc.service.DegreeFeedbackScoreService")
    @Required
    public void setDegreeFeedbackScoreService(IDegreeFeedbackScoreService<DegreeFeedbackScoreVO, BbDegreeFeedbackScore, String> degreeFeedbackScoreService) {
        this.degreeFeedbackScoreService = degreeFeedbackScoreService;
    }

    private Map<String, Object> getProcessFlowParam(String projectOid, String confirm, String reason) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("projectOid", projectOid);
        paramMap.put("confirm", confirm);
        paramMap.put("reason", super.defaultString(reason).length() > 50 ? reason.substring(0, 50) : reason);
        paramMap.put("cuserid", super.getAccountId());
        return paramMap;
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.INSERT})
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={RuntimeException.class, IOException.class, Exception.class})
    public DefaultResult<DegreeFeedbackProjectVO> createProject(DegreeFeedbackProjectVO project, List<DegreeFeedbackItemVO> items, List<DegreeFeedbackLevelVO> levels, List<String> ownerEmplOids, List<String> raterEmplOids) throws ServiceException, Exception {
        if (project == null || levels == null || levels.size() < 1 || items == null || items.size() < 1 || ownerEmplOids == null || ownerEmplOids.size() < 1 || raterEmplOids == null || raterEmplOids.size() < 1) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0001"));
        }
        if (levels.size() > 6 || items.size() > 10) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0002"));
        }
        super.setStringValueMaxLength(project, "description", 500);
        project.setPublishFlag("N");
        DefaultResult<DegreeFeedbackProjectVO> result = this.degreeFeedbackProjectService.saveObject(project);
        if (result.getValue() == null) {
            throw new ServiceException(result.getSystemMessage().getValue());
        }
        project = result.getValue();
        this.createLevels(project, levels);
        this.createItems(project, items);
        this.createAssign(project, ownerEmplOids, raterEmplOids);
        return result;
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.DELETE})
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={RuntimeException.class, IOException.class, Exception.class})
    public DefaultResult<Boolean> deleteProject(DegreeFeedbackProjectVO project) throws ServiceException, Exception {
        if (project == null || super.isBlank(project.getOid())) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0001"));
        }
        DefaultResult<DegreeFeedbackProjectVO> oldResult = this.degreeFeedbackProjectService.findObjectByOid(project);
        if (oldResult.getValue() == null) {
            throw new ServiceException(oldResult.getSystemMessage().getValue());
        }
        project = oldResult.getValue();
        List<BusinessProcessManagementTaskVO> tasks = this.queryTaskByVariableProjectOid(project.getOid());
        if (tasks != null && tasks.size() > 0) {
            throw new ServiceException("Audit processing running, project cannot delete!");
        }
        this.deleteLevels(project);
        this.deleteItems(project);
        this.deleteAssign(project);
        this.deleteScore(project);
        return this.degreeFeedbackProjectService.deleteObject(project);
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.UPDATE})
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={RuntimeException.class, IOException.class, Exception.class})
    public DefaultResult<DegreeFeedbackProjectVO> updateProject(DegreeFeedbackProjectVO project, List<DegreeFeedbackItemVO> items, List<DegreeFeedbackLevelVO> levels, List<String> ownerEmplOids, List<String> raterEmplOids) throws ServiceException, Exception {
        if (project == null || levels == null || levels.size() < 1 || items == null || items.size() < 1 || ownerEmplOids == null || ownerEmplOids.size() < 1 || raterEmplOids == null || raterEmplOids.size() < 1 || super.isBlank(project.getOid())) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0001"));
        }
        if (levels.size() > 6 || items.size() > 10) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0002"));
        }
        DefaultResult<DegreeFeedbackProjectVO> oldResult = this.degreeFeedbackProjectService.findObjectByOid(project);
        if (oldResult.getValue() == null) {
            throw new ServiceException(oldResult.getSystemMessage().getValue());
        }
        if ("Y".equals(oldResult.getValue().getPublishFlag())) {
            throw new ServiceException("Cannot update/modify published project!");
        }
        DefaultResult<DegreeFeedbackProjectVO> ukResult = this.degreeFeedbackProjectService.findByUK(project);
        if (ukResult.getValue() != null && !ukResult.getValue().getOid().equals(project.getOid())) {
            throw new ServiceException(SysMessageUtil.get("MSG_DOS0002"));
        }
        super.setStringValueMaxLength(project, "description", 500);
        project.setPublishFlag(oldResult.getValue().getPublishFlag());
        this.deleteLevels(project);
        this.deleteItems(project);
        this.deleteAssign(project);
        this.deleteScore(project);
        DefaultResult<DegreeFeedbackProjectVO> result = this.degreeFeedbackProjectService.updateObject(project);
        if (result.getValue() == null) {
            throw new ServiceException(result.getSystemMessage().getValue());
        }
        project = result.getValue();
        this.createLevels(project, levels);
        this.createItems(project, items);
        this.createAssign(project, ownerEmplOids, raterEmplOids);
        return result;
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.UPDATE})
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={RuntimeException.class, IOException.class, Exception.class})
    public DefaultResult<DegreeFeedbackProjectVO> updateScore(String projectOid, String ownerEmployeeOid, String raterEmployeeOid, List<DegreeFeedbackScoreVO> scores) throws ServiceException, Exception {
        if (super.isBlank(projectOid) || super.isNoSelectId(ownerEmployeeOid) || super.isBlank(raterEmployeeOid) || scores == null || scores.size() < 1) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0001"));
        }
        DegreeFeedbackProjectVO project = new DegreeFeedbackProjectVO();
        project.setOid(projectOid);
        DefaultResult<DegreeFeedbackProjectVO> projectResult = this.degreeFeedbackProjectService.findObjectByOid(project);
        if (projectResult.getValue() == null) {
            throw new ServiceException(projectResult.getSystemMessage().getValue());
        }
        project = projectResult.getValue();
        DefaultResult<DegreeFeedbackProjectVO> result = new DefaultResult<DegreeFeedbackProjectVO>();
        BbEmployee rater = this.getEmployeeService().findByAccountOid(raterEmployeeOid);
        if (rater == null || super.isBlank(rater.getOid())) {
            throw new ServiceException(SysMessageUtil.get("MSG_STD0005"));
        }
        BbEmployee owner = (BbEmployee)this.getEmployeeService().findByPKng(ownerEmployeeOid);
        if (owner == null || super.isBlank(owner.getOid())) {
            throw new ServiceException(SysMessageUtil.get("MSG_DOS0001"));
        }
        DegreeFeedbackAssignVO assign = this.findAssign(projectOid, rater.getEmpId(), owner.getEmpId());
        this.deleteScoreWithAssign(project, assign);
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        for (DegreeFeedbackScoreVO score : scores) {
            paramMap.put("oid", score.getItemOid());
            if (this.degreeFeedbackItemService.countByParams(paramMap) != 1L) {
                throw new ServiceException(SysMessageUtil.get("MSG_DOS0001"));
            }
            score.setAssignOid(assign.getOid());
            super.setStringValueMaxLength(score, "memo", 500);
            DefaultResult<DegreeFeedbackScoreVO> insertResult = this.degreeFeedbackScoreService.saveObject(score);
            if (insertResult.getValue() == null) {
                throw new ServiceException(insertResult.getSystemMessage().getValue());
            }
            result.setSystemMessage(insertResult.getSystemMessage());
        }
        paramMap.clear();
        paramMap = null;
        result.setValue(project);
        result.setSystemMessage(new SystemMessage(SysMessageUtil.get("MSG_DOS0003")));
        return result;
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.SELECT, ServiceMethodType.UPDATE})
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={RuntimeException.class, IOException.class, Exception.class})
    public void confirmTask(String projectOid, String taskId, String reason, String confirm) throws ServiceException, Exception {
        if (super.isBlank(projectOid) || super.isBlank(taskId) || super.isBlank(confirm)) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0001"));
        }
        DegreeFeedbackProjectVO project = new DegreeFeedbackProjectVO();
        project.setOid(projectOid);
        DefaultResult<DegreeFeedbackProjectVO> result = this.degreeFeedbackProjectService.findObjectByOid(project);
        if (result.getValue() == null) {
            throw new ServiceException(result.getSystemMessage().toString());
        }
        project = result.getValue();
        this.completeTask(taskId, this.getProcessFlowParam(projectOid, confirm, reason));
        List<BusinessProcessManagementTaskVO> tasks = this.queryTaskByVariableProjectOid(projectOid);
        if (tasks != null && tasks.size() > 0) {
            return;
        }
        if ("Y".equals(confirm)) {
            project.setPublishFlag("Y");
            this.degreeFeedbackProjectService.updateObject(project);
        }
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.SELECT, ServiceMethodType.SELECT})
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={RuntimeException.class, IOException.class, Exception.class})
    public String getTaskDiagram(String taskId) throws ServiceException, Exception {
        if (super.isBlank(taskId)) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0001"));
        }
        return BusinessProcessManagementUtils.getTaskDiagramById2Upload(this.getBusinessProcessManagementResourceId(), taskId);
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.SELECT, ServiceMethodType.UPDATE})
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={RuntimeException.class, IOException.class, Exception.class})
    public DefaultResult<DegreeFeedbackProjectVO> startProcess(DegreeFeedbackProjectVO project) throws ServiceException, Exception {
        if (project == null || super.isBlank(project.getOid())) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0001"));
        }
        DefaultResult<DegreeFeedbackProjectVO> result = this.degreeFeedbackProjectService.findObjectByOid(project);
        if (result.getValue() == null) {
            throw new ServiceException(result.getSystemMessage().getValue());
        }
        project = result.getValue();
        if ("Y".equals(project.getPublishFlag())) {
            throw new ServiceException("The project is published, cannot start audit processing!");
        }
        List<BusinessProcessManagementTaskVO> tasks = this.queryTaskByVariableProjectOid(project.getOid());
        if (tasks != null && tasks.size() > 0) {
            throw new ServiceException("Audit processing has been started!");
        }
        this.startProcess(this.getProcessFlowParam(project.getOid(), "Y", "start apply." + project.getName()));
        result.setSystemMessage(new SystemMessage(SysMessageUtil.get("MSG_DOS0003")));
        return result;
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.SELECT})
    public List<BusinessProcessManagementTaskVO> queryTaskByVariableProjectOid(String projectOid) throws ServiceException, Exception {
        if (super.isBlank(projectOid)) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0001"));
        }
        return super.queryTaskPlus("projectOid", projectOid);
    }

    private void createLevels(DegreeFeedbackProjectVO project, List<DegreeFeedbackLevelVO> levels) throws ServiceException, Exception {
        for (DegreeFeedbackLevelVO level : levels) {
            if (super.isBlank(level.getName())) {
                throw new ServiceException(SysMessageUtil.get("MSG_UOS0001"));
            }
            if (level.getValue() < 1) {
                throw new ServiceException(SysMessageUtil.get("MSG_UOS0002"));
            }
            level.setProjectOid(project.getOid());
            this.degreeFeedbackLevelService.saveObject(level);
        }
    }

    private void createItems(DegreeFeedbackProjectVO project, List<DegreeFeedbackItemVO> items) throws ServiceException, Exception {
        for (DegreeFeedbackItemVO item : items) {
            if (super.isBlank(item.getName())) {
                throw new ServiceException(SysMessageUtil.get("MSG_UOS0001"));
            }
            item.setProjectOid(project.getOid());
            super.setStringValueMaxLength(item, "description", 500);
            this.degreeFeedbackItemService.saveObject(item);
        }
    }

    private void createAssign(DegreeFeedbackProjectVO project, List<String> ownerEmplOids, List<String> raterEmplOids) throws ServiceException, Exception {
        HashMap<String, EmployeeVO> tmpBag = new HashMap<String, EmployeeVO>();
        for (String ownerOid : ownerEmplOids) {
            EmployeeVO owner = this.fetchEmployee(ownerOid, tmpBag);
            for (String raterOid : raterEmplOids) {
                EmployeeVO rater = this.fetchEmployee(raterOid, tmpBag);
                DegreeFeedbackAssignVO assign = new DegreeFeedbackAssignVO();
                assign.setProjectOid(project.getOid());
                assign.setOwnerId(owner.getEmpId());
                assign.setRaterId(rater.getEmpId());
                this.degreeFeedbackAssignService.saveObject(assign);
            }
        }
        tmpBag.clear();
        tmpBag = null;
    }

    private EmployeeVO fetchEmployee(String oid, Map<String, EmployeeVO> tmpBag) throws ServiceException, Exception {
        if (tmpBag.get(oid) != null) {
            return tmpBag.get(oid);
        }
        EmployeeVO employee = this.findEmployeeData(oid);
        tmpBag.put(oid, employee);
        return employee;
    }

    private void deleteLevels(DegreeFeedbackProjectVO project) throws ServiceException, Exception {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("projectOid", project.getOid());
        List levels = this.degreeFeedbackLevelService.findListByParams(paramMap);
        for (BbDegreeFeedbackLevel level : levels) {
            this.degreeFeedbackLevelService.delete(level);
        }
    }

    private void deleteItems(DegreeFeedbackProjectVO project) throws ServiceException, Exception {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("projectOid", project.getOid());
        List items = this.degreeFeedbackItemService.findListByParams(paramMap);
        for (BbDegreeFeedbackItem item : items) {
            this.degreeFeedbackItemService.delete(item);
        }
    }

    private void deleteAssign(DegreeFeedbackProjectVO project) throws ServiceException, Exception {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("projectOid", project.getOid());
        List assigns = this.degreeFeedbackAssignService.findListByParams(paramMap);
        for (BbDegreeFeedbackAssign assign : assigns) {
            this.degreeFeedbackAssignService.delete(assign);
        }
    }

    private void deleteScore(DegreeFeedbackProjectVO project) throws ServiceException, Exception {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("projectOid", project.getOid());
        List scores = this.degreeFeedbackScoreService.findListByParams(paramMap);
        for (BbDegreeFeedbackScore score : scores) {
            this.degreeFeedbackScoreService.delete(score);
        }
    }

    private void deleteScoreWithAssign(DegreeFeedbackProjectVO project, DegreeFeedbackAssignVO assign) throws ServiceException, Exception {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("projectOid", project.getOid());
        paramMap.put("assignOid", assign.getOid());
        List scores = this.degreeFeedbackScoreService.findListByParams(paramMap);
        for (BbDegreeFeedbackScore score : scores) {
            this.degreeFeedbackScoreService.delete(score);
        }
    }

    private DegreeFeedbackAssignVO findAssign(String projectOid, String raterId, String ownerId) throws ServiceException, Exception {
        DegreeFeedbackAssignVO assing = new DegreeFeedbackAssignVO();
        assing.setProjectOid(projectOid);
        assing.setOwnerId(ownerId);
        assing.setRaterId(raterId);
        DefaultResult<DegreeFeedbackAssignVO> result = this.degreeFeedbackAssignService.findByUK(assing);
        if (result.getValue() == null) {
            throw new ServiceException(result.getSystemMessage().getValue());
        }
        return result.getValue();
    }
}

