/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.bsc.service.logic.impl;

import com.netsteadfast.greenstep.base.SysMessageUtil;
import com.netsteadfast.greenstep.base.exception.ServiceException;
import com.netsteadfast.greenstep.base.model.DefaultResult;
import com.netsteadfast.greenstep.base.model.ServiceAuthority;
import com.netsteadfast.greenstep.base.model.ServiceMethodAuthority;
import com.netsteadfast.greenstep.base.model.ServiceMethodType;
import com.netsteadfast.greenstep.base.service.logic.CoreBaseLogicService;
import com.netsteadfast.greenstep.bsc.service.IAggregationMethodService;
import com.netsteadfast.greenstep.bsc.service.IKpiService;
import com.netsteadfast.greenstep.bsc.service.logic.IAggregationMethodLogicService;
import com.netsteadfast.greenstep.bsc.util.AggregationMethodUtils;
import com.netsteadfast.greenstep.po.hbm.BbAggregationMethod;
import com.netsteadfast.greenstep.po.hbm.BbKpi;
import com.netsteadfast.greenstep.vo.AggregationMethodVO;
import com.netsteadfast.greenstep.vo.KpiVO;
import java.io.IOException;
import java.util.HashMap;
import javax.annotation.Resource;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@ServiceAuthority(check=true)
@Service(value="bsc.service.logic.AggregationMethodLogicService")
@Transactional(propagation=Propagation.REQUIRED, readOnly=true)
public class AggregationMethodLogicServiceImpl
extends CoreBaseLogicService
implements IAggregationMethodLogicService {
    protected Logger logger = Logger.getLogger(AggregationMethodLogicServiceImpl.class);
    private static final int MAX_DESCRIPTION_LENGTH = 500;
    private IAggregationMethodService<AggregationMethodVO, BbAggregationMethod, String> aggregationMethodService;
    private IKpiService<KpiVO, BbKpi, String> kpiService;

    public IAggregationMethodService<AggregationMethodVO, BbAggregationMethod, String> getAggregationMethodService() {
        return this.aggregationMethodService;
    }

    @Autowired
    @Resource(name="bsc.service.AggregationMethodService")
    @Required
    public void setAggregationMethodService(IAggregationMethodService<AggregationMethodVO, BbAggregationMethod, String> aggregationMethodService) {
        this.aggregationMethodService = aggregationMethodService;
    }

    public IKpiService<KpiVO, BbKpi, String> getKpiService() {
        return this.kpiService;
    }

    @Autowired
    @Resource(name="bsc.service.KpiService")
    @Required
    public void setKpiService(IKpiService<KpiVO, BbKpi, String> kpiService) {
        this.kpiService = kpiService;
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.INSERT})
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={RuntimeException.class, IOException.class, Exception.class})
    public DefaultResult<AggregationMethodVO> create(AggregationMethodVO aggregationMethod) throws ServiceException, Exception {
        if (aggregationMethod == null || super.isBlank(aggregationMethod.getName())) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0001"));
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("name", aggregationMethod.getName());
        if (this.aggregationMethodService.countByParams(paramMap) > 0L) {
            throw new ServiceException("Please change another name!");
        }
        this.setStringValueMaxLength(aggregationMethod, "description", 500);
        return this.aggregationMethodService.saveObject(aggregationMethod);
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.UPDATE})
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={RuntimeException.class, IOException.class, Exception.class})
    public DefaultResult<AggregationMethodVO> update(AggregationMethodVO aggregationMethod) throws ServiceException, Exception {
        if (aggregationMethod == null || super.isBlank(aggregationMethod.getName()) || super.isBlank(aggregationMethod.getOid())) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0001"));
        }
        AggregationMethodVO oldAggregationMethod = AggregationMethodUtils.findSimpleByOid(aggregationMethod.getOid());
        aggregationMethod.setAggrId(oldAggregationMethod.getAggrId());
        long countName1 = 0L;
        long countName2 = 0L;
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("name", aggregationMethod.getName());
        countName1 = this.aggregationMethodService.countByParams(paramMap);
        paramMap.put("aggrId", aggregationMethod.getAggrId());
        countName2 = this.aggregationMethodService.countByParams(paramMap);
        if (countName1 > 0L && countName2 == 0L) {
            throw new ServiceException("Please change another name!");
        }
        this.setStringValueMaxLength(aggregationMethod, "description", 500);
        return this.aggregationMethodService.updateObject(aggregationMethod);
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.DELETE})
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={RuntimeException.class, IOException.class, Exception.class})
    public DefaultResult<Boolean> delete(AggregationMethodVO aggregationMethod) throws ServiceException, Exception {
        if (aggregationMethod == null || super.isBlank(aggregationMethod.getOid())) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0001"));
        }
        AggregationMethodVO oldAggregationMethod = AggregationMethodUtils.findSimpleByOid(aggregationMethod.getOid());
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("cal", oldAggregationMethod.getAggrId());
        if (this.kpiService.countByParams(paramMap) > 0L) {
            throw new ServiceException(SysMessageUtil.get("MSG_DOS0010"));
        }
        return this.aggregationMethodService.deleteObject(aggregationMethod);
    }
}

