/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.bsc.service.impl;

import com.netsteadfast.greenstep.base.SysMessageUtil;
import com.netsteadfast.greenstep.base.dao.IBaseDAO;
import com.netsteadfast.greenstep.base.exception.ServiceException;
import com.netsteadfast.greenstep.base.service.BaseService;
import com.netsteadfast.greenstep.bsc.dao.ISwotDAO;
import com.netsteadfast.greenstep.bsc.service.ISwotService;
import com.netsteadfast.greenstep.po.hbm.BbSwot;
import com.netsteadfast.greenstep.vo.SwotVO;
import java.io.IOException;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service(value="bsc.service.SwotService")
@Scope(value="prototype")
@Transactional(propagation=Propagation.REQUIRED, readOnly=true)
public class SwotServiceImpl
extends BaseService<SwotVO, BbSwot, String>
implements ISwotService<SwotVO, BbSwot, String> {
    protected Logger logger = Logger.getLogger(SwotServiceImpl.class);
    private ISwotDAO<BbSwot, String> swotDAO;

    public ISwotDAO<BbSwot, String> getSwotDAO() {
        return this.swotDAO;
    }

    @Autowired
    @Resource(name="bsc.dao.SwotDAO")
    @Required
    public void setSwotDAO(ISwotDAO<BbSwot, String> swotDAO) {
        this.swotDAO = swotDAO;
    }

    @Override
    protected IBaseDAO<BbSwot, String> getBaseDataAccessObject() {
        return this.swotDAO;
    }

    @Override
    public String getMapperIdPo2Vo() {
        return "swot.po2vo";
    }

    @Override
    public String getMapperIdVo2Po() {
        return "swot.vo2po";
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={RuntimeException.class, IOException.class, Exception.class})
    public int deleteForVisId(String visId) throws ServiceException, Exception {
        if (StringUtils.isBlank(visId)) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0001"));
        }
        return this.swotDAO.deleteForVisId(visId);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={RuntimeException.class, IOException.class, Exception.class})
    public int deleteForPerId(String perId) throws ServiceException, Exception {
        if (StringUtils.isBlank(perId)) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0001"));
        }
        return this.swotDAO.deleteForPerId(perId);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={RuntimeException.class, IOException.class, Exception.class})
    public int deleteForOrgId(String orgId) throws ServiceException, Exception {
        if (StringUtils.isBlank(orgId)) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0001"));
        }
        return this.swotDAO.deleteForOrgId(orgId);
    }
}

