/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.bsc.service.impl;

import com.netsteadfast.greenstep.base.SysMessageUtil;
import com.netsteadfast.greenstep.base.dao.IBaseDAO;
import com.netsteadfast.greenstep.base.exception.ServiceException;
import com.netsteadfast.greenstep.base.model.PageOf;
import com.netsteadfast.greenstep.base.model.QueryResult;
import com.netsteadfast.greenstep.base.model.SearchValue;
import com.netsteadfast.greenstep.base.service.BaseService;
import com.netsteadfast.greenstep.bsc.dao.IObjectiveDAO;
import com.netsteadfast.greenstep.bsc.service.IObjectiveService;
import com.netsteadfast.greenstep.po.hbm.BbObjective;
import com.netsteadfast.greenstep.vo.ObjectiveVO;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service(value="bsc.service.ObjectiveService")
@Scope(value="prototype")
@Transactional(propagation=Propagation.REQUIRED, readOnly=true)
public class ObjectiveServiceImpl
extends BaseService<ObjectiveVO, BbObjective, String>
implements IObjectiveService<ObjectiveVO, BbObjective, String> {
    protected Logger logger = Logger.getLogger(ObjectiveServiceImpl.class);
    private IObjectiveDAO<BbObjective, String> objectiveDAO;

    public IObjectiveDAO<BbObjective, String> getObjectiveDAO() {
        return this.objectiveDAO;
    }

    @Autowired
    @Resource(name="bsc.dao.ObjectiveDAO")
    @Required
    public void setObjectiveDAO(IObjectiveDAO<BbObjective, String> objectiveDAO) {
        this.objectiveDAO = objectiveDAO;
    }

    @Override
    protected IBaseDAO<BbObjective, String> getBaseDataAccessObject() {
        return this.objectiveDAO;
    }

    @Override
    public String getMapperIdPo2Vo() {
        return "objective.po2vo";
    }

    @Override
    public String getMapperIdVo2Po() {
        return "objective.vo2po";
    }

    @Override
    public String findForMaxObjId(String objId) throws ServiceException, Exception {
        if (StringUtils.isBlank(objId) || !objId.startsWith("OBJ")) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0001"));
        }
        return this.objectiveDAO.findForMaxObjId(objId);
    }

    private Map<String, Object> getQueryGridParameter(SearchValue searchValue) throws Exception {
        return super.getQueryParamHandler(searchValue).fullEquals4Select("visionOid").fullEquals4Select("perspectiveOid").fullEquals4TextField("objId").containingLike("name").getValue();
    }

    @Override
    public QueryResult<List<ObjectiveVO>> findGridResult(SearchValue searchValue, PageOf pageOf) throws ServiceException, Exception {
        if (searchValue == null || pageOf == null) {
            throw new ServiceException(SysMessageUtil.get("MSG_DOS0009"));
        }
        Map<String, Object> params = this.getQueryGridParameter(searchValue);
        int limit = Integer.parseInt(pageOf.getShowRow());
        int offset = (Integer.parseInt(pageOf.getSelect()) - 1) * limit;
        QueryResult<List<ObjectiveVO>> result = this.objectiveDAO.findPageQueryResultByQueryName("findObjectivePageGrid", params, offset, limit);
        pageOf.setCountSize(String.valueOf(result.getRowCount()));
        pageOf.toCalculateSize();
        return result;
    }

    @Override
    public List<ObjectiveVO> findForListByPerspectiveOid(String perspectiveOid) throws ServiceException, Exception {
        if (StringUtils.isBlank(perspectiveOid)) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0001"));
        }
        return this.objectiveDAO.findForListByPerspectiveOid(perspectiveOid);
    }

    @Override
    public Map<String, String> findForMapByPerspectiveOid(String perspectiveOid, boolean pleaseSelect) throws ServiceException, Exception {
        Map<String, String> dataMap = this.providedSelectZeroDataMap(pleaseSelect);
        List<ObjectiveVO> searchList = this.findForListByPerspectiveOid(perspectiveOid);
        if (searchList == null || searchList.size() < 1) {
            return dataMap;
        }
        for (ObjectiveVO p : searchList) {
            dataMap.put(p.getOid(), p.getName());
        }
        return dataMap;
    }
}

