/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.bsc.service.impl;

import com.netsteadfast.greenstep.base.SysMessageUtil;
import com.netsteadfast.greenstep.base.dao.IBaseDAO;
import com.netsteadfast.greenstep.base.exception.ServiceException;
import com.netsteadfast.greenstep.base.service.BaseService;
import com.netsteadfast.greenstep.bsc.dao.IMeasureDataDAO;
import com.netsteadfast.greenstep.bsc.service.IMeasureDataService;
import com.netsteadfast.greenstep.po.hbm.BbMeasureData;
import com.netsteadfast.greenstep.vo.MeasureDataVO;
import java.io.IOException;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service(value="bsc.service.MeasureDataService")
@Scope(value="prototype")
@Transactional(propagation=Propagation.REQUIRED, readOnly=true)
public class MeasureDataServiceImpl
extends BaseService<MeasureDataVO, BbMeasureData, String>
implements IMeasureDataService<MeasureDataVO, BbMeasureData, String> {
    protected Logger logger = Logger.getLogger(MeasureDataServiceImpl.class);
    private IMeasureDataDAO<BbMeasureData, String> measureDataDAO;

    public IMeasureDataDAO<BbMeasureData, String> getMeasureDataDAO() {
        return this.measureDataDAO;
    }

    @Autowired
    @Resource(name="bsc.dao.MeasureDataDAO")
    @Required
    public void setMeasureDataDAO(IMeasureDataDAO<BbMeasureData, String> measureDataDAO) {
        this.measureDataDAO = measureDataDAO;
    }

    @Override
    protected IBaseDAO<BbMeasureData, String> getBaseDataAccessObject() {
        return this.measureDataDAO;
    }

    @Override
    public String getMapperIdPo2Vo() {
        return "measureData.po2vo";
    }

    @Override
    public String getMapperIdVo2Po() {
        return "measureData.vo2po";
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={RuntimeException.class, IOException.class, Exception.class})
    public int deleteForKpiId(String kpiId) throws ServiceException, Exception {
        if (StringUtils.isBlank(kpiId)) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0001"));
        }
        return this.measureDataDAO.deleteForKpiId(kpiId);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={RuntimeException.class, IOException.class, Exception.class})
    public int deleteForEmpId(String empId) throws ServiceException, Exception {
        if (StringUtils.isBlank(empId)) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0001"));
        }
        return this.measureDataDAO.deleteForEmpId(empId);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={RuntimeException.class, IOException.class, Exception.class})
    public int deleteForOrgId(String orgId) throws ServiceException, Exception {
        if (StringUtils.isBlank(orgId)) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0001"));
        }
        return this.measureDataDAO.deleteForOrgId(orgId);
    }
}

