/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.bsc.service.impl;

import com.netsteadfast.greenstep.base.SysMessageUtil;
import com.netsteadfast.greenstep.base.dao.IBaseDAO;
import com.netsteadfast.greenstep.base.exception.ServiceException;
import com.netsteadfast.greenstep.base.model.DefaultResult;
import com.netsteadfast.greenstep.base.model.PageOf;
import com.netsteadfast.greenstep.base.model.QueryResult;
import com.netsteadfast.greenstep.base.model.SearchValue;
import com.netsteadfast.greenstep.base.model.SystemMessage;
import com.netsteadfast.greenstep.base.service.BaseService;
import com.netsteadfast.greenstep.bsc.dao.IKpiDAO;
import com.netsteadfast.greenstep.bsc.service.IKpiService;
import com.netsteadfast.greenstep.bsc.vo.BscMixDataVO;
import com.netsteadfast.greenstep.po.hbm.BbKpi;
import com.netsteadfast.greenstep.vo.KpiVO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service(value="bsc.service.KpiService")
@Scope(value="prototype")
@Transactional(propagation=Propagation.REQUIRED, readOnly=true)
public class KpiServiceImpl
extends BaseService<KpiVO, BbKpi, String>
implements IKpiService<KpiVO, BbKpi, String> {
    protected Logger logger = Logger.getLogger(KpiServiceImpl.class);
    private IKpiDAO<BbKpi, String> kpiDAO;

    public IKpiDAO<BbKpi, String> getKpiDAO() {
        return this.kpiDAO;
    }

    @Autowired
    @Resource(name="bsc.dao.KpiDAO")
    @Required
    public void setKpiDAO(IKpiDAO<BbKpi, String> kpiDAO) {
        this.kpiDAO = kpiDAO;
    }

    @Override
    protected IBaseDAO<BbKpi, String> getBaseDataAccessObject() {
        return this.kpiDAO;
    }

    @Override
    public String getMapperIdPo2Vo() {
        return "kpi.po2vo";
    }

    @Override
    public String getMapperIdVo2Po() {
        return "kpi.vo2po";
    }

    private Map<String, Object> getQueryGridParameter(SearchValue searchValue) throws Exception {
        return super.getQueryParamHandler(searchValue).fullEquals4Select("visionOid").fullEquals4Select("perspectiveOid").fullEquals4Select("objectiveOid").fullEquals4TextField("id").containingLike("name").getValue();
    }

    private Map<String, Object> getMixDataQueryParam(String visionOid, String orgId, String empId, String nextType, String nextId, List<String> kpiIds) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        if (!StringUtils.isBlank(visionOid)) {
            paramMap.put("visionOid", visionOid);
        }
        if (!StringUtils.isBlank(orgId)) {
            paramMap.put("orgId", orgId);
        }
        if (!StringUtils.isBlank(empId)) {
            paramMap.put("empId", empId);
        }
        if ("PER".equals(nextType) && !StringUtils.isBlank(nextId)) {
            paramMap.put("perId", nextId);
        }
        if ("OBJ".equals(nextType) && !StringUtils.isBlank(nextId)) {
            paramMap.put("objId", nextId);
        }
        if ("KPI".equals(nextType) && !StringUtils.isBlank(nextId)) {
            paramMap.put("kpiId", nextId);
        }
        if (kpiIds != null && kpiIds.size() > 0) {
            paramMap.put("kpiIds", kpiIds);
        }
        return paramMap;
    }

    @Override
    public QueryResult<List<KpiVO>> findGridResult(SearchValue searchValue, PageOf pageOf) throws ServiceException, Exception {
        if (searchValue == null || pageOf == null) {
            throw new ServiceException(SysMessageUtil.get("MSG_DOS0009"));
        }
        Map<String, Object> params = this.getQueryGridParameter(searchValue);
        int limit = Integer.parseInt(pageOf.getShowRow());
        int offset = (Integer.parseInt(pageOf.getSelect()) - 1) * limit;
        QueryResult<List<KpiVO>> result = this.kpiDAO.findPageQueryResultByQueryName("findKpiPageGrid", pageOf.setQueryOrderSortParameter(params), offset, limit);
        pageOf.setCountSize(String.valueOf(result.getRowCount()));
        pageOf.toCalculateSize();
        return result;
    }

    @Override
    public DefaultResult<List<BscMixDataVO>> findForMixData(String visionOid, String orgId, String empId, String nextType, String nextId, List<String> kpiIds) throws ServiceException, Exception {
        DefaultResult<List<BscMixDataVO>> result = new DefaultResult<List<BscMixDataVO>>();
        List<BscMixDataVO> searchList = this.kpiDAO.findForMixData(this.getMixDataQueryParam(visionOid, orgId, empId, nextType, nextId, kpiIds));
        if (searchList != null && searchList.size() > 0) {
            result.setValue(searchList);
        } else {
            result.setSystemMessage(new SystemMessage(SysMessageUtil.get("MSG_DOS0009")));
        }
        return result;
    }

    @Override
    public int countForMixData(String visionOid, String orgId, String empId, String nextType, String nextId, List<String> kpiIds) throws ServiceException, Exception {
        return this.kpiDAO.countForMixData(this.getMixDataQueryParam(visionOid, orgId, empId, nextType, nextId, kpiIds));
    }

    @Override
    public List<String> findForAppendNames(List<String> oids) throws ServiceException, Exception {
        if (oids == null || oids.size() < 1) {
            return new ArrayList<String>();
        }
        return this.kpiDAO.findForAppendNames(oids);
    }

    @Override
    public List<String> findForAppendOidsByPdcaKpis(String pdcaOid) throws Exception {
        if (StringUtils.isBlank(pdcaOid)) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0001"));
        }
        return this.kpiDAO.findForAppendOidsByPdcaKpis(pdcaOid);
    }
}

