/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.bsc.model;

import com.netsteadfast.greenstep.base.AppContext;
import com.netsteadfast.greenstep.base.exception.ServiceException;
import com.netsteadfast.greenstep.bsc.model.BscMeasureDataFrequency;
import com.netsteadfast.greenstep.bsc.service.IMonitorItemScoreService;
import com.netsteadfast.greenstep.bsc.util.BscScoreColorUtils;
import com.netsteadfast.greenstep.bsc.util.HistoryItemScoreReportContentQueryUtils;
import com.netsteadfast.greenstep.model.TemplateResultObj;
import com.netsteadfast.greenstep.po.hbm.BbMonitorItemScore;
import com.netsteadfast.greenstep.po.hbm.TbSysMailHelper;
import com.netsteadfast.greenstep.service.ISysMailHelperService;
import com.netsteadfast.greenstep.util.MailClientUtils;
import com.netsteadfast.greenstep.util.SimpleUtils;
import com.netsteadfast.greenstep.util.TemplateUtils;
import com.netsteadfast.greenstep.vo.MonitorItemScoreVO;
import com.netsteadfast.greenstep.vo.SysMailHelperVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import ognl.Ognl;
import ognl.OgnlException;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class HistoryItemScoreNoticeHandler
implements Serializable {
    private static final long serialVersionUID = -2839229894386555550L;
    protected static Logger logger = Logger.getLogger(HistoryItemScoreNoticeHandler.class);
    private IMonitorItemScoreService<MonitorItemScoreVO, BbMonitorItemScore, String> monitorItemScoreService;
    private ISysMailHelperService<SysMailHelperVO, TbSysMailHelper, String> sysMailHelperService;
    private List<String> toMail = new ArrayList<String>();
    private Map<String, String> visions = new HashMap<String, String>();
    private Map<String, String> perspectives = new HashMap<String, String>();
    private Map<String, String> objectives = new HashMap<String, String>();
    private Map<String, String> kpis = new HashMap<String, String>();
    private String dateStr = SimpleUtils.getStrYMD("");
    private String frequency = "6";
    private List<String> employees = new ArrayList<String>();
    private List<String> organizations = new ArrayList<String>();

    public HistoryItemScoreNoticeHandler() {
        this.monitorItemScoreService = (IMonitorItemScoreService)AppContext.getBean("bsc.service.MonitorItemScoreService");
        this.sysMailHelperService = (ISysMailHelperService)AppContext.getBean("core.service.SysMailHelperService");
    }

    public void action() throws ServiceException, Exception {
        if (this.toMail.size() < 1) {
            return;
        }
        if (!MailClientUtils.getEnable()) {
            logger.warn("MailClientUtils no enable.");
            return;
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("frequency", this.frequency);
        paramMap.put("dateVal", this.dateStr);
        List<BbMonitorItemScore> monitorItemScores = this.monitorItemScoreService.findListByParams(paramMap);
        this.clearNoNeedItem(monitorItemScores);
        if (monitorItemScores == null || monitorItemScores.size() < 1) {
            logger.warn("No history monitor item score data.");
            return;
        }
        StringBuilder outContent = new StringBuilder();
        this.createContent(monitorItemScores, outContent);
        if (outContent == null || outContent.length() < 1) {
            logger.warn("No history monitor mail content data.");
            return;
        }
        SysMailHelperVO sysMailHelper = new SysMailHelperVO();
        sysMailHelper.setSubject("bambooBSC monitor item score mail - frequency: " + BscMeasureDataFrequency.getFrequencyMap(false).get(this.frequency) + " , date: " + SimpleUtils.getStrYMD(this.dateStr, "/"));
        sysMailHelper.setText(outContent.toString().getBytes("utf-8"));
        sysMailHelper.setMailFrom(MailClientUtils.getDefaultFrom());
        StringBuilder to = new StringBuilder();
        for (String mail : this.toMail) {
            to.append(mail).append(";");
        }
        sysMailHelper.setMailTo(this.toMail.get(0));
        if (this.toMail.size() > 1) {
            sysMailHelper.setMailCc(to.toString());
        }
        sysMailHelper.setMailId(this.sysMailHelperService.findForMaxMailIdComplete(this.dateStr));
        sysMailHelper.setRetainFlag("N");
        sysMailHelper.setSuccessFlag("N");
        this.sysMailHelperService.saveObject(sysMailHelper);
    }

    private void createContent(List<BbMonitorItemScore> monitorItemScoresSrc, StringBuilder out) throws ServiceException, Exception {
        List<MonitorItemScoreVO> monitorItemScores = HistoryItemScoreReportContentQueryUtils.fill2ValueObjectList(monitorItemScoresSrc);
        BscScoreColorUtils.loadScoreColors();
        for (MonitorItemScoreVO itemScore : monitorItemScores) {
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("title", itemScore.getName());
            paramMap.put("date", SimpleUtils.getStrYMD(itemScore.getDateVal(), "/"));
            paramMap.put("frequency", BscMeasureDataFrequency.getFrequencyMap(false).get(this.frequency));
            paramMap.put("score", itemScore.getScore());
            paramMap.put("organization", itemScore.getOrganizationName());
            paramMap.put("employee", itemScore.getEmployeeName());
            paramMap.put("bgColor", BscScoreColorUtils.getBackgroundColor(Float.parseFloat(itemScore.getScore())));
            paramMap.put("fnColor", BscScoreColorUtils.getFontColor(Float.parseFloat(itemScore.getScore())));
            TemplateResultObj result = TemplateUtils.getResult("TPLMSG0003", paramMap);
            if (result.getContent() == null) continue;
            out.append(result.getContent());
        }
    }

    private boolean isRule(BbMonitorItemScore monitorItemScore, String expression) {
        boolean status = false;
        try {
            String value = String.valueOf(Ognl.getValue(expression, (Object)monitorItemScore));
            if ("true".equals(value)) {
                status = true;
            }
        }
        catch (OgnlException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return status;
    }

    private void clearNoNeedItem(List<BbMonitorItemScore> monitorItemScores) {
        BbMonitorItemScore itemScore;
        Iterator<BbMonitorItemScore> iterator;
        if (monitorItemScores == null) {
            return;
        }
        for (String orgId : this.organizations) {
            iterator = monitorItemScores.iterator();
            while (iterator.hasNext()) {
                itemScore = iterator.next();
                if (orgId.equals(itemScore.getOrgId())) continue;
                iterator.remove();
            }
        }
        for (String empId : this.employees) {
            iterator = monitorItemScores.iterator();
            while (iterator.hasNext()) {
                itemScore = iterator.next();
                if (empId.equals(itemScore.getOrgId())) continue;
                iterator.remove();
            }
        }
        this.clearNoNeedItem("1", this.visions, monitorItemScores);
        this.clearNoNeedItem("2", this.perspectives, monitorItemScores);
        this.clearNoNeedItem("3", this.objectives, monitorItemScores);
        this.clearNoNeedItem("4", this.kpis, monitorItemScores);
    }

    private void clearNoNeedItem(String itemType, Map<String, String> typeDataMap, List<BbMonitorItemScore> monitorItemScores) {
        for (Map.Entry<String, String> entry : typeDataMap.entrySet()) {
            Iterator<BbMonitorItemScore> iterator = monitorItemScores.iterator();
            while (iterator.hasNext()) {
                BbMonitorItemScore itemScore = iterator.next();
                if (itemType.equals(itemScore.getItemType()) && !entry.getKey().equals(itemScore.getItemId())) {
                    iterator.remove();
                    continue;
                }
                if (this.isRule(itemScore, entry.getValue())) continue;
                iterator.remove();
            }
        }
    }

    public HistoryItemScoreNoticeHandler employee(String empId) {
        if (StringUtils.isBlank(empId) || this.employees.contains(empId)) {
            return this;
        }
        this.employees.add(empId);
        return this;
    }

    public HistoryItemScoreNoticeHandler organization(String orgId) {
        if (StringUtils.isBlank(orgId) || this.organizations.contains(orgId)) {
            return this;
        }
        this.organizations.add(orgId);
        return this;
    }

    public HistoryItemScoreNoticeHandler frequency(String frequency) {
        this.frequency = frequency;
        if (BscMeasureDataFrequency.getFrequencyMap(false).get(frequency) == null) {
            this.frequency = "6";
        }
        return this;
    }

    public HistoryItemScoreNoticeHandler date(String dateStr) {
        this.dateStr = dateStr;
        if (!SimpleUtils.isDate(dateStr)) {
            this.dateStr = SimpleUtils.getStrYMD("");
        }
        return this;
    }

    public HistoryItemScoreNoticeHandler vision(String visionId, String ruleExpression) {
        if (StringUtils.isBlank(visionId) || this.visions.get(visionId) != null) {
            return this;
        }
        this.visions.put(visionId, StringUtils.defaultString(ruleExpression).trim());
        return this;
    }

    public HistoryItemScoreNoticeHandler perspective(String perspectiveId, String ruleExpression) {
        if (StringUtils.isBlank(perspectiveId) || this.perspectives.get(perspectiveId) != null) {
            return this;
        }
        this.perspectives.put(perspectiveId, StringUtils.defaultString(ruleExpression).trim());
        return this;
    }

    public HistoryItemScoreNoticeHandler objective(String objectiveId, String ruleExpression) {
        if (StringUtils.isBlank(objectiveId) || this.objectives.get(objectiveId) != null) {
            return this;
        }
        this.objectives.put(objectiveId, StringUtils.defaultString(ruleExpression).trim());
        return this;
    }

    public HistoryItemScoreNoticeHandler kpi(String kpiId, String ruleExpression) {
        if (StringUtils.isBlank(kpiId) || this.kpis.get(kpiId) != null) {
            return this;
        }
        this.kpis.put(kpiId, StringUtils.defaultString(ruleExpression).trim());
        return this;
    }

    public HistoryItemScoreNoticeHandler vision(String visionId) {
        return this.vision(visionId, "null != score");
    }

    public HistoryItemScoreNoticeHandler perspective(String perspectiveId) {
        return this.perspective(perspectiveId, "null != score");
    }

    public HistoryItemScoreNoticeHandler objective(String objectiveId) {
        return this.objective(objectiveId, "null != score");
    }

    public HistoryItemScoreNoticeHandler kpi(String kpiId) {
        return this.kpi(kpiId, "null != score");
    }

    public HistoryItemScoreNoticeHandler to(String email) {
        if (StringUtils.isBlank(email) || this.toMail.contains(email) || email.indexOf("@") == -1) {
            return this;
        }
        this.toMail.add(email);
        return this;
    }
}

