/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.bsc.model;

import com.netsteadfast.greenstep.base.AppContext;
import com.netsteadfast.greenstep.base.exception.ServiceException;
import com.netsteadfast.greenstep.po.hbm.TbSysCode;
import com.netsteadfast.greenstep.service.ISysCodeService;
import com.netsteadfast.greenstep.util.SimpleUtils;
import com.netsteadfast.greenstep.vo.SysCodeVO;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class BscMeasureDataFrequency {
    private static ISysCodeService<SysCodeVO, TbSysCode, String> sysCodeService;
    private static Map<String, String> frequencyMap;
    public static final String CODE_TYPE = "KMD";
    public static final String FREQUENCY_DAY = "1";
    public static final String FREQUENCY_DAY_CODE = "KMD_MEASURE01";
    public static final String FREQUENCY_WEEK = "2";
    public static final String FREQUENCY_WEEK_CODE = "KMD_MEASURE02";
    public static final String FREQUENCY_MONTH = "3";
    public static final String FREQUENCY_MONTH_CODE = "KMD_MEASURE03";
    public static final String FREQUENCY_QUARTER = "4";
    public static final String FREQUENCY_QUARTER_CODE = "KMD_MEASURE04";
    public static final String FREQUENCY_HALF_OF_YEAR = "5";
    public static final String FREQUENCY_HALF_OF_YEAR_CODE = "KMD_MEASURE05";
    public static final String FREQUENCY_YEAR = "6";
    public static final String FREQUENCY_YEAR_CODE = "KMD_MEASURE06";

    static {
        frequencyMap = new LinkedHashMap<String, String>();
        sysCodeService = (ISysCodeService)AppContext.getBean("core.service.SysCodeService");
    }

    private static void loadMapData() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("type", CODE_TYPE);
        HashMap<String, String> orderParams = new HashMap<String, String>();
        orderParams.put("code", "ASC");
        try {
            List codes = sysCodeService.findListByParams(params, null, orderParams);
            for (TbSysCode code : codes) {
                if (code.getCode().equals(FREQUENCY_DAY_CODE)) {
                    frequencyMap.put(FREQUENCY_DAY, code.getName());
                }
                if (code.getCode().equals(FREQUENCY_WEEK_CODE)) {
                    frequencyMap.put(FREQUENCY_WEEK, code.getName());
                }
                if (code.getCode().equals(FREQUENCY_MONTH_CODE)) {
                    frequencyMap.put(FREQUENCY_MONTH, code.getName());
                }
                if (code.getCode().equals(FREQUENCY_QUARTER_CODE)) {
                    frequencyMap.put(FREQUENCY_QUARTER, code.getName());
                }
                if (code.getCode().equals(FREQUENCY_HALF_OF_YEAR_CODE)) {
                    frequencyMap.put(FREQUENCY_HALF_OF_YEAR, code.getName());
                }
                if (!code.getCode().equals(FREQUENCY_YEAR_CODE)) continue;
                frequencyMap.put(FREQUENCY_YEAR, code.getName());
            }
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Map<String, String> getFrequencyMap(boolean pleaseSelect) {
        LinkedHashMap<String, String> dataMap = new LinkedHashMap<String, String>();
        if (pleaseSelect) {
            dataMap.put("all", " - please select - ");
        }
        if (frequencyMap.size() < 1) {
            BscMeasureDataFrequency.loadMapData();
        }
        dataMap.putAll(frequencyMap);
        return dataMap;
    }

    public static String getQueryDate(String date, String frequency) {
        String queryDate = date.replaceAll("-", "").replaceAll("/", "");
        if (FREQUENCY_DAY.equals(frequency) || FREQUENCY_WEEK.equals(frequency)) {
            queryDate = queryDate.substring(0, 6);
        }
        if (FREQUENCY_MONTH.equals(frequency) || FREQUENCY_QUARTER.equals(frequency) || FREQUENCY_HALF_OF_YEAR.equals(frequency) || FREQUENCY_YEAR.equals(frequency)) {
            queryDate = queryDate.substring(0, 4);
        }
        return queryDate;
    }

    public static Map<String, String> getWeekOrMonthStartEnd(String frequency, String startDate, String endDate) throws Exception {
        if (!FREQUENCY_WEEK.equals(frequency) && !FREQUENCY_MONTH.equals(frequency)) {
            throw new IllegalArgumentException("frequency error.");
        }
        HashMap<String, String> dateMap = new HashMap<String, String>();
        if (!SimpleUtils.isDate(startDate) || !SimpleUtils.isDate(endDate)) {
            throw new IllegalArgumentException("startDate/endDate error.");
        }
        if (FREQUENCY_WEEK.equals(frequency)) {
            int firstDay = Integer.parseInt(startDate.substring(startDate.length() - 2, startDate.length()));
            int endDay = Integer.parseInt(endDate.substring(endDate.length() - 2, endDate.length()));
            if (firstDay >= 1 && firstDay < 8) {
                firstDay = 1;
            }
            if (firstDay >= 8 && firstDay < 15) {
                firstDay = 8;
            }
            if (firstDay >= 15 && firstDay < 22) {
                firstDay = 15;
            }
            if (firstDay >= 22) {
                firstDay = 22;
            }
            if (endDay >= 1 && endDay < 8) {
                endDay = 7;
            }
            if (endDay >= 8 && endDay < 15) {
                endDay = 14;
            }
            if (endDay >= 15 && endDay < 22) {
                endDay = 21;
            }
            if (endDay >= 22) {
                endDay = SimpleUtils.getMaxDayOfMonth(Integer.parseInt(endDate.substring(0, 4)), Integer.parseInt(endDate.substring(5, 7)));
            }
            String newStartDate = String.valueOf(startDate.substring(0, startDate.length() - 2)) + StringUtils.leftPad(String.valueOf(firstDay), 2, "0");
            String newEndDate = String.valueOf(endDate.substring(0, endDate.length() - 2)) + StringUtils.leftPad(String.valueOf(endDay), 2, "0");
            dateMap.put("startDate", newStartDate);
            dateMap.put("endDate", newEndDate);
        }
        if (FREQUENCY_MONTH.equals(frequency)) {
            int endDay = SimpleUtils.getMaxDayOfMonth(Integer.parseInt(endDate.substring(0, 4)), Integer.parseInt(endDate.substring(5, 7)));
            String newStartDate = String.valueOf(startDate.substring(0, startDate.length() - 2)) + "01";
            String newEndDate = String.valueOf(endDate.substring(0, endDate.length() - 2)) + StringUtils.leftPad(String.valueOf(endDay), 2, "0");
            dateMap.put("startDate", newStartDate);
            dateMap.put("endDate", newEndDate);
        }
        return dateMap;
    }
}

