/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.bsc.model;

import com.netsteadfast.greenstep.base.AppContext;
import com.netsteadfast.greenstep.base.exception.ServiceException;
import com.netsteadfast.greenstep.po.hbm.TbSysCode;
import com.netsteadfast.greenstep.service.ISysCodeService;
import com.netsteadfast.greenstep.vo.SysCodeVO;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class BscKpiCode
implements Serializable {
    private static final long serialVersionUID = -6237662357675810151L;
    private static final String[][] QUASI_RANGE_TABLE = new String[][]{{"0", "0%"}, {"1", "1%"}, {"3", "3%"}, {"5", "5%"}, {"7", "7%"}, {"9", "9%"}, {"10", "10%"}, {"15", "15%"}, {"20", "20%"}, {"25", "25%"}, {"30", "30%"}, {"35", "35%"}, {"40", "40%"}, {"45", "45%"}, {"50", "50%"}};
    private static ISysCodeService<SysCodeVO, TbSysCode, String> sysCodeService;
    private static Map<String, String> managementMap;
    private static Map<String, String> compareTypeMap;
    @Deprecated
    private static Map<String, String> calMap;
    private static Map<String, String> dataTypeMap;
    private static Map<String, String> quasiRangeMap;
    public static final String CODE_TYPE = "KPI";
    public static final String MANAGEMENT_BIGGER_IS_BETTER = "1";
    public static final String MANAGEMENT_BIGGER_IS_BETTER_CODE = "BSC_KPIMA01";
    public static final String MANAGEMENT_SMALLER_IS_BETTER = "2";
    public static final String MANAGEMENT_SMALLER_IS_BETTER_CODE = "BSC_KPIMA02";
    public static final String MANAGEMENT_QUASI_IS_BETTER = "3";
    public static final String MANAGEMENT_QUASI_IS_BETTER_CODE = "BSC_KPIMA03";
    public static final String COMPARE_TYPE_TARGET = "1";
    public static final String COMPARE_TYPE_TARGET_CODE = "BSC_KPICT01";
    public static final String COMPARE_TYPE_MIN = "2";
    public static final String COMPARE_TYPE_MIN_CODE = "BSC_KPICT02";
    @Deprecated
    public static final String CAL_AVERAGE = "1";
    @Deprecated
    public static final String CAL_AVERAGE_CODE = "BSC_KPICA01";
    @Deprecated
    public static final String CAL_TOTAL = "2";
    @Deprecated
    public static final String CAL_TOTAL_CODE = "BSC_KPICA02";
    public static final String DATA_TYPE_DEPARTMENT = "1";
    public static final String DATA_TYPE_DEPARTMENT_CODE = "BSC_KPIDT01";
    public static final String DATA_TYPE_PERSONAL = "2";
    public static final String DATA_TYPE_PERSONAL_CODE = "BSC_KPIDT02";
    public static final String DATA_TYPE_BOTH = "3";
    public static final String DATA_TYPE_BOTH_CODE = "BSC_KPIDT03";

    static {
        managementMap = new LinkedHashMap<String, String>();
        compareTypeMap = new LinkedHashMap<String, String>();
        calMap = new LinkedHashMap<String, String>();
        dataTypeMap = new LinkedHashMap<String, String>();
        quasiRangeMap = new LinkedHashMap<String, String>();
        sysCodeService = (ISysCodeService)AppContext.getBean("core.service.SysCodeService");
        int i = 0;
        while (i < QUASI_RANGE_TABLE.length) {
            quasiRangeMap.put(QUASI_RANGE_TABLE[i][0], QUASI_RANGE_TABLE[i][1]);
            ++i;
        }
    }

    private static void fillDataMap(TbSysCode code) {
        if (MANAGEMENT_BIGGER_IS_BETTER_CODE.equals(code.getCode())) {
            managementMap.put("1", code.getName());
        }
        if (MANAGEMENT_SMALLER_IS_BETTER_CODE.equals(code.getCode())) {
            managementMap.put("2", code.getName());
        }
        if (MANAGEMENT_QUASI_IS_BETTER_CODE.equals(code.getCode())) {
            managementMap.put("3", code.getName());
        }
        if (COMPARE_TYPE_TARGET_CODE.equals(code.getCode())) {
            compareTypeMap.put("1", code.getName());
        }
        if (COMPARE_TYPE_MIN_CODE.equals(code.getCode())) {
            compareTypeMap.put("2", code.getName());
        }
        if (CAL_AVERAGE_CODE.equals(code.getCode())) {
            calMap.put("1", code.getName());
        }
        if (CAL_TOTAL_CODE.equals(code.getCode())) {
            calMap.put("2", code.getName());
        }
        if (DATA_TYPE_DEPARTMENT_CODE.equals(code.getCode())) {
            dataTypeMap.put("1", code.getName());
        }
        if (DATA_TYPE_PERSONAL_CODE.equals(code.getCode())) {
            dataTypeMap.put("2", code.getName());
        }
        if (DATA_TYPE_BOTH_CODE.equals(code.getCode())) {
            dataTypeMap.put("3", code.getName());
        }
    }

    private static void checkDataMap() {
        if (managementMap.size() != 3) {
            managementMap.clear();
            managementMap.put("1", "1");
            managementMap.put("2", "2");
            managementMap.put("3", "3");
        }
        if (compareTypeMap.size() != 2) {
            compareTypeMap.clear();
            compareTypeMap.put("1", "1");
            compareTypeMap.put("2", "2");
        }
        if (calMap.size() != 2) {
            calMap.clear();
            calMap.put("1", "1");
            calMap.put("2", "2");
        }
        if (dataTypeMap.size() != 3) {
            dataTypeMap.clear();
            dataTypeMap.put("1", "1");
            dataTypeMap.put("2", "2");
            dataTypeMap.put("3", "3");
        }
    }

    private static void loadMapData() {
        managementMap.clear();
        compareTypeMap.clear();
        calMap.clear();
        dataTypeMap.clear();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("type", CODE_TYPE);
        HashMap<String, String> orderParams = new HashMap<String, String>();
        orderParams.put("code", "ASC");
        try {
            List codes = sysCodeService.findListByParams(params, null, orderParams);
            for (TbSysCode code : codes) {
                BscKpiCode.fillDataMap(code);
            }
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        BscKpiCode.checkDataMap();
    }

    public static Map<String, String> getManagementMap(boolean pleaseSelect) {
        LinkedHashMap<String, String> dataMap = new LinkedHashMap<String, String>();
        if (pleaseSelect) {
            dataMap.put("all", " - please select - ");
        }
        if (managementMap.size() < 1) {
            BscKpiCode.loadMapData();
        }
        dataMap.putAll(managementMap);
        return dataMap;
    }

    @Deprecated
    public static Map<String, String> getCalculationMap(boolean pleaseSelect) {
        LinkedHashMap<String, String> dataMap = new LinkedHashMap<String, String>();
        if (pleaseSelect) {
            dataMap.put("all", " - please select - ");
        }
        if (calMap.size() < 1) {
            BscKpiCode.loadMapData();
        }
        dataMap.putAll(calMap);
        return dataMap;
    }

    public static Map<String, String> getCompareTypeMap(boolean pleaseSelect) {
        LinkedHashMap<String, String> dataMap = new LinkedHashMap<String, String>();
        if (pleaseSelect) {
            dataMap.put("all", " - please select - ");
        }
        if (compareTypeMap.size() < 1) {
            BscKpiCode.loadMapData();
        }
        dataMap.putAll(compareTypeMap);
        return dataMap;
    }

    public static Map<String, String> getDataTypeMap(boolean pleaseSelect) {
        LinkedHashMap<String, String> dataMap = new LinkedHashMap<String, String>();
        if (pleaseSelect) {
            dataMap.put("all", " - please select - ");
        }
        if (dataTypeMap.size() < 1) {
            BscKpiCode.loadMapData();
        }
        dataMap.putAll(dataTypeMap);
        return dataMap;
    }

    public static Map<String, String> getQuasiRangeMap() {
        return quasiRangeMap;
    }

    public static Map<String, String> getActivateOptionMap(boolean pleaseSelect) {
        LinkedHashMap<String, String> dataMap = new LinkedHashMap<String, String>();
        if (pleaseSelect) {
            dataMap.put("all", " - please select - ");
        }
        dataMap.put("Y", "Y");
        dataMap.put("N", "N");
        return dataMap;
    }
}

