/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.bsc.esb.router;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netsteadfast.greenstep.base.AppContext;
import com.netsteadfast.greenstep.bsc.vo.BscApiServiceResponse;
import com.netsteadfast.greenstep.bsc.webservice.ApiWebService;
import com.thoughtworks.xstream.XStream;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.apache.commons.lang3.StringUtils;

public class ApiRouteBuilder
extends RouteBuilder {
    @Override
    public void configure() throws Exception {
        ((RouteDefinition)this.from("servlet:///api").process(new Processor(){

            @Override
            public void process(Exchange exchange) throws Exception {
                String format = StringUtils.defaultString(exchange.getIn().getHeader("format", String.class)).trim().toLowerCase();
                String visionOid = StringUtils.defaultString(exchange.getIn().getHeader("visionOid", String.class)).trim().toLowerCase();
                String startDate = StringUtils.defaultString(exchange.getIn().getHeader("startDate", String.class)).trim().toLowerCase();
                String endDate = StringUtils.defaultString(exchange.getIn().getHeader("endDate", String.class)).trim().toLowerCase();
                String startYearDate = StringUtils.defaultString(exchange.getIn().getHeader("startYearDate", String.class)).trim().toLowerCase();
                String endYearDate = StringUtils.defaultString(exchange.getIn().getHeader("endYearDate", String.class)).trim().toLowerCase();
                String frequency = StringUtils.defaultString(exchange.getIn().getHeader("frequency", String.class)).trim().toLowerCase();
                String dataFor = StringUtils.defaultString(exchange.getIn().getHeader("dataFor", String.class)).trim().toLowerCase();
                String measureDataOrganizationOid = StringUtils.defaultString(exchange.getIn().getHeader("measureDataOrganizationOid", String.class)).trim().toLowerCase();
                String measureDataEmployeeOid = StringUtils.defaultString(exchange.getIn().getHeader("measureDataEmployeeOid", String.class)).trim().toLowerCase();
                String contentFlag = StringUtils.defaultString(exchange.getIn().getHeader("contentFlag", String.class)).trim().toUpperCase();
                String responseContent = "";
                ApiWebService apiWebService = (ApiWebService)AppContext.getBean("bsc.webservice.ApiWebService");
                BscApiServiceResponse responseObj = apiWebService.getScorecard1(visionOid, startDate, endDate, startYearDate, endYearDate, frequency, dataFor, measureDataOrganizationOid, measureDataEmployeeOid, contentFlag);
                if ("xml".equals(format)) {
                    XStream xstream = new XStream();
                    xstream.setMode(1001);
                    xstream.alias("response", BscApiServiceResponse.class);
                    responseContent = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n" + xstream.toXML(responseObj);
                } else {
                    ObjectMapper mapper = new ObjectMapper();
                    responseContent = mapper.writeValueAsString(responseObj);
                }
                exchange.getOut().setBody(responseContent);
            }
        })).to("stream:out");
    }
}

