/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.bsc.dao.impl;

import com.netsteadfast.greenstep.base.dao.BaseDAO;
import com.netsteadfast.greenstep.bsc.dao.IVisionDAO;
import com.netsteadfast.greenstep.po.hbm.BbVision;
import com.netsteadfast.greenstep.vo.VisionVO;
import java.util.List;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Repository;

@Repository(value="bsc.dao.VisionDAO")
@Scope(value="prototype")
public class VisionDAOImpl
extends BaseDAO<BbVision, String>
implements IVisionDAO<BbVision, String> {
    @Override
    public String findForMaxVisId(String visId) throws Exception {
        return (String)this.getCurrentSession().createQuery("SELECT max(m.visId) FROM BbVision m WHERE m.visId LIKE :visId ").setString("visId", String.valueOf(visId) + "%").uniqueResult();
    }

    @Override
    public VisionVO findForSimple(String oid) throws Exception {
        return (VisionVO)this.getCurrentSession().createQuery("SELECT new com.netsteadfast.greenstep.vo.VisionVO(m.oid, m.visId, m.title) FROM BbVision m WHERE m.oid = :oid ").setString("oid", oid).uniqueResult();
    }

    @Override
    public List<VisionVO> findForSimple() throws Exception {
        return this.getCurrentSession().createQuery("SELECT new com.netsteadfast.greenstep.vo.VisionVO(m.oid, m.visId, m.title) FROM BbVision m ORDER BY m.visId ASC").list();
    }

    @Override
    public VisionVO findForSimpleByVisId(String visId) throws Exception {
        return (VisionVO)this.getCurrentSession().createQuery("SELECT new com.netsteadfast.greenstep.vo.VisionVO(m.oid, m.visId, m.title) FROM BbVision m WHERE m.visId = :visId ").setString("visId", visId).uniqueResult();
    }

    @Override
    public List<String> findForOidByKpiOrga(String orgId) throws Exception {
        return this.getCurrentSession().createQuery("select distinct v.oid from BbVision v, BbKpi k, BbKpiOrga ko, BbObjective o, BbPerspective p where k.id = ko.kpiId and k.objId = o.objId and o.perId = p.perId and p.visId = v.visId and ko.orgId = :orgId ").setString("orgId", orgId).list();
    }

    @Override
    public List<String> findForOidByPdcaOid(String pdcaOid) throws Exception {
        return this.getCurrentSession().createQuery("select distinct v.oid from BbVision v, BbKpi k, BbObjective o, BbPerspective p where k.objId = o.objId and o.perId = p.perId and p.visId = v.visId and k.id in ( select pk.kpiId from BbPdcaKpis pk where pk.pdcaOid = :pdcaOid ) ").setString("pdcaOid", pdcaOid).list();
    }
}

