/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.bsc.dao.impl;

import com.netsteadfast.greenstep.base.dao.BaseDAO;
import com.netsteadfast.greenstep.bsc.dao.IEmployeeDAO;
import com.netsteadfast.greenstep.po.hbm.BbEmployee;
import com.netsteadfast.greenstep.vo.EmployeeVO;
import java.util.List;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Repository;

@Repository(value="bsc.dao.EmployeeDAO")
@Scope(value="prototype")
public class EmployeeDAOImpl
extends BaseDAO<BbEmployee, String>
implements IEmployeeDAO<BbEmployee, String> {
    @Override
    public List<String> findForAppendNames(List<String> oids) throws Exception {
        return this.getCurrentSession().createQuery("SELECT m.fullName FROM BbEmployee m WHERE m.oid IN (:oids) ").setParameterList("oids", oids).list();
    }

    @Override
    public List<String> findForAppendEmployeeOidsByKpiEmpl(String kpiId) throws Exception {
        return this.getCurrentSession().createQuery("SELECT m.oid FROM BbEmployee m WHERE m.empId IN ( SELECT b.empId FROM BbKpiEmpl b WHERE b.kpiId = :kpiId ) ").setString("kpiId", kpiId).list();
    }

    @Override
    public List<BbEmployee> findForInKpiEmpl(String kpiId) throws Exception {
        return this.getCurrentSession().createQuery("FROM BbEmployee m WHERE m.empId IN ( SELECT b.empId FROM BbKpiEmpl b WHERE b.kpiId = :kpiId ) ").setString("kpiId", kpiId).list();
    }

    @Override
    public List<String> findForAppendEmployeeOidsByReportRoleViewEmpl(String roleId) throws Exception {
        return this.getCurrentSession().createQuery("SELECT m.oid FROM BbEmployee m WHERE m.account IN ( SELECT b.idName FROM BbReportRoleView b WHERE b.role = :role and b.type = :type ) ").setString("role", roleId).setString("type", "EMP").list();
    }

    @Override
    public List<String> findForAppendEmployeeOidsByDegreeFeedbackProjectOwner(String projectOid) throws Exception {
        return this.getCurrentSession().createQuery("SELECT m.oid FROM BbEmployee m WHERE m.empId IN ( SELECT DISTINCT b.ownerId FROM BbDegreeFeedbackAssign b WHERE b.projectOid = :projectOid ) ").setString("projectOid", projectOid).list();
    }

    @Override
    public List<String> findForAppendEmployeeOidsByDegreeFeedbackProjectRater(String projectOid) throws Exception {
        return this.getCurrentSession().createQuery("SELECT m.oid FROM BbEmployee m WHERE m.empId IN ( SELECT DISTINCT b.raterId FROM BbDegreeFeedbackAssign b WHERE b.projectOid = :projectOid ) ").setString("projectOid", projectOid).list();
    }

    @Override
    public BbEmployee findByAccountOid(String accountOid) throws Exception {
        return (BbEmployee)this.getCurrentSession().createQuery("FROM BbEmployee WHERE account IN ( SELECT b.account FROM TbAccount b WHERE b.oid = :oid ) ").setString("oid", accountOid).uniqueResult();
    }

    @Override
    public List<String> findForAppendEmployeeOidsByPdcaOwner(String pdcaOid) throws Exception {
        return this.getCurrentSession().createQuery("SELECT m.oid FROM BbEmployee m WHERE m.empId IN ( SELECT b.empId FROM BbPdcaOwner b WHERE b.pdcaOid = :pdcaOid ) ").setString("pdcaOid", pdcaOid).list();
    }

    @Override
    public List<String> findForAppendEmployeeOidsByPdcaItemOwner(String pdcaOid, String itemOid) throws Exception {
        return this.getCurrentSession().createQuery("SELECT m.oid FROM BbEmployee m WHERE m.empId IN ( SELECT b.empId FROM BbPdcaItemOwner b WHERE b.pdcaOid = :pdcaOid AND b.itemOid = :itemOid ) ").setString("pdcaOid", pdcaOid).setString("itemOid", itemOid).list();
    }

    @Override
    public List<EmployeeVO> findForJoinHier() throws Exception {
        return this.getCurrentSession().createQuery("SELECT new com.netsteadfast.greenstep.vo.EmployeeVO(m.oid, m.account, m.empId, m.fullName, m.jobTitle, h.supOid) FROM BbEmployee m, BbEmployeeHier h WHERE m.oid = h.empOid").list();
    }
}

