/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.bsc.command;

import com.netsteadfast.greenstep.base.BaseChainCommandSupport;
import com.netsteadfast.greenstep.bsc.model.BscStructTreeObj;
import com.netsteadfast.greenstep.util.TemplateUtils;
import com.netsteadfast.greenstep.vo.KpiVO;
import com.netsteadfast.greenstep.vo.ObjectiveVO;
import com.netsteadfast.greenstep.vo.PerspectiveVO;
import com.netsteadfast.greenstep.vo.VisionVO;
import java.math.BigDecimal;
import java.util.HashMap;
import org.apache.commons.chain.Command;
import org.apache.commons.chain.Context;

public class WeightBodyCommand
extends BaseChainCommandSupport
implements Command {
    private static final String templateResource = "META-INF/resource/weight-settings-body.ftl";
    private static final BigDecimal MAX_WEIGHT_VALUE = new BigDecimal("100.00");

    @Override
    public boolean execute(Context context) throws Exception {
        if (this.getResult(context) == null || !(this.getResult(context) instanceof BscStructTreeObj)) {
            return false;
        }
        BscStructTreeObj treeObj = (BscStructTreeObj)this.getResult(context);
        if ("Y".equals(context.get("autoAllocation"))) {
            this.autoAllocation(treeObj);
        }
        HashMap<String, Object> parameter = new HashMap<String, Object>();
        parameter.put("treeObj", treeObj);
        parameter.put("weightName", String.valueOf(context.get("weightName")));
        String content = TemplateUtils.processTemplate("resourceTemplate", WeightBodyCommand.class.getClassLoader(), templateResource, parameter);
        this.setResult(context, content);
        return false;
    }

    private void autoAllocation(BscStructTreeObj treeObj) throws Exception {
        int scale = 2;
        for (VisionVO vision : treeObj.getVisions()) {
            int px = 0;
            while (px < vision.getPerspectives().size()) {
                PerspectiveVO perspective = vision.getPerspectives().get(px);
                int round = 1;
                if (px + 1 == vision.getPerspectives().size()) {
                    round = 0;
                }
                perspective.setWeight(MAX_WEIGHT_VALUE.divide(new BigDecimal(vision.getPerspectives().size()), scale, round));
                int ox = 0;
                while (ox < perspective.getObjectives().size()) {
                    ObjectiveVO objective = perspective.getObjectives().get(ox);
                    round = 1;
                    if (ox + 1 == perspective.getObjectives().size()) {
                        round = 0;
                    }
                    objective.setWeight(MAX_WEIGHT_VALUE.divide(new BigDecimal(perspective.getObjectives().size()), scale, round));
                    int kx = 0;
                    while (kx < objective.getKpis().size()) {
                        KpiVO kpi = objective.getKpis().get(kx);
                        round = 1;
                        if (kx + 1 == objective.getKpis().size()) {
                            round = 0;
                        }
                        kpi.setWeight(MAX_WEIGHT_VALUE.divide(new BigDecimal(objective.getKpis().size()), scale, round));
                        ++kx;
                    }
                    ++ox;
                }
                ++px;
            }
        }
    }
}

