/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.bsc.command;

import com.netsteadfast.greenstep.base.BaseChainCommandSupport;
import com.netsteadfast.greenstep.base.Constants;
import com.netsteadfast.greenstep.bsc.util.BscReportPropertyUtils;
import com.netsteadfast.greenstep.po.hbm.BbTsaMaCoefficients;
import com.netsteadfast.greenstep.util.SimpleUtils;
import com.netsteadfast.greenstep.util.UploadSupportUtils;
import com.netsteadfast.greenstep.vo.DateRangeScoreVO;
import com.netsteadfast.greenstep.vo.KpiVO;
import com.netsteadfast.greenstep.vo.ObjectiveVO;
import com.netsteadfast.greenstep.vo.PerspectiveVO;
import com.netsteadfast.greenstep.vo.TsaVO;
import com.netsteadfast.greenstep.vo.VisionVO;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.util.List;
import javax.imageio.ImageIO;
import org.apache.commons.chain.Command;
import org.apache.commons.chain.Context;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class TimeSeriesAnalysisExcelCommand
extends BaseChainCommandSupport
implements Command {
    @Override
    public boolean execute(Context context) throws Exception {
        String uploadOid = this.createExcel(context);
        this.setResult(context, uploadOid);
        return false;
    }

    private String createExcel(Context context) throws Exception {
        String fileName = String.valueOf(SimpleUtils.getUUIDStr()) + ".xlsx";
        String fileFullPath = String.valueOf(Constants.getWorkTmpDir()) + "/" + fileName;
        XSSFWorkbook wb = new XSSFWorkbook();
        XSSFSheet sh = wb.createSheet();
        this.putTables(wb, sh, context);
        FileOutputStream out = new FileOutputStream(fileFullPath);
        wb.write(out);
        out.close();
        wb = null;
        File file = new File(fileFullPath);
        String oid = UploadSupportUtils.create(Constants.getSystem(), "tmp", false, file, "forecast-analysis.xlsx");
        file = null;
        return oid;
    }

    private void putTables(XSSFWorkbook wb, XSSFSheet sh, Context context) throws Exception {
        ObjectiveVO objective;
        TsaVO tsa = (TsaVO)context.get("tsa");
        List coefficients = (List)context.get("coefficients");
        VisionVO vision = (VisionVO)context.get("tsaVisionResult");
        XSSFFont cellHeadFont = wb.createFont();
        cellHeadFont.setBold(true);
        XSSFCellStyle cellHeadStyle = wb.createCellStyle();
        cellHeadStyle.setFillForegroundColor(new XSSFColor(SimpleUtils.getColorRGB4POIColor("#f5f5f5"), null));
        cellHeadStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        cellHeadStyle.setBorderBottom(BorderStyle.THIN);
        cellHeadStyle.setBorderTop(BorderStyle.THIN);
        cellHeadStyle.setBorderRight(BorderStyle.THIN);
        cellHeadStyle.setBorderLeft(BorderStyle.THIN);
        cellHeadStyle.setFont(cellHeadFont);
        XSSFCellStyle cellHeadStyleBlank = wb.createCellStyle();
        cellHeadStyleBlank.setFillForegroundColor(new XSSFColor(SimpleUtils.getColorRGB4POIColor("#ffffff"), null));
        cellHeadStyleBlank.setFont(cellHeadFont);
        XSSFCellStyle cellHeadStyle2 = wb.createCellStyle();
        cellHeadStyle2.setFillForegroundColor(new XSSFColor(SimpleUtils.getColorRGB4POIColor("#ffffff"), null));
        cellHeadStyle2.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        cellHeadStyle2.setBorderBottom(BorderStyle.THIN);
        cellHeadStyle2.setBorderTop(BorderStyle.THIN);
        cellHeadStyle2.setBorderRight(BorderStyle.THIN);
        cellHeadStyle2.setBorderLeft(BorderStyle.THIN);
        sh.setColumnWidth(0, 12000);
        int row = 0;
        XSSFRow nowRow = sh.createRow(row);
        Cell cellTitle = nowRow.createCell(0);
        cellTitle.setCellStyle(cellHeadStyleBlank);
        cellTitle.setCellValue("Forecast analysis - " + context.get("visionName"));
        nowRow = sh.createRow(++row);
        Cell cell0a = nowRow.createCell(0);
        cell0a.setCellStyle(cellHeadStyleBlank);
        cell0a.setCellValue("Frequency: " + context.get("frequencyName") + " , Date range: " + context.get("date1") + " - " + context.get("date2") + " , " + "Measure data type for: " + context.get("dataFor") + " , " + context.get("organizationName") + context.get("employeeName"));
        nowRow = sh.createRow(++row);
        Cell cell0b = nowRow.createCell(0);
        cell0b.setCellStyle(cellHeadStyleBlank);
        cell0b.setCellValue("");
        nowRow = sh.createRow(++row);
        Cell cell1 = nowRow.createCell(0);
        cell1.setCellStyle(cellHeadStyleBlank);
        cell1.setCellValue("Param infornation");
        nowRow = sh.createRow(++row);
        Cell cell2_a = nowRow.createCell(0);
        cell2_a.setCellStyle(cellHeadStyle);
        cell2_a.setCellValue("Item");
        Cell cell2_b = nowRow.createCell(1);
        cell2_b.setCellStyle(cellHeadStyle);
        cell2_b.setCellValue("Value");
        nowRow = sh.createRow(++row);
        Cell cell3_a = nowRow.createCell(0);
        cell3_a.setCellStyle(cellHeadStyle2);
        cell3_a.setCellValue("Param name");
        Cell cell3_b = nowRow.createCell(1);
        cell3_b.setCellStyle(cellHeadStyle2);
        cell3_b.setCellValue(tsa.getName());
        nowRow = sh.createRow(++row);
        Cell cell4_a = nowRow.createCell(0);
        cell4_a.setCellStyle(cellHeadStyle2);
        cell4_a.setCellValue("Integration order");
        Cell cell4_b = nowRow.createCell(1);
        cell4_b.setCellStyle(cellHeadStyle2);
        cell4_b.setCellValue(tsa.getIntegrationOrder());
        nowRow = sh.createRow(++row);
        Cell cell5_a = nowRow.createCell(0);
        cell5_a.setCellStyle(cellHeadStyle2);
        cell5_a.setCellValue("Forecast next");
        Cell cell5_b = nowRow.createCell(1);
        cell5_b.setCellStyle(cellHeadStyle2);
        cell5_b.setCellValue(tsa.getForecastNext());
        nowRow = sh.createRow(++row);
        Cell cell6_a = nowRow.createCell(0);
        cell6_a.setCellStyle(cellHeadStyle2);
        cell6_a.setCellValue("Description");
        Cell cell6_b = nowRow.createCell(1);
        cell6_b.setCellStyle(cellHeadStyle2);
        cell6_b.setCellValue(StringUtils.defaultString(tsa.getDescription()).trim());
        ++row;
        int i = 0;
        while (coefficients != null && i < coefficients.size()) {
            BbTsaMaCoefficients coefficient = (BbTsaMaCoefficients)coefficients.get(i);
            nowRow = sh.createRow(row);
            Cell cell7x_a = nowRow.createCell(0);
            cell7x_a.setCellStyle(cellHeadStyle2);
            cell7x_a.setCellValue("Coefficient (" + (i + 1) + ")");
            Cell cell7x_b = nowRow.createCell(1);
            cell7x_b.setCellStyle(cellHeadStyle2);
            cell7x_b.setCellValue(String.valueOf(coefficient.getSeqValue()));
            ++row;
            ++i;
        }
        nowRow = sh.createRow(row);
        Cell cellTitle3a = nowRow.createCell(0);
        cellTitle3a.setCellStyle(cellHeadStyleBlank);
        cellTitle3a.setCellValue("");
        BscReportPropertyUtils.loadData();
        nowRow = sh.createRow(++row);
        Cell cellTitle2a = nowRow.createCell(0);
        cellTitle2a.setCellStyle(cellHeadStyle);
        cellTitle2a.setCellValue("Vision");
        int j = 1;
        int i2 = 0;
        while (i2 < vision.getDateRangeScores().size()) {
            DateRangeScoreVO dateRangeScore = vision.getDateRangeScores().get(i2);
            Cell cellTitle2a_dateRange = nowRow.createCell(j);
            ++j;
            cellTitle2a_dateRange.setCellStyle(cellHeadStyle);
            cellTitle2a_dateRange.setCellValue(dateRangeScore.getDate());
            ++i2;
        }
        i2 = 0;
        while (i2 < vision.getForecastNext().size()) {
            Cell cellTitle2a_dateRange = nowRow.createCell(j);
            ++j;
            cellTitle2a_dateRange.setCellStyle(cellHeadStyle);
            cellTitle2a_dateRange.setCellValue("next(" + (i2 + 1) + ")");
            ++i2;
        }
        nowRow = sh.createRow(++row);
        j = 0;
        Cell cell_item = nowRow.createCell(j);
        cell_item.setCellStyle(cellHeadStyle);
        cell_item.setCellValue(vision.getTitle());
        ++j;
        int n = 0;
        while (n < vision.getDateRangeScores().size()) {
            DateRangeScoreVO dateRangeScore = vision.getDateRangeScores().get(n);
            Cell cell_dateRangeScore = nowRow.createCell(j);
            cell_dateRangeScore.setCellStyle(cellHeadStyle2);
            cell_dateRangeScore.setCellValue(dateRangeScore.getScore());
            ++j;
            ++n;
        }
        n = 0;
        while (n < vision.getForecastNext().size()) {
            double forecastScore = vision.getForecastNext().get(n);
            Cell cell_forecastScore = nowRow.createCell(j);
            cell_forecastScore.setCellStyle(cellHeadStyle2);
            cell_forecastScore.setCellValue(forecastScore);
            ++j;
            ++n;
        }
        ++row;
        nowRow = sh.createRow(++row);
        cellTitle2a = nowRow.createCell(0);
        cellTitle2a.setCellStyle(cellHeadStyle);
        cellTitle2a.setCellValue(BscReportPropertyUtils.getPerspectiveTitle());
        j = 1;
        int i3 = 0;
        while (i3 < vision.getPerspectives().get(0).getDateRangeScores().size()) {
            DateRangeScoreVO dateRangeScore = vision.getPerspectives().get(0).getDateRangeScores().get(i3);
            Cell cellTitle2a_dateRange = nowRow.createCell(j);
            ++j;
            cellTitle2a_dateRange.setCellStyle(cellHeadStyle);
            cellTitle2a_dateRange.setCellValue(dateRangeScore.getDate());
            ++i3;
        }
        i3 = 0;
        while (i3 < vision.getPerspectives().get(0).getForecastNext().size()) {
            Cell cellTitle2a_dateRange = nowRow.createCell(j);
            ++j;
            cellTitle2a_dateRange.setCellStyle(cellHeadStyle);
            cellTitle2a_dateRange.setCellValue("next(" + (i3 + 1) + ")");
            ++i3;
        }
        ++row;
        i3 = 0;
        while (i3 < vision.getPerspectives().size()) {
            PerspectiveVO perspective = vision.getPerspectives().get(i3);
            nowRow = sh.createRow(row);
            j = 0;
            cell_item = nowRow.createCell(j);
            cell_item.setCellStyle(cellHeadStyle);
            cell_item.setCellValue(perspective.getName());
            ++j;
            int n2 = 0;
            while (n2 < perspective.getDateRangeScores().size()) {
                DateRangeScoreVO dateRangeScore = perspective.getDateRangeScores().get(n2);
                Cell cell_dateRangeScore = nowRow.createCell(j);
                cell_dateRangeScore.setCellStyle(cellHeadStyle2);
                cell_dateRangeScore.setCellValue(dateRangeScore.getScore());
                ++j;
                ++n2;
            }
            n2 = 0;
            while (n2 < perspective.getForecastNext().size()) {
                double forecastScore = perspective.getForecastNext().get(n2);
                Cell cell_forecastScore = nowRow.createCell(j);
                cell_forecastScore.setCellStyle(cellHeadStyle2);
                cell_forecastScore.setCellValue(forecastScore);
                ++j;
                ++n2;
            }
            ++row;
            ++i3;
        }
        nowRow = sh.createRow(++row);
        cellTitle2a = nowRow.createCell(0);
        cellTitle2a.setCellStyle(cellHeadStyle);
        cellTitle2a.setCellValue(BscReportPropertyUtils.getObjectiveTitle());
        j = 1;
        i3 = 0;
        while (i3 < vision.getPerspectives().get(0).getObjectives().get(0).getDateRangeScores().size()) {
            DateRangeScoreVO dateRangeScore = vision.getPerspectives().get(0).getObjectives().get(0).getDateRangeScores().get(i3);
            Cell cellTitle2a_dateRange = nowRow.createCell(j);
            ++j;
            cellTitle2a_dateRange.setCellStyle(cellHeadStyle);
            cellTitle2a_dateRange.setCellValue(dateRangeScore.getDate());
            ++i3;
        }
        i3 = 0;
        while (i3 < vision.getPerspectives().get(0).getObjectives().get(0).getForecastNext().size()) {
            Cell cellTitle2a_dateRange = nowRow.createCell(j);
            ++j;
            cellTitle2a_dateRange.setCellStyle(cellHeadStyle);
            cellTitle2a_dateRange.setCellValue("next(" + (i3 + 1) + ")");
            ++i3;
        }
        ++row;
        i3 = 0;
        while (i3 < vision.getPerspectives().size()) {
            PerspectiveVO perspective = vision.getPerspectives().get(i3);
            int o = 0;
            while (o < perspective.getObjectives().size()) {
                objective = perspective.getObjectives().get(o);
                nowRow = sh.createRow(row);
                j = 0;
                cell_item = nowRow.createCell(j);
                cell_item.setCellStyle(cellHeadStyle);
                cell_item.setCellValue(objective.getName());
                ++j;
                int n3 = 0;
                while (n3 < objective.getDateRangeScores().size()) {
                    DateRangeScoreVO dateRangeScore = objective.getDateRangeScores().get(n3);
                    Cell cell_dateRangeScore = nowRow.createCell(j);
                    cell_dateRangeScore.setCellStyle(cellHeadStyle2);
                    cell_dateRangeScore.setCellValue(dateRangeScore.getScore());
                    ++j;
                    ++n3;
                }
                n3 = 0;
                while (n3 < objective.getForecastNext().size()) {
                    double forecastScore = objective.getForecastNext().get(n3);
                    Cell cell_forecastScore = nowRow.createCell(j);
                    cell_forecastScore.setCellStyle(cellHeadStyle2);
                    cell_forecastScore.setCellValue(forecastScore);
                    ++j;
                    ++n3;
                }
                ++row;
                ++o;
            }
            ++i3;
        }
        nowRow = sh.createRow(++row);
        cellTitle2a = nowRow.createCell(0);
        cellTitle2a.setCellStyle(cellHeadStyle);
        cellTitle2a.setCellValue(BscReportPropertyUtils.getKpiTitle());
        j = 1;
        i3 = 0;
        while (i3 < vision.getPerspectives().get(0).getObjectives().get(0).getKpis().get(0).getDateRangeScores().size()) {
            DateRangeScoreVO dateRangeScore = vision.getPerspectives().get(0).getObjectives().get(0).getKpis().get(0).getDateRangeScores().get(i3);
            Cell cellTitle2a_dateRange = nowRow.createCell(j);
            ++j;
            cellTitle2a_dateRange.setCellStyle(cellHeadStyle);
            cellTitle2a_dateRange.setCellValue(dateRangeScore.getDate());
            ++i3;
        }
        i3 = 0;
        while (i3 < vision.getPerspectives().get(0).getObjectives().get(0).getKpis().get(0).getForecastNext().size()) {
            Cell cellTitle2a_dateRange = nowRow.createCell(j);
            ++j;
            cellTitle2a_dateRange.setCellStyle(cellHeadStyle);
            cellTitle2a_dateRange.setCellValue("next(" + (i3 + 1) + ")");
            ++i3;
        }
        ++row;
        i3 = 0;
        while (i3 < vision.getPerspectives().size()) {
            PerspectiveVO perspective = vision.getPerspectives().get(i3);
            int o = 0;
            while (o < perspective.getObjectives().size()) {
                objective = perspective.getObjectives().get(o);
                int k = 0;
                while (k < objective.getKpis().size()) {
                    KpiVO kpi = objective.getKpis().get(k);
                    nowRow = sh.createRow(row);
                    j = 0;
                    cell_item = nowRow.createCell(j);
                    cell_item.setCellStyle(cellHeadStyle);
                    cell_item.setCellValue(kpi.getName());
                    ++j;
                    int n4 = 0;
                    while (n4 < kpi.getDateRangeScores().size()) {
                        DateRangeScoreVO dateRangeScore = kpi.getDateRangeScores().get(n4);
                        Cell cell_dateRangeScore = nowRow.createCell(j);
                        cell_dateRangeScore.setCellStyle(cellHeadStyle2);
                        cell_dateRangeScore.setCellValue(dateRangeScore.getScore());
                        ++j;
                        ++n4;
                    }
                    n4 = 0;
                    while (n4 < kpi.getForecastNext().size()) {
                        double forecastScore = kpi.getForecastNext().get(n4);
                        Cell cell_forecastScore = nowRow.createCell(j);
                        cell_forecastScore.setCellStyle(cellHeadStyle2);
                        cell_forecastScore.setCellValue(forecastScore);
                        ++j;
                        ++n4;
                    }
                    ++row;
                    ++k;
                }
                ++o;
            }
            ++i3;
        }
        ++row;
        int chart_need_row_size = 22;
        String visionDateRangeChartPngData = (String)context.get("visionDateRangeChartPngData");
        if (StringUtils.isBlank(visionDateRangeChartPngData)) {
            return;
        }
        String visionImageDataStr = SimpleUtils.getPNGBase64Content(visionDateRangeChartPngData);
        BufferedImage visionImage = SimpleUtils.decodeToImage(visionImageDataStr);
        ByteArrayOutputStream visionImgBos = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)visionImage, "png", visionImgBos);
        visionImgBos.flush();
        SimpleUtils.setCellPicture(wb, sh, visionImgBos.toByteArray(), row, 0);
        row += chart_need_row_size;
        String perspectiveDateRangeChartPngData = (String)context.get("perspectiveDateRangeChartPngData");
        if (StringUtils.isBlank(perspectiveDateRangeChartPngData)) {
            return;
        }
        String perspectiveImageDataStr = SimpleUtils.getPNGBase64Content(perspectiveDateRangeChartPngData);
        BufferedImage perspectiveImage = SimpleUtils.decodeToImage(perspectiveImageDataStr);
        ByteArrayOutputStream perspectiveImgBos = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)perspectiveImage, "png", perspectiveImgBos);
        perspectiveImgBos.flush();
        SimpleUtils.setCellPicture(wb, sh, perspectiveImgBos.toByteArray(), row, 0);
        row += chart_need_row_size;
        String objectiveDateRangeChartPngData = (String)context.get("objectiveDateRangeChartPngData");
        if (StringUtils.isBlank(objectiveDateRangeChartPngData)) {
            return;
        }
        String objectiveImageDataStr = SimpleUtils.getPNGBase64Content(objectiveDateRangeChartPngData);
        BufferedImage objectiveImage = SimpleUtils.decodeToImage(objectiveImageDataStr);
        ByteArrayOutputStream objectiveImgBos = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)objectiveImage, "png", objectiveImgBos);
        objectiveImgBos.flush();
        SimpleUtils.setCellPicture(wb, sh, objectiveImgBos.toByteArray(), row, 0);
        row += chart_need_row_size;
        String dateRangeChartPngData = (String)context.get("dateRangeChartPngData");
        if (StringUtils.isBlank(dateRangeChartPngData)) {
            return;
        }
        String imageDataStr = SimpleUtils.getPNGBase64Content(dateRangeChartPngData);
        BufferedImage image = SimpleUtils.decodeToImage(imageDataStr);
        ByteArrayOutputStream imgBos = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)image, "png", imgBos);
        imgBos.flush();
        SimpleUtils.setCellPicture(wb, sh, imgBos.toByteArray(), row, 0);
    }
}

