/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.bsc.command;

import com.netsteadfast.greenstep.base.AppContext;
import com.netsteadfast.greenstep.base.BaseChainCommandSupport;
import com.netsteadfast.greenstep.bsc.service.ISwotReportDtlService;
import com.netsteadfast.greenstep.bsc.service.ISwotReportMstService;
import com.netsteadfast.greenstep.bsc.vo.SwotDataVO;
import com.netsteadfast.greenstep.bsc.vo.SwotIssuesVO;
import com.netsteadfast.greenstep.po.hbm.BbSwotReportDtl;
import com.netsteadfast.greenstep.po.hbm.BbSwotReportMst;
import com.netsteadfast.greenstep.util.SimpleUtils;
import com.netsteadfast.greenstep.vo.SwotReportDtlVO;
import com.netsteadfast.greenstep.vo.SwotReportMstVO;
import org.apache.commons.chain.Command;
import org.apache.commons.chain.Context;
import org.apache.commons.lang3.StringUtils;

public class SwotReportPdfDataCommand
extends BaseChainCommandSupport
implements Command {
    private ISwotReportMstService<SwotReportMstVO, BbSwotReportMst, String> swotReportMstService = (ISwotReportMstService)AppContext.getBean("bsc.service.SwotReportMstService");
    private ISwotReportDtlService<SwotReportDtlVO, BbSwotReportDtl, String> swotReportDtlService = (ISwotReportDtlService)AppContext.getBean("bsc.service.SwotReportDtlService");

    @Override
    public boolean execute(Context context) throws Exception {
        if (this.getResult(context) == null || !(this.getResult(context) instanceof SwotDataVO)) {
            return false;
        }
        SwotDataVO swotData = (SwotDataVO)this.getResult(context);
        String reportId = this.createReportData(swotData);
        if (!StringUtils.isBlank(reportId)) {
            this.setResult(context, reportId);
        } else {
            this.setMessage(context, "create report data fail!");
        }
        return false;
    }

    private String createReportData(SwotDataVO swotData) throws Exception {
        if (swotData.getIssues() == null || swotData.getIssues().size() < 1) {
            return "";
        }
        String reportId = SimpleUtils.getUUIDStr();
        SwotReportMstVO reportMst = new SwotReportMstVO();
        reportMst.setReportId(reportId);
        reportMst.setVisionTitle(swotData.getVision().getTitle());
        reportMst.setOrgName(swotData.getOrganization().getName());
        this.swotReportMstService.saveIgnoreUK(reportMst);
        int i = 0;
        while (i < swotData.getIssues().size()) {
            SwotIssuesVO issuesData = swotData.getIssues().get(i);
            SwotReportDtlVO reportDtl = new SwotReportDtlVO();
            reportDtl.setReportId(reportId);
            reportDtl.setSeq(i);
            reportDtl.setLabel(issuesData.getPerspectiveName());
            reportDtl.setIssues1(issuesData.getStrengths());
            reportDtl.setIssues2(issuesData.getWeaknesses());
            reportDtl.setIssues3(issuesData.getOpportunities());
            reportDtl.setIssues4(issuesData.getThreats());
            this.swotReportDtlService.saveIgnoreUK(reportDtl);
            ++i;
        }
        return reportId;
    }
}

