/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.bsc.command;

import com.netsteadfast.greenstep.base.BaseChainCommandSupport;
import com.netsteadfast.greenstep.bsc.model.BscStructTreeObj;
import com.netsteadfast.greenstep.bsc.support.ScoreCalculationCallable;
import com.netsteadfast.greenstep.bsc.support.ScoreCalculationCallableData;
import com.netsteadfast.greenstep.bsc.util.BscScoreColorUtils;
import com.netsteadfast.greenstep.bsc.util.PerformanceScoreChainUtils;
import com.netsteadfast.greenstep.util.SimpleUtils;
import com.netsteadfast.greenstep.vo.KpiVO;
import com.netsteadfast.greenstep.vo.ObjectiveVO;
import com.netsteadfast.greenstep.vo.PerspectiveVO;
import com.netsteadfast.greenstep.vo.VisionVO;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.chain.Command;
import org.apache.commons.chain.Context;

public class ScoreCalculationCommand
extends BaseChainCommandSupport
implements Command {
    @Override
    public boolean execute(Context context) throws Exception {
        if (this.getResult(context) == null || !(this.getResult(context) instanceof BscStructTreeObj)) {
            return false;
        }
        BscStructTreeObj treeObj = (BscStructTreeObj)this.getResult(context);
        this.scoreCalculation(treeObj);
        return false;
    }

    private void scoreCalculation(BscStructTreeObj treeObj) throws Exception {
        List<VisionVO> visions = treeObj.getVisions();
        BscScoreColorUtils.loadScoreColors();
        this.processKpisScore(visions);
        this.processObjectivesScore(visions);
        this.processPerspectivesScore(visions);
        this.processVisionsScore(visions);
    }

    private void processVisionsScore(List<VisionVO> visions) throws Exception {
        for (VisionVO vision : visions) {
            float score = 0.0f;
            for (PerspectiveVO perspective : vision.getPerspectives()) {
                score += perspective.getScore() * PerformanceScoreChainUtils.getWeightPercentage(perspective.getWeight());
            }
            vision.setScore(score);
            vision.setBgColor(BscScoreColorUtils.getBackgroundColor(score));
            vision.setFontColor(BscScoreColorUtils.getFontColor(score));
        }
    }

    private void processPerspectivesScore(List<VisionVO> visions) throws Exception {
        for (VisionVO vision : visions) {
            for (PerspectiveVO perspective : vision.getPerspectives()) {
                float score = 0.0f;
                for (ObjectiveVO objective : perspective.getObjectives()) {
                    score += objective.getScore() * PerformanceScoreChainUtils.getWeightPercentage(objective.getWeight());
                }
                perspective.setScore(score);
                perspective.setBgColor(BscScoreColorUtils.getBackgroundColor(score));
                perspective.setFontColor(BscScoreColorUtils.getFontColor(score));
            }
        }
    }

    private void processObjectivesScore(List<VisionVO> visions) throws Exception {
        for (VisionVO vision : visions) {
            for (PerspectiveVO perspective : vision.getPerspectives()) {
                for (ObjectiveVO objective : perspective.getObjectives()) {
                    float score = 0.0f;
                    for (KpiVO kpi : objective.getKpis()) {
                        score += kpi.getScore() * PerformanceScoreChainUtils.getWeightPercentage(kpi.getWeight());
                    }
                    objective.setScore(score);
                    objective.setBgColor(BscScoreColorUtils.getBackgroundColor(score));
                    objective.setFontColor(BscScoreColorUtils.getFontColor(score));
                }
            }
        }
    }

    private void processKpisScore(List<VisionVO> visions) throws Exception {
        for (VisionVO vision : visions) {
            for (PerspectiveVO perspective : vision.getPerspectives()) {
                for (ObjectiveVO objective : perspective.getObjectives()) {
                    ExecutorService kpiCalculationPool = Executors.newFixedThreadPool(SimpleUtils.getAvailableProcessors(objective.getKpis().size()));
                    for (KpiVO kpi : objective.getKpis()) {
                        ScoreCalculationCallableData data = new ScoreCalculationCallableData();
                        data.setDefaultMode(true);
                        data.setKpi(kpi);
                        data = kpiCalculationPool.submit(new ScoreCalculationCallable(data)).get();
                    }
                    kpiCalculationPool.shutdown();
                }
            }
        }
    }
}

