/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.bsc.command;

import com.netsteadfast.greenstep.base.BaseChainCommandSupport;
import com.netsteadfast.greenstep.bsc.model.BscMeasureData;
import com.netsteadfast.greenstep.bsc.model.BscStructTreeObj;
import com.netsteadfast.greenstep.bsc.util.BscFormulaUtils;
import com.netsteadfast.greenstep.bsc.util.BscScoreColorUtils;
import com.netsteadfast.greenstep.po.hbm.BbMeasureData;
import com.netsteadfast.greenstep.vo.DateRangeScoreVO;
import com.netsteadfast.greenstep.vo.KpiVO;
import com.netsteadfast.greenstep.vo.ObjectiveVO;
import com.netsteadfast.greenstep.vo.PerspectiveVO;
import com.netsteadfast.greenstep.vo.VisionVO;
import org.apache.commons.chain.Command;
import org.apache.commons.chain.Context;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class PersonalAndOrganizationReportDateRangeScoreCommand
extends BaseChainCommandSupport
implements Command {
    @Override
    public boolean execute(Context context) throws Exception {
        if (this.getResult(context) == null || !(this.getResult(context) instanceof BscStructTreeObj)) {
            return false;
        }
        float total = 0.0f;
        BscStructTreeObj treeObj = (BscStructTreeObj)this.getResult(context);
        String year = StringUtils.defaultString((String)context.get("startYearDate")).trim();
        String dateType = StringUtils.defaultString((String)context.get("dateType")).trim();
        for (VisionVO vision : treeObj.getVisions()) {
            for (PerspectiveVO perspective : vision.getPerspectives()) {
                for (ObjectiveVO objective : perspective.getObjectives()) {
                    for (KpiVO kpi : objective.getKpis()) {
                        this.setDateRangeScore(kpi, dateType, year);
                        total += kpi.getDateRangeScores().get(0).getScore();
                    }
                }
            }
        }
        context.put("total", Float.valueOf(total));
        return false;
    }

    private void setDateRangeScore(KpiVO kpi, String dateType, String year) throws Exception {
        float score = 0.0f;
        String date = String.valueOf(year) + "0101";
        if ("2".equals(dateType)) {
            date = String.valueOf(year) + "0701";
        }
        for (BbMeasureData measureData : kpi.getMeasureDatas()) {
            if (!date.equals(measureData.getDate())) continue;
            BscMeasureData data = new BscMeasureData();
            data.setActual(Float.valueOf(measureData.getActual()));
            data.setTarget(Float.valueOf(measureData.getTarget()));
            data.setKpi(kpi);
            Object value = BscFormulaUtils.parse(kpi.getFormula(), data);
            if (!NumberUtils.isCreatable(String.valueOf(value))) continue;
            score = NumberUtils.toFloat(String.valueOf(value), 0.0f);
        }
        DateRangeScoreVO dateRangeScore = new DateRangeScoreVO();
        dateRangeScore.setDate(date);
        dateRangeScore.setBgColor(BscScoreColorUtils.getBackgroundColor(score));
        dateRangeScore.setFontColor(BscScoreColorUtils.getFontColor(score));
        dateRangeScore.setTarget(kpi.getTarget());
        dateRangeScore.setMin(kpi.getMin());
        dateRangeScore.setScore(score);
        dateRangeScore.setImgIcon("");
        kpi.getDateRangeScores().add(dateRangeScore);
    }
}

