/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.bsc.command;

import com.netsteadfast.greenstep.base.AppContext;
import com.netsteadfast.greenstep.base.BaseChainCommandSupport;
import com.netsteadfast.greenstep.base.model.CustomeOperational;
import com.netsteadfast.greenstep.bsc.model.BscStructTreeObj;
import com.netsteadfast.greenstep.bsc.service.IMeasureDataService;
import com.netsteadfast.greenstep.po.hbm.BbMeasureData;
import com.netsteadfast.greenstep.util.SimpleUtils;
import com.netsteadfast.greenstep.vo.KpiVO;
import com.netsteadfast.greenstep.vo.MeasureDataVO;
import com.netsteadfast.greenstep.vo.ObjectiveVO;
import com.netsteadfast.greenstep.vo.PerspectiveVO;
import com.netsteadfast.greenstep.vo.VisionVO;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.chain.Command;
import org.apache.commons.chain.Context;
import org.apache.commons.lang3.StringUtils;

public class LoadMeasureDataCommand
extends BaseChainCommandSupport
implements Command {
    private IMeasureDataService<MeasureDataVO, BbMeasureData, String> measureDataService;

    @Override
    public boolean execute(Context context) throws Exception {
        this.measureDataService = (IMeasureDataService)AppContext.getBean("bsc.service.MeasureDataService");
        String frequency = (String)context.get("frequency");
        String startYearDate = StringUtils.defaultString((String)context.get("startYearDate")).trim();
        String endYearDate = StringUtils.defaultString((String)context.get("endYearDate")).trim();
        String startDate = StringUtils.defaultString((String)context.get("startDate")).trim();
        String endDate = StringUtils.defaultString((String)context.get("endDate")).trim();
        startDate = startDate.replaceAll("/", "").replaceAll("-", "");
        endDate = endDate.replaceAll("/", "").replaceAll("-", "");
        String date1 = startDate;
        String date2 = endDate;
        if ("4".equals(frequency) || "5".equals(frequency) || "6".equals(frequency)) {
            date1 = String.valueOf(startYearDate) + "0101";
            date2 = String.valueOf(endYearDate) + "12" + SimpleUtils.getMaxDayOfMonth(Integer.parseInt(endYearDate), 12);
        }
        String measureDataOrgaId = (String)context.get("orgId");
        String measureDataEmplId = (String)context.get("empId");
        if (this.getResult(context) == null || !(this.getResult(context) instanceof BscStructTreeObj)) {
            return false;
        }
        BscStructTreeObj treeObj = (BscStructTreeObj)this.getResult(context);
        for (VisionVO vision : treeObj.getVisions()) {
            for (PerspectiveVO perspective : vision.getPerspectives()) {
                for (ObjectiveVO objective : perspective.getObjectives()) {
                    for (KpiVO kpi : objective.getKpis()) {
                        this.fillMeasureData(kpi, frequency, date1, date2, measureDataOrgaId, measureDataEmplId);
                    }
                }
            }
        }
        return false;
    }

    private void fillMeasureData(KpiVO kpi, String frequency, String startDate, String endDate, String orgId, String empId) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        HashMap<String, CustomeOperational> customOperParams = new HashMap<String, CustomeOperational>();
        params.put("kpiId", kpi.getId());
        params.put("frequency", frequency);
        params.put("orgId", orgId);
        params.put("empId", empId);
        CustomeOperational op1 = new CustomeOperational();
        op1.setField("date");
        op1.setOp(">=");
        op1.setValue(startDate);
        CustomeOperational op2 = new CustomeOperational();
        op2.setField("date");
        op2.setOp("<=");
        op2.setValue(endDate);
        customOperParams.put("op1", op1);
        customOperParams.put("op2", op2);
        List<BbMeasureData> measureDatas = this.measureDataService.findListByParams2(params, customOperParams);
        kpi.setMeasureDatas(measureDatas);
    }
}

