/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.base.service.logic;

import com.netsteadfast.greenstep.base.exception.ServiceException;
import com.netsteadfast.greenstep.base.service.logic.BscBaseLogicServiceCommonSupport;
import com.netsteadfast.greenstep.base.service.logic.CoreBaseLogicService;
import com.netsteadfast.greenstep.base.service.logic.IBscBaseLogicServiceCommonProvide;
import com.netsteadfast.greenstep.bsc.service.IEmployeeService;
import com.netsteadfast.greenstep.bsc.service.IOrganizationService;
import com.netsteadfast.greenstep.po.hbm.BbEmployee;
import com.netsteadfast.greenstep.po.hbm.BbOrganization;
import com.netsteadfast.greenstep.vo.EmployeeVO;
import com.netsteadfast.greenstep.vo.OrganizationVO;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;

public abstract class BscBaseLogicService
extends CoreBaseLogicService
implements IBscBaseLogicServiceCommonProvide {
    private IEmployeeService<EmployeeVO, BbEmployee, String> employeeService;
    private IOrganizationService<OrganizationVO, BbOrganization, String> organizationService;

    public IEmployeeService<EmployeeVO, BbEmployee, String> getEmployeeService() {
        return this.employeeService;
    }

    @Autowired
    @Resource(name="bsc.service.EmployeeService")
    @Required
    public void setEmployeeService(IEmployeeService<EmployeeVO, BbEmployee, String> employeeService) {
        this.employeeService = employeeService;
    }

    public IOrganizationService<OrganizationVO, BbOrganization, String> getOrganizationService() {
        return this.organizationService;
    }

    @Autowired
    @Resource(name="bsc.service.OrganizationService")
    @Required
    public void setOrganizationService(IOrganizationService<OrganizationVO, BbOrganization, String> organizationService) {
        this.organizationService = organizationService;
    }

    @Override
    public OrganizationVO findOrganizationData(String oid) throws ServiceException, Exception {
        return BscBaseLogicServiceCommonSupport.findOrganizationData(this.organizationService, oid);
    }

    @Override
    public EmployeeVO findEmployeeData(String oid) throws ServiceException, Exception {
        return BscBaseLogicServiceCommonSupport.findEmployeeData(this.employeeService, oid);
    }

    @Override
    public OrganizationVO findOrganizationDataByUK(String orgId) throws ServiceException, Exception {
        return BscBaseLogicServiceCommonSupport.findOrganizationDataByUK(this.organizationService, orgId);
    }

    @Override
    public EmployeeVO findEmployeeDataByUK(String accountId, String empId) throws ServiceException, Exception {
        return BscBaseLogicServiceCommonSupport.findEmployeeDataByUK(this.employeeService, accountId, empId);
    }

    @Override
    public EmployeeVO findEmployeeDataByAccountId(String accountId) throws ServiceException, Exception {
        return BscBaseLogicServiceCommonSupport.findEmployeeDataByAccountId(this.employeeService, accountId);
    }

    @Override
    public EmployeeVO findEmployeeDataByEmpId(String empId) throws ServiceException, Exception {
        return BscBaseLogicServiceCommonSupport.findEmployeeDataByEmpId(this.employeeService, empId);
    }
}

