/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.form.engine.impl.parser;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.activiti.editor.form.converter.FormJsonConverter;
import org.activiti.form.engine.ActivitiFormException;
import org.activiti.form.engine.FormEngineConfiguration;
import org.activiti.form.engine.impl.context.Context;
import org.activiti.form.engine.impl.io.InputStreamSource;
import org.activiti.form.engine.impl.io.ResourceStreamSource;
import org.activiti.form.engine.impl.io.StreamSource;
import org.activiti.form.engine.impl.io.StringStreamSource;
import org.activiti.form.engine.impl.io.UrlStreamSource;
import org.activiti.form.engine.impl.persistence.entity.FormDeploymentEntity;
import org.activiti.form.engine.impl.persistence.entity.FormEntity;
import org.activiti.form.model.FormDefinition;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FormParse {
    protected static final Logger LOGGER = LoggerFactory.getLogger(FormParse.class);
    protected String name;
    protected boolean validateSchema = true;
    protected StreamSource streamSource;
    protected String sourceSystemId;
    protected FormDefinition formDefinition;
    protected String targetNamespace;
    protected FormDeploymentEntity deployment;
    protected List<FormEntity> forms = new ArrayList<FormEntity>();

    public FormParse deployment(FormDeploymentEntity deployment) {
        this.deployment = deployment;
        return this;
    }

    public FormParse execute(FormEngineConfiguration formEngineConfig) {
        String encoding = formEngineConfig.getXmlEncoding();
        FormJsonConverter converter = new FormJsonConverter();
        try {
            InputStreamReader in = null;
            in = encoding != null ? new InputStreamReader(this.streamSource.getInputStream(), encoding) : new InputStreamReader(this.streamSource.getInputStream());
            String formJson = IOUtils.toString((Reader)in);
            this.formDefinition = converter.convertToForm(formJson, null, 1);
            if (this.formDefinition != null && this.formDefinition.getFields() != null) {
                FormEntity formEntity = (FormEntity)Context.getFormEngineConfiguration().getFormEntityManager().create();
                formEntity.setKey(this.formDefinition.getKey());
                formEntity.setName(this.formDefinition.getName());
                formEntity.setResourceName(this.name);
                formEntity.setDeploymentId(this.deployment.getId());
                formEntity.setParentDeploymentId(this.deployment.getParentDeploymentId());
                formEntity.setDescription(this.formDefinition.getDescription());
                this.forms.add(formEntity);
            }
        }
        catch (Exception e) {
            throw new ActivitiFormException("Error parsing form JSON", e);
        }
        return this;
    }

    public FormParse name(String name) {
        this.name = name;
        return this;
    }

    public FormParse sourceInputStream(InputStream inputStream) {
        if (this.name == null) {
            this.name("inputStream");
        }
        this.setStreamSource(new InputStreamSource(inputStream));
        return this;
    }

    public FormParse sourceUrl(URL url) {
        if (this.name == null) {
            this.name(url.toString());
        }
        this.setStreamSource(new UrlStreamSource(url));
        return this;
    }

    public FormParse sourceUrl(String url) {
        try {
            return this.sourceUrl(new URL(url));
        }
        catch (MalformedURLException e) {
            throw new ActivitiFormException("malformed url: " + url, e);
        }
    }

    public FormParse sourceResource(String resource) {
        if (this.name == null) {
            this.name(resource);
        }
        this.setStreamSource(new ResourceStreamSource(resource));
        return this;
    }

    public FormParse sourceString(String string) {
        if (this.name == null) {
            this.name("string");
        }
        this.setStreamSource(new StringStreamSource(string));
        return this;
    }

    protected void setStreamSource(StreamSource streamSource) {
        if (this.streamSource != null) {
            throw new ActivitiFormException("invalid: multiple sources " + this.streamSource + " and " + streamSource);
        }
        this.streamSource = streamSource;
    }

    public String getSourceSystemId() {
        return this.sourceSystemId;
    }

    public FormParse setSourceSystemId(String sourceSystemId) {
        this.sourceSystemId = sourceSystemId;
        return this;
    }

    public List<FormEntity> getForms() {
        return this.forms;
    }

    public String getTargetNamespace() {
        return this.targetNamespace;
    }

    public FormDeploymentEntity getDeployment() {
        return this.deployment;
    }

    public void setDeployment(FormDeploymentEntity deployment) {
        this.deployment = deployment;
    }

    public FormDefinition getFormDefinition() {
        return this.formDefinition;
    }

    public void setFormDefinition(FormDefinition formDefinition) {
        this.formDefinition = formDefinition;
    }
}

