/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.form.engine.impl.deployer;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.activiti.form.engine.ActivitiFormException;
import org.activiti.form.engine.ActivitiFormIllegalArgumentException;
import org.activiti.form.engine.impl.context.Context;
import org.activiti.form.engine.impl.deployer.ParsedDeployment;
import org.activiti.form.engine.impl.persistence.entity.FormDeploymentEntity;
import org.activiti.form.engine.impl.persistence.entity.FormEntity;
import org.activiti.form.engine.impl.persistence.entity.FormEntityManager;
import org.apache.commons.lang3.StringUtils;

public class FormDeploymentHelper {
    public void verifyFormsDoNotShareKeys(Collection<FormEntity> forms) {
        LinkedHashSet<String> keySet = new LinkedHashSet<String>();
        for (FormEntity form : forms) {
            if (keySet.contains(form.getKey())) {
                throw new ActivitiFormException("The deployment contains forms with the same key, this is not allowed");
            }
            keySet.add(form.getKey());
        }
    }

    public void copyDeploymentValuesToForms(FormDeploymentEntity deployment, List<FormEntity> forms) {
        String tenantId = deployment.getTenantId();
        String deploymentId = deployment.getId();
        for (FormEntity form : forms) {
            if (tenantId != null) {
                form.setTenantId(tenantId);
            }
            form.setDeploymentId(deploymentId);
        }
    }

    public void setResourceNamesOnForms(ParsedDeployment parsedDeployment) {
        for (FormEntity form : parsedDeployment.getAllForms()) {
            String resourceName = parsedDeployment.getResourceForForm(form).getName();
            form.setResourceName(resourceName);
        }
    }

    public FormEntity getMostRecentVersionOfForm(FormEntity form) {
        String key = form.getKey();
        String tenantId = form.getTenantId();
        FormEntityManager formEntityManager = Context.getCommandContext().getFormEngineConfiguration().getFormEntityManager();
        FormEntity existingDefinition = null;
        existingDefinition = tenantId != null && !tenantId.equals("") ? formEntityManager.findLatestFormByKeyAndTenantId(key, tenantId) : formEntityManager.findLatestFormByKey(key);
        return existingDefinition;
    }

    public FormEntity getPersistedInstanceOfForm(FormEntity form) {
        String deploymentId = form.getDeploymentId();
        if (StringUtils.isEmpty((CharSequence)form.getDeploymentId())) {
            throw new ActivitiFormIllegalArgumentException("Provided form must have a deployment id.");
        }
        FormEntityManager formEntityManager = Context.getCommandContext().getFormEngineConfiguration().getFormEntityManager();
        FormEntity persistedForm = null;
        persistedForm = form.getTenantId() == null || "".equals(form.getTenantId()) ? formEntityManager.findFormByDeploymentAndKey(deploymentId, form.getKey()) : formEntityManager.findFormByDeploymentAndKeyAndTenantId(deploymentId, form.getKey(), form.getTenantId());
        return persistedForm;
    }
}

