/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.form.engine.impl.deployer;

import org.activiti.editor.form.converter.FormJsonConverter;
import org.activiti.form.engine.FormEngineConfiguration;
import org.activiti.form.engine.impl.context.Context;
import org.activiti.form.engine.impl.deployer.ParsedDeployment;
import org.activiti.form.engine.impl.persistence.deploy.DeploymentCache;
import org.activiti.form.engine.impl.persistence.deploy.FormCacheEntry;
import org.activiti.form.engine.impl.persistence.entity.FormDeploymentEntity;
import org.activiti.form.engine.impl.persistence.entity.FormEntity;
import org.activiti.form.model.FormDefinition;

public class CachingAndArtifactsManager {
    protected FormJsonConverter formJsonConverter = new FormJsonConverter();

    public void updateCachingAndArtifacts(ParsedDeployment parsedDeployment) {
        FormEngineConfiguration formEngineConfiguration = Context.getFormEngineConfiguration();
        DeploymentCache<FormCacheEntry> formCache = formEngineConfiguration.getDeploymentManager().getFormCache();
        FormDeploymentEntity deployment = parsedDeployment.getDeployment();
        for (FormEntity form : parsedDeployment.getAllForms()) {
            FormDefinition formDefinition = parsedDeployment.getFormDefinitionForForm(form);
            formDefinition.setId(form.getId());
            FormCacheEntry cacheEntry = new FormCacheEntry(form, this.formJsonConverter.convertToJson(formDefinition));
            formCache.add(form.getId(), cacheEntry);
            deployment.addDeployedArtifact(form);
        }
    }
}

