/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.form.engine.impl.cmd;

import java.io.Serializable;
import java.util.List;
import org.activiti.form.api.Form;
import org.activiti.form.engine.ActivitiFormIllegalArgumentException;
import org.activiti.form.engine.ActivitiFormObjectNotFoundException;
import org.activiti.form.engine.impl.FormQueryImpl;
import org.activiti.form.engine.impl.interceptor.Command;
import org.activiti.form.engine.impl.interceptor.CommandContext;
import org.activiti.form.engine.impl.persistence.entity.FormDeploymentEntity;

public class SetDeploymentTenantIdCmd
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String deploymentId;
    protected String newTenantId;

    public SetDeploymentTenantIdCmd(String deploymentId, String newTenantId) {
        this.deploymentId = deploymentId;
        this.newTenantId = newTenantId;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        if (this.deploymentId == null) {
            throw new ActivitiFormIllegalArgumentException("deploymentId is null");
        }
        FormDeploymentEntity deployment = (FormDeploymentEntity)commandContext.getDeploymentEntityManager().findById(this.deploymentId);
        if (deployment == null) {
            throw new ActivitiFormObjectNotFoundException("Could not find deployment with id " + this.deploymentId);
        }
        deployment.setTenantId(this.newTenantId);
        commandContext.getFormEntityManager().updateFormTenantIdForDeployment(this.deploymentId, this.newTenantId);
        List forms = new FormQueryImpl().deploymentId(this.deploymentId).list();
        for (Form form : forms) {
            commandContext.getFormEngineConfiguration().getFormCache().remove(form.getId());
        }
        commandContext.getDeploymentEntityManager().update(deployment);
        return null;
    }
}

