/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.form.engine.impl.cmd;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.activiti.form.engine.ActivitiFormValidationException;
import org.activiti.form.engine.impl.interceptor.Command;
import org.activiti.form.engine.impl.interceptor.CommandContext;
import org.activiti.form.model.FormDefinition;
import org.activiti.form.model.FormField;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.joda.time.LocalDate;

public class GetVariablesFromFormSubmissionCmd
implements Command<Map<String, Object>>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected FormDefinition formDefinition;
    protected Map<String, Object> values;
    protected String outcome;

    public GetVariablesFromFormSubmissionCmd(FormDefinition formDefinition, Map<String, Object> values) {
        this.formDefinition = formDefinition;
        this.values = values;
    }

    public GetVariablesFromFormSubmissionCmd(FormDefinition formDefinition, Map<String, Object> values, String outcome) {
        this(formDefinition, values);
        this.outcome = outcome;
    }

    @Override
    public Map<String, Object> execute(CommandContext commandContext) {
        if (this.values == null) {
            this.values = Collections.emptyMap();
        }
        Map fieldMap = this.formDefinition.allFieldsAsMap();
        HashMap<String, Object> variables = new HashMap<String, Object>();
        for (String fieldId : fieldMap.keySet()) {
            Object variableValue = null;
            FormField formField = (FormField)fieldMap.get(fieldId);
            if ("expression".equals(formField.getType()) || "container".equals(formField.getType())) continue;
            if (this.values.containsKey(fieldId)) {
                variableValue = this.transformFormFieldValueToVariableValue(formField, this.values.get(fieldId));
                variables.put(formField.getId(), variableValue);
            }
            if (!formField.isRequired() || variableValue != null || "upload".equals(formField.getType())) continue;
            throw new ActivitiFormValidationException("Form field " + formField.getId() + " is required, but no value was found");
        }
        if (this.outcome != null) {
            String targetVariable = null;
            targetVariable = this.formDefinition.getOutcomeVariableName() != null ? this.formDefinition.getOutcomeVariableName() : "form_" + this.formDefinition.getKey() + "_outcome";
            variables.put(targetVariable, this.outcome);
        }
        return variables;
    }

    protected Object transformFormFieldValueToVariableValue(FormField formField, Object formFieldValue) {
        Object result = formFieldValue;
        if (formField.getType().equals("date")) {
            if (StringUtils.isNotEmpty((CharSequence)((String)formFieldValue))) {
                try {
                    result = LocalDate.parse((String)((String)formFieldValue));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    result = null;
                }
            }
        } else if (formField.getType().equals("integer") && formFieldValue instanceof String) {
            String strFieldValue = (String)formFieldValue;
            result = StringUtils.isNotEmpty((CharSequence)strFieldValue) && NumberUtils.isNumber((String)strFieldValue) ? Long.valueOf(strFieldValue) : (Long)null;
        } else if (formField.getType().equals("amount") && formFieldValue instanceof String) {
            try {
                result = Double.parseDouble((String)formFieldValue);
            }
            catch (NumberFormatException e) {
                result = null;
            }
        } else if (formField.getType().equals("dropdown")) {
            if (formFieldValue != null && formFieldValue instanceof Map && (result = ((Map)formFieldValue).get("id")) == null) {
                result = ((Map)formFieldValue).get("name");
            }
        } else if (formField.getType().equals("upload")) {
            result = null;
        } else if (formField.getType().equals("people") || formField.getType().equals("functional-group")) {
            Map value;
            Object id;
            result = formFieldValue != null && formFieldValue instanceof Map ? ((id = (value = (Map)formFieldValue).get("id")) instanceof Number ? Long.valueOf(((Number)id).longValue()) : null) : null;
        }
        return result;
    }
}

