/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.form.engine.impl.cmd;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.activiti.form.api.FormDeployment;
import org.activiti.form.api.FormDeploymentQuery;
import org.activiti.form.engine.impl.interceptor.Command;
import org.activiti.form.engine.impl.interceptor.CommandContext;
import org.activiti.form.engine.impl.persistence.entity.FormDeploymentEntity;
import org.activiti.form.engine.impl.persistence.entity.ResourceEntity;
import org.activiti.form.engine.impl.repository.FormDeploymentBuilderImpl;

public class DeployCmd<T>
implements Command<FormDeployment>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected FormDeploymentBuilderImpl deploymentBuilder;

    public DeployCmd(FormDeploymentBuilderImpl deploymentBuilder) {
        this.deploymentBuilder = deploymentBuilder;
    }

    @Override
    public FormDeployment execute(CommandContext commandContext) {
        FormDeploymentEntity deployment = this.deploymentBuilder.getDeployment();
        deployment.setDeploymentTime(commandContext.getFormEngineConfiguration().getClock().getCurrentTime());
        if (this.deploymentBuilder.isDuplicateFilterEnabled()) {
            FormDeploymentEntity existingDeployment;
            ArrayList<FormDeploymentEntity> existingDeployments = new ArrayList<FormDeploymentEntity>();
            if (deployment.getTenantId() == null || "".equals(deployment.getTenantId())) {
                existingDeployment = commandContext.getDeploymentEntityManager().findLatestDeploymentByName(deployment.getName());
                if (existingDeployment != null) {
                    existingDeployments.add(existingDeployment);
                }
            } else {
                List deploymentList = ((FormDeploymentQuery)commandContext.getFormEngineConfiguration().getFormRepositoryService().createDeploymentQuery().deploymentName(deployment.getName()).deploymentTenantId(deployment.getTenantId()).orderByDeploymentId().desc()).list();
                if (!deploymentList.isEmpty()) {
                    existingDeployments.addAll(deploymentList);
                }
            }
            existingDeployment = null;
            if (!existingDeployments.isEmpty()) {
                existingDeployment = (FormDeploymentEntity)existingDeployments.get(0);
            }
            if (existingDeployment != null && !this.deploymentsDiffer(deployment, existingDeployment)) {
                return existingDeployment;
            }
        }
        deployment.setNew(true);
        commandContext.getDeploymentEntityManager().insert(deployment);
        commandContext.getFormEngineConfiguration().getDeploymentManager().deploy(deployment);
        return deployment;
    }

    protected boolean deploymentsDiffer(FormDeploymentEntity deployment, FormDeploymentEntity saved) {
        if (deployment.getResources() == null || saved.getResources() == null) {
            return true;
        }
        Map<String, ResourceEntity> resources = deployment.getResources();
        Map<String, ResourceEntity> savedResources = saved.getResources();
        for (String resourceName : resources.keySet()) {
            byte[] savedBytes;
            ResourceEntity savedResource = savedResources.get(resourceName);
            if (savedResource == null) {
                return true;
            }
            ResourceEntity resource = resources.get(resourceName);
            byte[] bytes = resource.getBytes();
            if (Arrays.equals(bytes, savedBytes = savedResource.getBytes())) continue;
            return true;
        }
        return false;
    }
}

