/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.form.engine.impl;

import org.activiti.form.api.FormRepositoryService;
import org.activiti.form.api.FormService;
import org.activiti.form.engine.FormEngine;
import org.activiti.form.engine.FormEngineConfiguration;
import org.activiti.form.engine.FormEngines;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FormEngineImpl
implements FormEngine {
    private static Logger log = LoggerFactory.getLogger(FormEngineImpl.class);
    protected String name;
    protected FormRepositoryService repositoryService;
    protected FormService formService;
    protected FormEngineConfiguration engineConfiguration;

    public FormEngineImpl(FormEngineConfiguration engineConfiguration) {
        this.engineConfiguration = engineConfiguration;
        this.name = engineConfiguration.getFormEngineName();
        this.repositoryService = engineConfiguration.getFormRepositoryService();
        this.formService = engineConfiguration.getFormService();
        if (this.name == null) {
            log.info("default activiti FormEngine created");
        } else {
            log.info("FormEngine {} created", (Object)this.name);
        }
        FormEngines.registerDmnEngine(this);
    }

    @Override
    public void close() {
        FormEngines.unregister(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public FormRepositoryService getFormRepositoryService() {
        return this.repositoryService;
    }

    @Override
    public FormService getFormService() {
        return this.formService;
    }

    @Override
    public FormEngineConfiguration getFormEngineConfiguration() {
        return this.engineConfiguration;
    }
}

