/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.dmn.service.api.repository;

import java.io.InputStream;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.activiti.dmn.api.DmnDeployment;
import org.activiti.dmn.api.DmnRepositoryService;
import org.activiti.dmn.engine.ActivitiDmnException;
import org.activiti.dmn.engine.ActivitiDmnIllegalArgumentException;
import org.activiti.dmn.engine.ActivitiDmnObjectNotFoundException;
import org.activiti.rest.dmn.common.ContentTypeResolver;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class BaseDmnDeploymentResourceDataResource {
    @Autowired
    protected ContentTypeResolver contentTypeResolver;
    @Autowired
    protected DmnRepositoryService dmnRepositoryService;

    protected byte[] getDmnDeploymentResourceData(String deploymentId, String resourceName, HttpServletResponse response) {
        if (deploymentId == null) {
            throw new ActivitiDmnIllegalArgumentException("No deployment id provided");
        }
        if (resourceName == null) {
            throw new ActivitiDmnIllegalArgumentException("No resource name provided");
        }
        DmnDeployment deployment = (DmnDeployment)this.dmnRepositoryService.createDeploymentQuery().deploymentId(deploymentId).singleResult();
        if (deployment == null) {
            throw new ActivitiDmnObjectNotFoundException("Could not find a DMN deployment with id '" + deploymentId);
        }
        List resourceList = this.dmnRepositoryService.getDeploymentResourceNames(deploymentId);
        if (resourceList.contains(resourceName)) {
            InputStream resourceStream = this.dmnRepositoryService.getResourceAsStream(deploymentId, resourceName);
            String contentType = this.contentTypeResolver.resolveContentType(resourceName);
            response.setContentType(contentType);
            try {
                return IOUtils.toByteArray((InputStream)resourceStream);
            }
            catch (Exception e) {
                throw new ActivitiDmnException("Error converting resource stream", (Throwable)e);
            }
        }
        throw new ActivitiDmnObjectNotFoundException("Could not find a resource with name '" + resourceName + "' in deployment '" + deploymentId);
    }
}

