/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.dmn.common;

import java.util.List;
import java.util.Map;
import org.activiti.dmn.api.Query;
import org.activiti.dmn.api.QueryProperty;
import org.activiti.dmn.engine.ActivitiDmnIllegalArgumentException;
import org.activiti.dmn.engine.impl.AbstractQuery;
import org.activiti.rest.dmn.common.DataResponse;
import org.activiti.rest.dmn.common.PaginateRequest;
import org.activiti.rest.dmn.common.RequestUtil;

public abstract class AbstractDmnPaginateList {
    public DataResponse paginateList(Map<String, String> requestParams, PaginateRequest paginateRequest, Query query, String defaultSort, Map<String, QueryProperty> properties) {
        String order;
        String sort;
        Integer size;
        Integer start;
        if (paginateRequest == null) {
            paginateRequest = new PaginateRequest();
        }
        if (paginateRequest.getStart() == null) {
            paginateRequest.setStart(RequestUtil.getInteger(requestParams, "start", 0));
        }
        if (paginateRequest.getSize() == null) {
            paginateRequest.setSize(RequestUtil.getInteger(requestParams, "size", 10));
        }
        if (paginateRequest.getOrder() == null) {
            paginateRequest.setOrder(requestParams.get("order"));
        }
        if (paginateRequest.getSort() == null) {
            paginateRequest.setSort(requestParams.get("sort"));
        }
        if ((start = paginateRequest.getStart()) == null || start < 0) {
            start = 0;
        }
        if ((size = paginateRequest.getSize()) == null || size < 0) {
            size = 10;
        }
        if ((sort = paginateRequest.getSort()) == null) {
            sort = defaultSort;
        }
        if ((order = paginateRequest.getOrder()) == null) {
            order = "asc";
        }
        if (sort != null && !properties.isEmpty()) {
            QueryProperty qp = properties.get(sort);
            if (qp == null) {
                throw new ActivitiDmnIllegalArgumentException("Value for param 'sort' is not valid, '" + sort + "' is not a valid property");
            }
            ((AbstractQuery)query).orderBy(qp);
            if (order.equals("asc")) {
                query.asc();
            } else if (order.equals("desc")) {
                query.desc();
            } else {
                throw new ActivitiDmnIllegalArgumentException("Value for param 'order' is not valid : '" + order + "', must be 'asc' or 'desc'");
            }
        }
        List list = this.processList(query.listPage(start.intValue(), size.intValue()));
        DataResponse response = new DataResponse();
        response.setStart(start);
        response.setSize(list.size());
        response.setSort(sort);
        response.setOrder(order);
        response.setTotal(query.count());
        response.setData(list);
        return response;
    }

    public DataResponse paginateList(Map<String, String> requestParams, Query query, String defaultSort, Map<String, QueryProperty> properties) {
        return this.paginateList(requestParams, null, query, defaultSort, properties);
    }

    protected abstract List processList(List var1);
}

