/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.ldap;

import java.util.HashMap;
import java.util.Map;
import org.activiti.engine.cfg.AbstractProcessEngineConfigurator;
import org.activiti.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.activiti.engine.impl.persistence.entity.GroupEntityManager;
import org.activiti.engine.impl.persistence.entity.UserEntityManager;
import org.activiti.engine.runtime.ClockReader;
import org.activiti.ldap.LDAPGroupCache;
import org.activiti.ldap.LDAPGroupManager;
import org.activiti.ldap.LDAPQueryBuilder;
import org.activiti.ldap.LDAPUserManager;

public class LDAPConfigurator
extends AbstractProcessEngineConfigurator {
    protected String server;
    protected int port;
    protected String user;
    protected String password;
    protected String initialContextFactory = "com.sun.jndi.ldap.LdapCtxFactory";
    protected String securityAuthentication = "simple";
    protected Map<String, String> customConnectionParameters = new HashMap<String, String>();
    protected String baseDn;
    protected String userBaseDn;
    protected String groupBaseDn;
    protected int searchTimeLimit = 0;
    protected String queryUserByUserId;
    protected String queryGroupsForUser;
    protected String queryUserByFullNameLike;
    protected String userIdAttribute;
    protected String userFirstNameAttribute;
    protected String userLastNameAttribute;
    protected String userEmailAttribute;
    protected String groupIdAttribute;
    protected String groupNameAttribute;
    protected String groupTypeAttribute;
    protected LDAPQueryBuilder ldapQueryBuilder = new LDAPQueryBuilder();
    protected int groupCacheSize = -1;
    protected long groupCacheExpirationTime = 3600000L;
    protected LDAPGroupCache.LDAPGroupCacheListener groupCacheListener;

    public void beforeInit(ProcessEngineConfigurationImpl processEngineConfiguration) {
    }

    public void configure(ProcessEngineConfigurationImpl processEngineConfiguration) {
        processEngineConfiguration.setUserEntityManager((UserEntityManager)new LDAPUserManager(processEngineConfiguration, this));
        LDAPGroupCache ldapGroupCache = null;
        if (this.getGroupCacheSize() > 0) {
            ldapGroupCache = new LDAPGroupCache(this.getGroupCacheSize(), this.getGroupCacheExpirationTime(), (ClockReader)processEngineConfiguration.getClock());
            if (this.groupCacheListener != null) {
                ldapGroupCache.setLdapCacheListener(this.groupCacheListener);
            }
        }
        LDAPGroupManager ldapGroupManager = null;
        ldapGroupManager = ldapGroupCache == null ? new LDAPGroupManager(processEngineConfiguration, this) : new LDAPGroupManager(processEngineConfiguration, this, ldapGroupCache);
        processEngineConfiguration.setGroupEntityManager((GroupEntityManager)ldapGroupManager);
    }

    public String getServer() {
        return this.server;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getInitialContextFactory() {
        return this.initialContextFactory;
    }

    public void setInitialContextFactory(String initialContextFactory) {
        this.initialContextFactory = initialContextFactory;
    }

    public String getSecurityAuthentication() {
        return this.securityAuthentication;
    }

    public void setSecurityAuthentication(String securityAuthentication) {
        this.securityAuthentication = securityAuthentication;
    }

    public Map<String, String> getCustomConnectionParameters() {
        return this.customConnectionParameters;
    }

    public void setCustomConnectionParameters(Map<String, String> customConnectionParameters) {
        this.customConnectionParameters = customConnectionParameters;
    }

    public String getBaseDn() {
        return this.baseDn;
    }

    public void setBaseDn(String baseDn) {
        this.baseDn = baseDn;
    }

    public String getUserBaseDn() {
        return this.userBaseDn;
    }

    public void setUserBaseDn(String userBaseDn) {
        this.userBaseDn = userBaseDn;
    }

    public String getGroupBaseDn() {
        return this.groupBaseDn;
    }

    public void setGroupBaseDn(String groupBaseDn) {
        this.groupBaseDn = groupBaseDn;
    }

    public int getSearchTimeLimit() {
        return this.searchTimeLimit;
    }

    public void setSearchTimeLimit(int searchTimeLimit) {
        this.searchTimeLimit = searchTimeLimit;
    }

    public String getQueryUserByUserId() {
        return this.queryUserByUserId;
    }

    public void setQueryUserByUserId(String queryUserByUserId) {
        this.queryUserByUserId = queryUserByUserId;
    }

    public String getQueryGroupsForUser() {
        return this.queryGroupsForUser;
    }

    public String getQueryUserByFullNameLike() {
        return this.queryUserByFullNameLike;
    }

    public void setQueryUserByFullNameLike(String queryUserByFullNameLike) {
        this.queryUserByFullNameLike = queryUserByFullNameLike;
    }

    public void setQueryGroupsForUser(String queryGroupsForUser) {
        this.queryGroupsForUser = queryGroupsForUser;
    }

    public String getUserIdAttribute() {
        return this.userIdAttribute;
    }

    public void setUserIdAttribute(String userIdAttribute) {
        this.userIdAttribute = userIdAttribute;
    }

    public String getUserFirstNameAttribute() {
        return this.userFirstNameAttribute;
    }

    public void setUserFirstNameAttribute(String userFirstNameAttribute) {
        this.userFirstNameAttribute = userFirstNameAttribute;
    }

    public String getUserLastNameAttribute() {
        return this.userLastNameAttribute;
    }

    public void setUserLastNameAttribute(String userLastNameAttribute) {
        this.userLastNameAttribute = userLastNameAttribute;
    }

    public String getUserEmailAttribute() {
        return this.userEmailAttribute;
    }

    public void setUserEmailAttribute(String userEmailAttribute) {
        this.userEmailAttribute = userEmailAttribute;
    }

    public String getGroupIdAttribute() {
        return this.groupIdAttribute;
    }

    public void setGroupIdAttribute(String groupIdAttribute) {
        this.groupIdAttribute = groupIdAttribute;
    }

    public String getGroupNameAttribute() {
        return this.groupNameAttribute;
    }

    public void setGroupNameAttribute(String groupNameAttribute) {
        this.groupNameAttribute = groupNameAttribute;
    }

    public String getGroupTypeAttribute() {
        return this.groupTypeAttribute;
    }

    public void setGroupTypeAttribute(String groupTypeAttribute) {
        this.groupTypeAttribute = groupTypeAttribute;
    }

    public LDAPQueryBuilder getLdapQueryBuilder() {
        return this.ldapQueryBuilder;
    }

    public void setLdapQueryBuilder(LDAPQueryBuilder ldapQueryBuilder) {
        this.ldapQueryBuilder = ldapQueryBuilder;
    }

    public int getGroupCacheSize() {
        return this.groupCacheSize;
    }

    public void setGroupCacheSize(int groupCacheSize) {
        this.groupCacheSize = groupCacheSize;
    }

    public long getGroupCacheExpirationTime() {
        return this.groupCacheExpirationTime;
    }

    public void setGroupCacheExpirationTime(long groupCacheExpirationTime) {
        this.groupCacheExpirationTime = groupCacheExpirationTime;
    }

    public LDAPGroupCache.LDAPGroupCacheListener getGroupCacheListener() {
        return this.groupCacheListener;
    }

    public void setGroupCacheListener(LDAPGroupCache.LDAPGroupCacheListener groupCacheListener) {
        this.groupCacheListener = groupCacheListener;
    }
}

